/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.block;

import com.google.common.base.Strings;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.block.IExtendedAwarenessBlock;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.common.block.HitBoxHelper;
import shetiphian.endertanks.common.item.ItemEnderBucket;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class BlockEnderTank
extends BaseEntityBlock
implements IColored,
IExtendedAwarenessBlock {
    private static final MapCodec<BlockEnderTank> CODEC = BlockEnderTank.simpleCodec(instance -> new BlockEnderTank());
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Direction[])Direction.values());
    private static final EnumProperty<EnumType> VARIANT = EnumProperty.create((String)"variant", EnumType.class);
    private static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final HashMap<Direction, VoxelShape[]> SHAPES = new HashMap();

    public MapCodec<BlockEnderTank> codec() {
        return CODEC;
    }

    public BlockEnderTank() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ENDER_CHEST).mapColor(MapColor.COLOR_BLACK).destroyTime(5.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT, POWERED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityEnderTank(pos, state);
    }

    private TileEntityEnderTank getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof TileEntityEnderTank ? (TileEntityEnderTank)tile : null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (SHAPES.isEmpty()) {
            Map<Direction, VoxelShape> tank_body = HitBoxHelper.getBody();
            Map<Direction, VoxelShape> top_ring = HitBoxHelper.getRing_Top();
            Map<Direction, VoxelShape> middle_ring = HitBoxHelper.getRing_Middle();
            Map<Direction, VoxelShape> bottom_ring = HitBoxHelper.getRing_Bottom();
            for (Direction direction : Direction.values()) {
                VoxelShape[] shapes = new VoxelShape[]{tank_body.getOrDefault(direction, Shapes.empty()), top_ring.getOrDefault(direction, Shapes.empty()), middle_ring.getOrDefault(direction, Shapes.empty()), bottom_ring.getOrDefault(direction, Shapes.empty())};
                SHAPES.put(direction, shapes);
            }
        }
        if (!SHAPES.isEmpty()) {
            return SHAPES.get(BlockEnderTank.getFacing(state))[0];
        }
        return Shapes.block();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult result = this.onBlockActivated(state, world, pos, player, player.getItemInHand(hand));
        return result == InteractionResult.SUCCESS ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos pos, Player player, ItemStack heldItem) {
        TileEntityEnderTank tankTile = this.getTile((BlockGetter)world, pos);
        if (tankTile == null) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.isEmpty() && !(heldItem.getItem() instanceof ItemEnderBucket) && tankTile.canUse(player) && EnderTanks.PLATFORM.transferFromItem(tankTile, heldItem, player, player.getUsedItemHand()).indicateItemUse()) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            if (tankTile.lastClick <= System.currentTimeMillis()) {
                tankTile.lastClick = System.currentTimeMillis() + 200L;
                if (heldItem.isEmpty() || !(heldItem.getItem() instanceof BlockItem) && !ToolHelper.isWrench((ItemStack)heldItem)) {
                    TankInfoHelper.sendTankInfo(player, tankTile);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.isEmpty()) {
            DyeColor color;
            int subHit;
            if (tankTile.isPublic()) {
                boolean changed = false;
                if (Configs.PROCESSED.listPersonal.contains(heldItem.getItem())) {
                    if (((Boolean)Configs.ACCESS_SETTINGS.allowPersonalTanks.get()).booleanValue()) {
                        changed = true;
                        tankTile.setOwner(player, heldItem.copy().split(1));
                        Helpers.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(VARIANT, (Comparable)((Object)EnumType.PRIVATE))), (boolean)true);
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.private.disabled");
                    }
                }
                if (!changed && Configs.PROCESSED.listTeam.contains(heldItem.getItem())) {
                    if (((Boolean)Configs.ACCESS_SETTINGS.allowTeamTanks.get()).booleanValue()) {
                        String teamID = Helpers.getPlayerTeamID((Player)player);
                        if (!Strings.isNullOrEmpty((String)teamID)) {
                            changed = true;
                            tankTile.setOwner("#" + teamID, heldItem.copy().split(1));
                            Helpers.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(VARIANT, (Comparable)((Object)EnumType.TEAM))), (boolean)true);
                        } else {
                            TankInfoHelper.sendError(player, "shetiphian.team.noteam");
                        }
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.team.disabled");
                    }
                }
                if (changed) {
                    if (!player.getAbilities().instabuild) {
                        heldItem.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (!tankTile.canEdit(player)) {
                return InteractionResult.SUCCESS;
            }
            short capacity = TankHelper.getCapacityInBuckets(world, tankTile.getOwnerID(), tankTile.getCode());
            if (capacity < Configs.PROCESSED.tankSizeMax.get()) {
                int newValue = 0;
                if (Configs.PROCESSED.listSmallCap_Single.contains(heldItem.getItem())) {
                    newValue = -1;
                    if (tankTile.applyItem(heldItem)) {
                        newValue = (Integer)Configs.UPGRADE_SETTINGS.smallCapacity.get();
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                    }
                }
                if (newValue == 0 && Configs.PROCESSED.listSmallCap_Multi.contains(heldItem.getItem())) {
                    newValue = (Integer)Configs.UPGRADE_SETTINGS.smallCapacity.get();
                }
                if (newValue == 0 && capacity + (Integer)Configs.UPGRADE_SETTINGS.largeCapacity.get() <= Configs.PROCESSED.tankSizeMax.get()) {
                    if (Configs.PROCESSED.listLargeCap_Single.contains(heldItem.getItem())) {
                        newValue = -1;
                        if (tankTile.applyItem(heldItem)) {
                            newValue = (Integer)Configs.UPGRADE_SETTINGS.largeCapacity.get();
                        } else {
                            TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                        }
                    }
                    if (newValue == 0 && Configs.PROCESSED.listLargeCap_Multi.contains(heldItem.getItem())) {
                        newValue = (Integer)Configs.UPGRADE_SETTINGS.largeCapacity.get();
                    }
                }
                if (newValue > 0) {
                    TankHelper.setCapacityInBuckets(world, tankTile.getOwnerID(), tankTile.getCode(), (short)(capacity + newValue));
                    if (!player.getAbilities().instabuild) {
                        heldItem.shrink(1);
                    }
                    TankInfoHelper.sendCapacityInfo(player, tankTile);
                    return InteractionResult.SUCCESS;
                }
            }
            if (tankTile.getPumpUpgradeCount() < (Integer)Configs.UPGRADE_SETTINGS.tankPumpMax.get()) {
                boolean upgrade_pump = false;
                if (Configs.PROCESSED.listPump_Single.contains(heldItem.getItem())) {
                    if (tankTile.applyItem(heldItem)) {
                        upgrade_pump = true;
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                    }
                } else if (Configs.PROCESSED.listPump_Multi.contains(heldItem.getItem())) {
                    upgrade_pump = true;
                }
                if (upgrade_pump) {
                    tankTile.addPumpUpgrade(heldItem.copy().split(1));
                    if (!player.getAbilities().instabuild) {
                        heldItem.shrink(1);
                    }
                    TankInfoHelper.sendPumpInfo(player, tankTile);
                    Helpers.syncTile((BlockEntity)tankTile);
                    return InteractionResult.SUCCESS;
                }
            }
            if (((Boolean)Configs.GENERAL.inWorldRecoloring.get()).booleanValue() && (subHit = Helpers.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])SHAPES.get(state.getValue((Property)FACING)))) > 0 && subHit < 4 && (color = DyeHelper.getDyeColor((Item)heldItem.getItem())) != null && tankTile.doColorRing(color, player)) {
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                world.updateNeighborsAt(pos, (Block)this);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null && tile.canEdit(player, false)) {
            return super.getDestroyProgress(state, player, world, pos);
        }
        return -1.0f;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean isPowered = context.getLevel().hasNeighborSignal(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityEnderTank tile = this.getTile((BlockGetter)world, pos);
        if (tile != null) {
            tile.setCode(StackHelper.getCode(stack));
            ItemStack personalItem = StackHelper.getPersonalItem(stack);
            if (!personalItem.isEmpty()) {
                tile.setOwner(StackHelper.getOwnerID(stack), personalItem);
                Helpers.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : EnumType.PRIVATE)))), (boolean)true);
            }
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updatePoweredState(state, world, pos);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighbor, BlockPos fromPos, boolean isMoving) {
        this.updatePoweredState(state, world, pos);
    }

    private void updatePoweredState(BlockState state, Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            TileEntityEnderTank tankTile;
            boolean isPowered = world.hasNeighborSignal(pos);
            if (isPowered && !((Boolean)Configs.UPGRADE_SETTINGS.hasStarterPump.get()).booleanValue() && ((tankTile = this.getTile((BlockGetter)world, pos)) == null || tankTile.getPumpUpgradeCount() < 1)) {
                return;
            }
            if ((Boolean)state.getValue((Property)POWERED) != isPowered) {
                Helpers.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))), (boolean)false);
            }
            if (isPowered) {
                world.scheduleTick(pos, (Block)this, 20);
            }
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.updatePoweredState(state, (Level)world, pos);
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            TileEntityEnderTank tankTile = this.getTile((BlockGetter)world, pos);
            if (tankTile != null && (((Boolean)Configs.UPGRADE_SETTINGS.hasStarterPump.get()).booleanValue() || tankTile.getPumpUpgradeCount() > 0)) {
                Direction tankFacing = BlockEnderTank.getFacing(state);
                BlockPos fromPos = pos.relative(tankFacing.getOpposite());
                BlockPos toPos = pos.relative(tankFacing);
                byte pumpInBuckets = tankTile.getPumpInBuckets();
                EnderContainer enderContainer = tankTile.getEnderContainer();
                HandlerRegistry.getProviders().forEach((key, provider) -> {
                    ITankHandler<?> handler = enderContainer.getOrCreateHandler((String)key);
                    if (handler != null) {
                        handler.preformPumpAction((Level)world, pos, tankFacing, fromPos, toPos, pumpInBuckets, random);
                    }
                });
            }
            world.scheduleTick(pos, (Block)this, 20);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        BlockEntity builderTile = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (builderTile instanceof TileEntityEnderTank) {
            ItemStack personal;
            TileEntityEnderTank tile = (TileEntityEnderTank)builderTile;
            Entity builderEntity = (Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
            if (builderEntity != null && builderEntity.isShiftKeyDown() && !(personal = tile.getPersonalItem()).isEmpty()) {
                drops.forEach(stack -> {
                    if (stack.getItem() == Roster.Items.ENDERTANK.get()) {
                        StackHelper.setOwner(stack, "all");
                    }
                });
                drops.add(personal);
            }
            drops.addAll(tile.getPumpUpgrades());
        }
        return drops;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        TileEntityEnderTank tile = this.getTile((BlockGetter)world, pos);
        if (tile != null) {
            return StackHelper.create(Item.byBlock((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
        }
        return new ItemStack((ItemLike)this);
    }

    public ItemStack getPickBlock(BlockState state, LevelReader world, BlockPos pos, Player player, HitResult target) {
        TileEntityEnderTank tile = this.getTile((BlockGetter)world, pos);
        if (tile != null) {
            if (player != null && !player.isShiftKeyDown()) {
                if (tile.isTeam() && (player.getAbilities().instabuild || tile.getOwnerID().equalsIgnoreCase("#" + Helpers.getPlayerTeamID((Player)player)))) {
                    return StackHelper.create(Item.byBlock((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
                if (!tile.isPublic() && (player.getAbilities().instabuild || tile.getOwnerID().equalsIgnoreCase(player.getUUID().toString()))) {
                    return StackHelper.create(Item.byBlock((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
            }
            return StackHelper.create(Item.byBlock((Block)this), tile.getCode(), null);
        }
        return new ItemStack((ItemLike)this);
    }

    public String getDescriptionId() {
        return "block.endertanks.tank.public";
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        if (rotation != Rotation.NONE) {
            Direction facing = BlockEnderTank.getFacing(state);
            if (rotation == Rotation.CLOCKWISE_180) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)facing.getOpposite());
            }
            int value = facing.ordinal() + (rotation == Rotation.CLOCKWISE_90 ? 1 : -1);
            value = value < 0 ? 5 : (value > 5 ? 0 : value);
            return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.from3DDataValue((int)value));
        }
        return state;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        if (world.isClientSide()) {
            return 0;
        }
        TileEntityEnderTank tile = this.getTile((BlockGetter)world, pos);
        return tile != null ? tile.getComparatorOutput() : 0;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderTank tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile((BlockGetter)data.world, data.pos)) != null) {
            int value = Mth.clamp((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Configs.PROCESSED.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public static Direction getFacing(BlockState state) {
        Direction facing;
        try {
            facing = (Direction)state.getValue((Property)FACING);
        }
        catch (Exception e) {
            facing = Direction.DOWN;
            EnderTanks.LOGGER.error("PropertyEnum 'BlockEnderTank.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + String.valueOf(state));
        }
        return facing;
    }

    public static boolean isPowered(BlockState state) {
        boolean powered;
        try {
            powered = (Boolean)state.getValue((Property)POWERED);
        }
        catch (Exception e) {
            powered = false;
            EnderTanks.LOGGER.error("PropertyEnum 'BlockEnderTank.POWERED' not found in provided BlockState, returning 'false'. Provided BlockState: " + String.valueOf(state));
        }
        return powered;
    }

    public static enum EnumType implements StringRepresentable
    {
        PUBLIC("public"),
        PRIVATE("private"),
        TEAM("team");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

