/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidUtil {
    public static Fluid tryPickupFluid(Player player, Level world, BlockPos pos, Fluid tankFluid) {
        BucketPickup bucketPickup;
        BlockState state;
        Block block;
        Fluid fluid = world.getFluidState(pos).getType();
        if ((tankFluid == Fluids.EMPTY || tankFluid == fluid) && (block = (state = world.getBlockState(pos)).getBlock()) instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).pickupBlock(player, (LevelAccessor)world, pos, state).isEmpty()) {
            return fluid;
        }
        return Fluids.EMPTY;
    }

    public static boolean tryPlaceFluid(Player player, Level world, BlockPos pos, Fluid fluid, Direction side) {
        LiquidBlockContainer container;
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        FlowingFluid flowingFluid = (FlowingFluid)fluid;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        boolean canBeReplaced = state.canBeReplaced(fluid);
        boolean checkReletive = false;
        if (!state.isAir() && !canBeReplaced) {
            checkReletive = block instanceof LiquidBlockContainer ? !(container = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)world, pos, state, fluid) : true;
        }
        if (checkReletive) {
            return side != null && FluidUtil.tryPlaceFluid(player, world, pos.relative(side), fluid, null);
        }
        if (world.dimensionType().ultraWarm() && fluid.is(FluidTags.WATER)) {
            int pX = pos.getX();
            int pY = pos.getY();
            int pZ = pos.getZ();
            world.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            for (int count = 0; count < 8; ++count) {
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pX + Math.random(), (double)pY + Math.random(), (double)pZ + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (fluid == Fluids.WATER && block instanceof LiquidBlockContainer) {
            container = (LiquidBlockContainer)block;
            container.placeLiquid((LevelAccessor)world, pos, state, flowingFluid.getSource(false));
            return true;
        }
        if (!world.isClientSide && canBeReplaced && !state.liquid()) {
            world.destroyBlock(pos, true);
        }
        return world.setBlock(pos, fluid.defaultFluidState().createLegacyBlock(), 11) || state.getFluidState().isSource();
    }
}

