/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Helpers;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.item.ItemEnderBucket;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class EventHandler {
    public static void onTagsUpdated() {
        Configs.CAN_PROCESS_TAGS = true;
        Configs.processTagLists();
    }

    public static InteractionResult onPlayerRightClickBlock(Player player, Level world, BlockPos pos, InteractionHand hand) {
        if (player != null && player.isShiftKeyDown()) {
            BlockState state;
            Block block;
            BlockEntity blockEntity;
            if (player.getMainHandItem().isEmpty() && player.getOffhandItem().is(Items.COMPARATOR) && (blockEntity = world.getBlockEntity(pos)) instanceof TileEntityEnderTank) {
                TileEntityEnderTank tile = (TileEntityEnderTank)blockEntity;
                if (!world.isClientSide() && tile.lastClick <= System.currentTimeMillis()) {
                    tile.lastClick = System.currentTimeMillis() + 200L;
                    if (tile.compareNextHandler(player)) {
                        world.updateNeighborsAt(tile.getBlockPos(), tile.getBlockState().getBlock());
                        Helpers.syncTile((BlockEntity)tile);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            ItemStack heldItem = player.getItemInHand(hand);
            if (!heldItem.isEmpty() && !(heldItem.getItem() instanceof ItemEnderBucket) && (block = (state = world.getBlockState(pos)).getBlock()) instanceof BlockEnderTank) {
                BlockEnderTank enderTank = (BlockEnderTank)block;
                if (EventHandler.isUpgrade(heldItem.getItem()) && enderTank.onBlockActivated(state, world, pos, player, heldItem) == InteractionResult.SUCCESS) {
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean isUpgrade(Item item) {
        return Configs.PROCESSED.listAllUpgrades.contains(item) || DyeHelper.getDyeColor((Item)item) != null;
    }
}

