/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;

public final class EnderFluidHandlerItemStack
extends FluidHandlerItemStack {
    public EnderFluidHandlerItemStack(ItemStack stack) {
        super(null, stack, 0);
    }

    private EnderContainer getEnderContainer() {
        return TankHelper.getTank(null, StackHelper.getOwnerID(this.container), StackHelper.getCode(this.container));
    }

    public FluidStack getFluid() {
        Optional<IFluidHandler> fluidTank = this.getEnderContainer().getTankFor(IFluidHandler.class);
        return fluidTank.map(handler -> handler.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }

    protected void setFluid(FluidStack fluid) {
        EnderContainer enderContainer = this.getEnderContainer();
        IFluidHandler iFluidHandler = enderContainer.getTankFor(IFluidHandler.class).get();
        if (iFluidHandler instanceof FluidTank) {
            FluidTank tank = (FluidTank)iFluidHandler;
            tank.setFluid(fluid);
            enderContainer.notifyContentsChange();
        }
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getEnderContainer().getCapacity();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.container.getCount() != 1 || resource.isEmpty() || resource.getAmount() <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getEnderContainer().getCapacity(), resource.getAmount());
            if (doFill.execute()) {
                FluidStack filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return Math.max(0, fillAmount);
        }
        if (FluidStack.isSameFluidSameComponents((FluidStack)contained, (FluidStack)resource)) {
            int fillAmount = Math.min(this.getEnderContainer().getCapacity() - contained.getAmount(), resource.getAmount());
            if (doFill.execute() && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return Math.max(0, fillAmount);
        }
        return 0;
    }

    protected void setContainerToEmpty() {
        this.getEnderContainer().getTankFor(IFluidHandler.class).ifPresent(fluidTank -> fluidTank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE));
    }
}

