/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Helpers;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.common.block.BlockEnderTank;

public class EventHandlerClient {
    private static final Queue<Component> queuedMessage = new ArrayDeque<Component>();
    private static long timer;

    public static void setDelayedMessage(Component ... message) {
        queuedMessage.clear();
        timer = 0L;
        queuedMessage.addAll(Arrays.asList(message));
    }

    public static void onHudRenderTick() {
        if (!queuedMessage.isEmpty() && timer <= System.currentTimeMillis()) {
            timer = System.currentTimeMillis() + (long)((Integer)Configs.GENERAL.lineChangeDelay.get()).intValue();
            LocalPlayer player = Minecraft.getInstance().player;
            Component message = queuedMessage.poll();
            if (player != null && message != null) {
                player.displayClientMessage(message, true);
            }
        }
    }

    void onDrawBlockHighlight(BlockHitResult target, PoseStack matrix, MultiBufferSource buffers, Camera camera) {
        VoxelShape shape;
        BlockPos pos;
        if (target == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !player.isShiftKeyDown() || player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty()) {
            return;
        }
        Level world = player.level();
        BlockState state = world.getBlockState(pos = target.getBlockPos());
        if (state.getBlock() instanceof BlockEnderTank && world.getWorldBorder().isWithinBounds(pos) && !(shape = this.getShapeToOutline((Player)player, state, world, pos)).isEmpty()) {
            this.drawSelectionBox(matrix, buffers.getBuffer(RenderType.lines()), camera, pos, shape);
        }
    }

    private VoxelShape getShapeToOutline(Player player, BlockState state, Level world, BlockPos pos) {
        for (InteractionHand hand : InteractionHand.values()) {
            Item item = player.getItemInHand(hand).getItem();
            if (Configs.PROCESSED.listPersonal.contains(item) || Configs.PROCESSED.listTeam.contains(item) || Configs.PROCESSED.listSmallCap_Single.contains(item) || Configs.PROCESSED.listSmallCap_Multi.contains(item) || Configs.PROCESSED.listLargeCap_Single.contains(item) || Configs.PROCESSED.listLargeCap_Multi.contains(item)) {
                return state.getShape((BlockGetter)world, pos);
            }
            if (!DyeHelper.isDye((Item)item) || BlockEnderTank.SHAPES.isEmpty()) continue;
            VoxelShape[] shapes = BlockEnderTank.SHAPES.get(state.getValue((Property)BlockEnderTank.FACING));
            int subHit = Helpers.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])shapes);
            return subHit > 0 && subHit < 4 ? shapes[subHit] : Shapes.empty();
        }
        return Shapes.empty();
    }

    private void drawSelectionBox(PoseStack matrix, VertexConsumer buffer, Camera info, BlockPos pos, VoxelShape shape) {
        double d0 = info.getPosition().x;
        double d1 = info.getPosition().y;
        double d2 = info.getPosition().z;
        float mul = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        if (mul > 1.0f) {
            mul = 2.0f - mul;
        }
        this.drawShape(matrix, buffer, shape, (double)pos.getX() - d0, (double)pos.getY() - d1, (double)pos.getZ() - d2, mul, mul, mul, 0.4f);
    }

    private void drawShape(PoseStack matrix, VertexConsumer buffer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = matrix.last();
        shape.forAllEdges((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float nX = (float)(maxX - minX);
            float nY = (float)(maxY - minY);
            float nZ = (float)(maxZ - minZ);
            float sqrt = Mth.sqrt((float)(nX * nX + nY * nY + nZ * nZ));
            buffer.addVertex(pose.pose(), (float)(minX + x), (float)(minY + y), (float)(minZ + z)).setColor(red, green, blue, alpha).setNormal(pose, nX /= sqrt, nY /= sqrt, nZ /= sqrt);
            buffer.addVertex(pose.pose(), (float)(maxX + x), (float)(maxY + y), (float)(maxZ + z)).setColor(red, green, blue, alpha).setNormal(pose, nX, nY, nZ);
        });
    }
}

