/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.api;

import com.google.common.base.Strings;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResultHolder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import shetiphian.endertanks.api.HandlerRegistry;

public final class MissingHandlerEvent
extends Event
implements ICancellableEvent {
    private final String providerId;
    private final CompoundTag saveData;
    private InteractionResultHolder<String> resultHolder = InteractionResultHolder.pass((Object)"");

    public MissingHandlerEvent(String providerId, CompoundTag saveData) {
        this.providerId = providerId;
        this.saveData = saveData;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public CompoundTag getSaveData() {
        return this.saveData;
    }

    public Set<String> getProviderSet() {
        return HandlerRegistry.getProviders().keySet();
    }

    public <T extends HandlerRegistry.ITankHandlerProvider<?>> boolean setProvider(Class<T> type) {
        return this.setProvider(HandlerRegistry.getProviderId(type));
    }

    public boolean setProvider(String providerId) {
        if (!Strings.isNullOrEmpty((String)providerId) && this.getProviderSet().contains(providerId)) {
            this.resultHolder = InteractionResultHolder.success((Object)providerId);
            this.setCanceled(true);
            return true;
        }
        return false;
    }

    public void setIgnored() {
        this.resultHolder = InteractionResultHolder.consume((Object)"");
        this.setCanceled(true);
    }

    public void deleteData() {
        this.resultHolder = InteractionResultHolder.fail((Object)"");
        this.setCanceled(true);
    }

    public InteractionResultHolder<String> getResult() {
        return this.resultHolder;
    }
}

