/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import shetiphian.core.platform.Services;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;

public class HandlerRegistry {
    private static final HashMap<String, ITankHandlerProvider<?>> PROVIDERS = new HashMap();
    private static final HashMap<String, String> LOOKUP = new HashMap();
    public static final ResourceLocation DEFAULT_KEY = EnderTanks.RESOURCE.apply(Services.PLATFORM.getPlatformName().toLowerCase() + "_fluid");

    public static <T> boolean register(ResourceLocation id, Class<T> type, ITankHandlerProvider<T> provider) {
        return HandlerRegistry.registerUnbound(id, type, provider);
    }

    public static <T, S> boolean registerUnbound(ResourceLocation id, Class<T> type, ITankHandlerProvider<S> provider) {
        String typeName = HandlerRegistry.getTypeKey(type);
        String providerId = id.toString();
        if (!PROVIDERS.containsKey(providerId) && !LOOKUP.containsKey(typeName)) {
            PROVIDERS.put(providerId, provider);
            LOOKUP.put(typeName, providerId);
            return true;
        }
        return false;
    }

    public static Map<String, ITankHandlerProvider<?>> getProviders() {
        return Collections.unmodifiableMap(PROVIDERS);
    }

    public static ITankHandler<?> createHandlerFor(Class<?> type, IEnderTankInfo tank) {
        String providerId = HandlerRegistry.getProviderId(type);
        return providerId != null ? HandlerRegistry.createHandlerFor(providerId, tank) : null;
    }

    public static ITankHandler<?> createHandlerFor(String providerId, IEnderTankInfo tank) {
        ITankHandlerProvider<?> provider = PROVIDERS.get(providerId);
        return provider != null ? provider.create(tank) : null;
    }

    private static String getTypeKey(Class<?> type) {
        return type.getName().intern();
    }

    public static String getProviderId(Class<?> type) {
        return HandlerRegistry.getProviderId(HandlerRegistry.getTypeKey(type));
    }

    public static String getProviderId(String type) {
        return LOOKUP.get(type);
    }

    public static interface ITankHandlerProvider<Type> {
        public ITankHandler<Type> create(IEnderTankInfo var1);
    }
}

