/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.neoforge.config;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.config.IIcebergConfigSpec;
import com.anthonyhilyard.iceberg.neoforge.config.ConfigValueWrapper;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.util.UnsafeUtil;
import com.electronwill.nightconfig.core.AbstractCommentedConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.fml.Logging;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class NeoForgeIcebergConfigSpec
implements IConfigSpec,
IIcebergConfigSpec {
    private final Map<List<String>, String> levelComments;
    private final Map<List<String>, String> levelTranslationKeys;
    private final UnmodifiableConfig spec;
    private final UnmodifiableConfig values;
    @Nullable
    private IConfigSpec.ILoadedConfig loadedConfig;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    private NeoForgeIcebergConfigSpec(UnmodifiableConfig spec, UnmodifiableConfig values, Map<List<String>, String> levelComments, Map<List<String>, String> levelTranslationKeys) {
        this.spec = Config.copy((UnmodifiableConfig)spec);
        this.values = Config.copy((UnmodifiableConfig)values);
        this.levelComments = Map.copyOf(levelComments);
        this.levelTranslationKeys = Map.copyOf(levelTranslationKeys);
        try {
            Field exceptionHandlerField = FileWatcher.class.getDeclaredField("exceptionHandler");
            UnsafeUtil.setField(exceptionHandlerField, FileWatcher.defaultInstance(), e -> LogManager.getLogger().warn(Logging.CORE, "An error occurred while reloading config:", (Throwable)e));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmpty() {
        return this.spec.isEmpty();
    }

    public String getLevelComment(List<String> path) {
        return this.levelComments.get(path);
    }

    public String getLevelTranslationKey(List<String> path) {
        return this.levelTranslationKeys.get(path);
    }

    public void acceptConfig(@Nullable IConfigSpec.ILoadedConfig config) {
        this.loadedConfig = config;
        if (config != null && !this.isCorrect((UnmodifiableCommentedConfig)config.config())) {
            String string;
            CommentedConfig commentedConfig = config.config();
            if (commentedConfig instanceof FileConfig) {
                FileConfig fileConfig = (FileConfig)commentedConfig;
                string = fileConfig.getNioPath().toString();
            } else {
                string = config.toString();
            }
            String configName = string;
            Iceberg.LOGGER.warn("Configuration file {} is not correct. Correcting ", (Object)configName);
            this.correct(config.config(), (action, path, incorrectValue, correctedValue) -> Iceberg.LOGGER.warn("Incorrect key {} was corrected from {} to its default, {}. {}", (Object)DOT_JOINER.join((Iterable)path), incorrectValue, correctedValue, (Object)(incorrectValue == correctedValue ? "This seems to be an error." : "")), (action, path, incorrectValue, correctedValue) -> Iceberg.LOGGER.debug("The comment on key {} does not match the spec. This may create a backup.", (Object)DOT_JOINER.join((Iterable)path)));
            config.save();
        }
        this.afterReload();
    }

    public void validateSpec(ModConfig config) {
    }

    @Override
    public boolean isLoaded() {
        return this.loadedConfig != null;
    }

    public UnmodifiableConfig getSpec() {
        return this.spec;
    }

    public UnmodifiableConfig getValues() {
        return this.values;
    }

    private void forEachValue(Iterable<Object> configValues, Consumer<ModConfigSpec.ConfigValue<?>> consumer) {
        configValues.forEach(value -> {
            if (value instanceof ModConfigSpec.ConfigValue) {
                ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)value;
                consumer.accept(configValue);
            } else if (value instanceof Config) {
                Config innerConfig = (Config)value;
                this.forEachValue(innerConfig.valueMap().values(), consumer);
            }
        });
    }

    public void afterReload() {
        this.resetCaches(ModConfigSpec.RestartType.NONE);
    }

    @ApiStatus.Internal
    public void resetCaches(ModConfigSpec.RestartType restartType) {
        this.forEachValue(this.getValues().valueMap().values(), configValue -> {
            if (configValue.getSpec() == null || configValue.getSpec().restartType() == restartType) {
                configValue.clearCache();
            }
        });
    }

    public void save() {
        Preconditions.checkNotNull((Object)this.loadedConfig, (Object)"Cannot save config value without assigned Config object present");
        this.loadedConfig.save();
    }

    public boolean isCorrect(UnmodifiableCommentedConfig config) {
        LinkedList parentPath = Lists.newLinkedList();
        return this.correct(this.spec, config, parentPath, Collections.unmodifiableList(parentPath), (a, b, c, d) -> {}, null, true) == 0;
    }

    public void correct(CommentedConfig config) {
        this.correct(config, (action, path, incorrectValue, correctedValue) -> {}, null);
    }

    public int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener) {
        return this.correct(config, listener, null);
    }

    public int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener) {
        LinkedList parentPath = Lists.newLinkedList();
        return this.correct(this.spec, (UnmodifiableCommentedConfig)config, parentPath, Collections.unmodifiableList(parentPath), listener, commentListener, false);
    }

    private int correct(UnmodifiableConfig spec, UnmodifiableCommentedConfig config, LinkedList<String> parentPath, List<String> parentPathUnmodifiable, ConfigSpec.CorrectionListener listener, @Nullable ConfigSpec.CorrectionListener commentListener, boolean dryRun) {
        int count = 0;
        Map specMap = spec.valueMap();
        Map configMap = config.valueMap();
        for (Map.Entry specEntry : specMap.entrySet()) {
            ModConfigSpec.ValueSpec valueSpec;
            String key = (String)specEntry.getKey();
            Object specValue = specEntry.getValue();
            Object configValue = configMap.get(key);
            ConfigSpec.CorrectionAction action = configValue == null ? ConfigSpec.CorrectionAction.ADD : ConfigSpec.CorrectionAction.REPLACE;
            parentPath.addLast(key);
            String subConfigComment = null;
            if (specValue instanceof ModConfigSpec.ValueSpec && (valueSpec = (ModConfigSpec.ValueSpec)specValue).getDefault() instanceof UnmodifiableConfig) {
                subConfigComment = valueSpec.getComment();
                specValue = valueSpec.getDefault();
            }
            if (specValue instanceof Config) {
                Config specConfig = (Config)specValue;
                if (configValue instanceof Config) {
                    CommentedConfig commentedConfig;
                    if ((count += this.correct((UnmodifiableConfig)specConfig, (UnmodifiableCommentedConfig)(configValue instanceof CommentedConfig ? (commentedConfig = (CommentedConfig)configValue) : CommentedConfig.copy((UnmodifiableConfig)((Config)configValue))), parentPath, parentPathUnmodifiable, listener, commentListener, dryRun)) > 0 && dryRun) {
                        return count;
                    }
                } else {
                    if (dryRun) {
                        return 1;
                    }
                    newValue = ((CommentedConfig)config).createSubConfig();
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                    if (specConfig instanceof MutableSubconfig) {
                        specConfig.valueMap().forEach((arg_0, arg_1) -> NeoForgeIcebergConfigSpec.lambda$correct$7((CommentedConfig)newValue, arg_0, arg_1));
                    } else {
                        count += this.correct((UnmodifiableConfig)specValue, (UnmodifiableCommentedConfig)newValue, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun);
                    }
                }
                String newComment = subConfigComment == null ? this.levelComments.get(parentPath) : subConfigComment;
                String oldComment = config.getComment(key);
                if (!this.stringsMatchNormalizingNewLines(oldComment, newComment)) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)newComment);
                    }
                    if (dryRun) {
                        return 1;
                    }
                    ((CommentedConfig)config).setComment(key, newComment);
                }
            } else if (specValue instanceof ModConfigSpec.ValueSpec) {
                String oldComment;
                ModConfigSpec.ValueSpec valueSpec2 = (ModConfigSpec.ValueSpec)specValue;
                if (!valueSpec2.test(configValue)) {
                    if (dryRun) {
                        return 1;
                    }
                    newValue = valueSpec2.correct(configValue);
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                }
                if (!this.stringsMatchNormalizingNewLines(oldComment = config.getComment(key), valueSpec2.getComment())) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)valueSpec2.getComment());
                    }
                    if (dryRun) {
                        return 1;
                    }
                    ((CommentedConfig)config).setComment(key, valueSpec2.getComment());
                }
            } else if (spec instanceof MutableSubconfig) {
                MutableSubconfig subconfig = (MutableSubconfig)spec;
                if (configMap.containsKey(key)) {
                    if (!subconfig.keyValidator().test(key)) {
                        if (dryRun) {
                            return 1;
                        }
                        listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, (Object)key, null);
                        configMap.remove(key);
                        ++count;
                    }
                    if (!subconfig.valueValidator().test(configMap.get(key))) {
                        if (dryRun) {
                            return 1;
                        }
                        listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, configMap.get(key), null);
                        configMap.remove(key);
                        ++count;
                    }
                }
            }
            parentPath.removeLast();
        }
        Iterator iterator = configMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (spec instanceof MutableSubconfig || specMap.containsKey(entry.getKey())) continue;
            if (dryRun) {
                return 1;
            }
            iterator.remove();
            parentPath.addLast((String)entry.getKey());
            listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, entry.getValue(), null);
            parentPath.removeLast();
            ++count;
        }
        return count;
    }

    private boolean stringsMatchNormalizingNewLines(@Nullable String string1, @Nullable String string2) {
        boolean blank2;
        boolean blank1 = string1 == null || string1.isBlank();
        boolean bl = blank2 = string2 == null || string2.isBlank();
        if (blank1 != blank2) {
            return false;
        }
        if (blank1 && blank2) {
            return true;
        }
        return string1.replaceAll("\r\n", "\n").equals(string2.replaceAll("\r\n", "\n"));
    }

    public static ModConfigSpec.ValueSpec createValueSpec(String comment, String langKey, boolean worldRestart, Class<?> clazz, Supplier<?> defaultSupplier, Predicate<Object> validator, ModConfigSpec.RestartType restartType) {
        Objects.requireNonNull(defaultSupplier, "Default supplier can not be null!");
        Objects.requireNonNull(validator, "Validator can not be null!");
        ModConfigSpec.ValueSpec result = UnsafeUtil.newInstance(ModConfigSpec.ValueSpec.class);
        try {
            Field commentField = ModConfigSpec.ValueSpec.class.getDeclaredField("comment");
            Field langKeyField = ModConfigSpec.ValueSpec.class.getDeclaredField("langKey");
            Field rangeField = ModConfigSpec.ValueSpec.class.getDeclaredField("range");
            Field worldRestartField = ModConfigSpec.ValueSpec.class.getDeclaredField("worldRestart");
            Field clazzField = ModConfigSpec.ValueSpec.class.getDeclaredField("clazz");
            Field supplierField = ModConfigSpec.ValueSpec.class.getDeclaredField("supplier");
            Field validatorField = ModConfigSpec.ValueSpec.class.getDeclaredField("validator");
            Field restartTypeField = ModConfigSpec.ValueSpec.class.getDeclaredField("restartType");
            UnsafeUtil.setField(commentField, result, comment);
            UnsafeUtil.setField(langKeyField, result, langKey);
            UnsafeUtil.setField(rangeField, result, null);
            UnsafeUtil.setField(worldRestartField, result, worldRestart);
            UnsafeUtil.setField(clazzField, result, clazz);
            UnsafeUtil.setField(supplierField, result, defaultSupplier);
            UnsafeUtil.setField(validatorField, result, validator);
            UnsafeUtil.setField(restartTypeField, result, restartType);
        }
        catch (Exception e) {
            Iceberg.LOGGER.warn("Failed to instantiate ValueSpec!");
            Iceberg.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }

    public IConfigSpec.ILoadedConfig loadedConfig() {
        return this.loadedConfig;
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    private static /* synthetic */ void lambda$correct$7(CommentedConfig newValue, String k, Object v) {
        Object object;
        Map map = newValue.valueMap();
        if (v instanceof ModConfigSpec.ValueSpec) {
            ModConfigSpec.ValueSpec vSpec = (ModConfigSpec.ValueSpec)v;
            object = vSpec.getDefault();
        } else {
            object = v;
        }
        map.put(k, object);
    }

    public static final class MutableSubconfig
    extends AbstractCommentedConfig {
        private final ConfigFormat<?> configFormat;
        private final Predicate<Object> keyValidator;
        private final Predicate<Object> valueValidator;
        private static ModConfigSpec.ValueSpec defaultValueSpec = null;

        MutableSubconfig(UnmodifiableConfig toCopy, ConfigFormat<?> configFormat, boolean concurrent, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            super(toCopy, concurrent);
            this.configFormat = configFormat;
            this.keyValidator = keyValidator;
            this.valueValidator = valueValidator;
        }

        public ModConfigSpec.ValueSpec defaultValueSpec() {
            if (defaultValueSpec == null) {
                defaultValueSpec = NeoForgeIcebergConfigSpec.createValueSpec(null, null, false, Object.class, () -> null, this.valueValidator, ModConfigSpec.RestartType.NONE);
            }
            return defaultValueSpec;
        }

        public ConfigFormat<?> configFormat() {
            return this.configFormat;
        }

        public Predicate<Object> keyValidator() {
            return this.keyValidator;
        }

        public Predicate<Object> valueValidator() {
            return this.valueValidator;
        }

        public static MutableSubconfig copy(UnmodifiableConfig config, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return new MutableSubconfig(config, config.configFormat(), false, keyValidator, valueValidator);
        }

        public CommentedConfig createSubConfig() {
            throw new UnsupportedOperationException("Can't make a subconfig of a mutable subconfig!");
        }

        public AbstractCommentedConfig clone() {
            throw new UnsupportedOperationException("Can't clone a mutable subconfig!");
        }
    }

    public static class Builder
    extends ModConfigSpec.Builder
    implements IIcebergConfigSpecBuilder {
        @Override
        public Builder comment(String comment) {
            return (Builder)super.comment(comment);
        }

        @Override
        public Builder comment(String ... comment) {
            return (Builder)super.comment(comment);
        }

        @Override
        public Builder translation(String translationKey) {
            return (Builder)super.translation(translationKey);
        }

        public Builder worldRestart() {
            return (Builder)super.worldRestart();
        }

        @Override
        public Builder push(String path) {
            return (Builder)super.push(path);
        }

        @Override
        public Builder push(List<String> path) {
            return (Builder)super.push(path);
        }

        @Override
        public Builder pop() {
            return (Builder)super.pop();
        }

        public Builder pop(int count) {
            return (Builder)super.pop(count);
        }

        private NeoForgeIcebergConfigSpec finishBuild() {
            NeoForgeIcebergConfigSpec result = null;
            try {
                Field valuesField = ModConfigSpec.Builder.class.getDeclaredField("values");
                Field storageField = ModConfigSpec.Builder.class.getDeclaredField("spec");
                Field levelCommentsField = ModConfigSpec.Builder.class.getDeclaredField("levelComments");
                Field levelTranslationKeysField = ModConfigSpec.Builder.class.getDeclaredField("levelTranslationKeys");
                List values = (List)UnsafeUtil.getField(valuesField, this);
                Config storage = (Config)UnsafeUtil.getField(storageField, this);
                Map levelComments = (Map)UnsafeUtil.getField(levelCommentsField, this);
                Map levelTranslationKeys = (Map)UnsafeUtil.getField(levelTranslationKeysField, this);
                Config valueCfg = Config.of((Supplier)Config.getDefaultMapCreator((boolean)true, (boolean)true), (ConfigFormat)InMemoryFormat.withSupport(ModConfigSpec.ConfigValue.class::isAssignableFrom));
                values.forEach(v -> valueCfg.set(v.getPath(), v));
                NeoForgeIcebergConfigSpec ret = new NeoForgeIcebergConfigSpec(storage.unmodifiable(), valueCfg.unmodifiable(), Collections.unmodifiableMap(levelComments), Collections.unmodifiableMap(levelTranslationKeys));
                Field specField = ModConfigSpec.ConfigValue.class.getDeclaredField("spec");
                values.forEach(v -> UnsafeUtil.setField(specField, v, ret));
                result = ret;
            }
            catch (Exception e) {
                Iceberg.LOGGER.warn("Failed to build NeoForgeIcebergConfigSpec!");
                Iceberg.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
            }
            return result;
        }

        @Override
        public void reset() {
            try {
                Field valuesField = ModConfigSpec.Builder.class.getDeclaredField("values");
                Field storageField = ModConfigSpec.Builder.class.getDeclaredField("spec");
                Field levelCommentsField = ModConfigSpec.Builder.class.getDeclaredField("levelComments");
                Field levelTranslationKeysField = ModConfigSpec.Builder.class.getDeclaredField("levelTranslationKeys");
                List values = (List)UnsafeUtil.getField(valuesField, this);
                Config storage = (Config)UnsafeUtil.getField(storageField, this);
                Map levelComments = (Map)UnsafeUtil.getField(levelCommentsField, this);
                Map levelTranslationKeys = (Map)UnsafeUtil.getField(levelTranslationKeysField, this);
                storage.clear();
                levelComments.clear();
                levelTranslationKeys.clear();
                values.clear();
            }
            catch (Exception e) {
                Iceberg.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }

        @Override
        public <T> Pair<T, IIcebergConfigSpec> finish(Function<IIcebergConfigSpecBuilder, T> consumer) {
            T o = consumer.apply(this);
            return Pair.of(o, (Object)this.finishBuild());
        }

        private <T, S extends ModConfigSpec.ConfigValue<T>> ConfigValueWrapper<T, S> wrap(S value) {
            return new ConfigValueWrapper(value);
        }

        @Override
        public <T> Supplier<T> add(String path, T defaultValue) {
            ModConfigSpec.ConfigValue value = this.define(path, defaultValue);
            return () -> this.wrap(value).get();
        }

        @Override
        public <T> Supplier<T> add(String path, T defaultValue, Predicate<Object> validator) {
            ModConfigSpec.ConfigValue value = this.define(path, defaultValue, validator);
            return () -> this.wrap(value).get();
        }

        @Override
        public <V extends Comparable<? super V>> Supplier<V> addInRange(String path, V defaultValue, V min, V max, Class<V> clazz) {
            ModConfigSpec.ConfigValue value = this.defineInRange(path, defaultValue, min, max, clazz);
            return () -> (Comparable)this.wrap(value).get();
        }

        @Override
        public <T> Supplier<T> addInList(String path, T defaultValue, Collection<? extends T> acceptableValues) {
            ModConfigSpec.ConfigValue value = this.defineInList(path, defaultValue, acceptableValues);
            return () -> this.wrap(value).get();
        }

        @Override
        public <T> Supplier<List<? extends T>> addList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            ModConfigSpec.ConfigValue value = this.defineList(path, defaultValue, elementValidator);
            return () -> (List)this.wrap(value).get();
        }

        @Override
        public <T> Supplier<List<? extends T>> addListAllowEmpty(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            ModConfigSpec.ConfigValue value = this.defineListAllowEmpty(path, defaultValue, elementValidator);
            return () -> (List)this.wrap(value).get();
        }

        @Override
        public <V extends Enum<V>> Supplier<V> addEnum(String path, V defaultValue) {
            ModConfigSpec.EnumValue value = this.defineEnum(path, defaultValue);
            return () -> (Enum)this.wrap(value).get();
        }

        @Override
        public <V extends Enum<V>> Supplier<V> addEnum(String path, V defaultValue, Predicate<Object> validator) {
            ModConfigSpec.EnumValue value = this.defineEnum(path, defaultValue, validator);
            return () -> (Enum)this.wrap(value).get();
        }

        @Override
        public Supplier<Boolean> add(String path, boolean defaultValue) {
            ModConfigSpec.BooleanValue value = this.define(path, defaultValue);
            return () -> (Boolean)this.wrap(value).get();
        }

        @Override
        public Supplier<Double> addInRange(String path, double defaultValue, double min, double max) {
            ModConfigSpec.DoubleValue value = this.defineInRange(path, defaultValue, min, max);
            return () -> (Double)this.wrap(value).get();
        }

        @Override
        public Supplier<Integer> addInRange(String path, int defaultValue, int min, int max) {
            ModConfigSpec.IntValue value = this.defineInRange(path, defaultValue, min, max);
            return () -> (Integer)this.wrap(value).get();
        }

        @Override
        public Supplier<Long> addInRange(String path, long defaultValue, long min, long max) {
            ModConfigSpec.LongValue value = this.defineInRange(path, defaultValue, min, max);
            return () -> (Long)this.wrap(value).get();
        }

        @Override
        public Supplier<Map<String, Object>> addSubconfig(String path, Map<String, Object> defaultValue, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.addSubconfig(NeoForgeIcebergConfigSpec.split(path), defaultValue, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(List<String> path, Map<String, Object> defaultValue, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.addSubconfig(path, () -> defaultValue, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(String path, Supplier<Map<String, Object>> defaultSupplier, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.addSubconfig(NeoForgeIcebergConfigSpec.split(path), defaultSupplier, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(List<String> path, Supplier<Map<String, Object>> defaultSupplier, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            Config defaultConfig = Config.of(defaultSupplier, (ConfigFormat)TomlFormat.instance());
            ModConfigSpec.ConfigValue value = this.define(path, () -> Builder.lambda$addSubconfig$15((UnmodifiableConfig)defaultConfig, keyValidator, valueValidator), o -> o != null);
            return () -> ((Config)this.wrap(value).get()).valueMap();
        }

        private static /* synthetic */ Config lambda$addSubconfig$15(UnmodifiableConfig defaultConfig, Predicate keyValidator, Predicate valueValidator) {
            return MutableSubconfig.copy(defaultConfig, keyValidator, valueValidator);
        }
    }
}

