/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.features;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.util.features.FeatureLogic;

@Deprecated
public final class FeatureUtil {
    private static final Direction[] directionsExceptDown = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static boolean isAreaSuitable(WorldGenLevel world, BlockPos pos, int xWidth, int height, int zWidth) {
        return FeatureUtil.isAreaSuitable(world, pos, xWidth, height, zWidth, false);
    }

    public static boolean isAreaSuitable(WorldGenLevel world, BlockPos pos, int xWidth, int height, int zWidth, boolean underwaterAllowed) {
        for (int cx = 0; cx < xWidth; ++cx) {
            for (int cz = 0; cz < zWidth; ++cz) {
                BlockPos pos_ = pos.offset(cx, 0, cz);
                if (world.hasChunkAt(pos_)) {
                    BlockState state = world.getBlockState(pos_.below());
                    if (!state.isSolidRender((BlockGetter)world, pos_) || FeatureLogic.isBlockNotOk(state)) {
                        if (underwaterAllowed && state.liquid()) continue;
                        return false;
                    }
                    for (int cy = 0; cy < height; ++cy) {
                        if (world.isEmptyBlock(pos_.above(cy)) || world.getBlockState(pos_.above(cy)).canBeReplaced() || underwaterAllowed && world.getBlockState(pos_.above(cy)).liquid()) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean anyBelowMatch(BlockPos exposedPos, int depth, Predicate<BlockPos> predicate) {
        return FeatureUtil.isAnyMatchInArea(exposedPos.below(depth), 1, depth + 1, 1, predicate);
    }

    public static boolean isAnyMatchInArea(BlockPos pos, int xWidth, int height, int zWidth, Predicate<BlockPos> predicate) {
        return IntStream.range(0, xWidth).mapToObj(cx -> IntStream.range(0, height).mapToObj(cy -> IntStream.range(0, zWidth).mapToObj(cz -> pos.offset(cx, cy, cz)))).flatMap(stream -> stream.flatMap(s -> s)).anyMatch(predicate);
    }

    public static void drawBlob(LevelAccessor world, BlockPos pos, int rad, BlockState state) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    world.setBlock(pos.offset(dx, dy, dz), state, 3);
                    world.setBlock(pos.offset(dx, dy, -dz), state, 3);
                    world.setBlock(pos.offset(-dx, dy, dz), state, 3);
                    world.setBlock(pos.offset(-dx, dy, -dz), state, 3);
                    world.setBlock(pos.offset(dx, -dy, dz), state, 3);
                    world.setBlock(pos.offset(dx, -dy, -dz), state, 3);
                    world.setBlock(pos.offset(-dx, -dy, dz), state, 3);
                    world.setBlock(pos.offset(-dx, -dy, -dz), state, 3);
                }
            }
        }
    }

    public static boolean hasAirAround(LevelAccessor world, BlockPos pos) {
        for (Direction e : directionsExceptDown) {
            if (!world.isEmptyBlock(pos.relative(e))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNearSolid(LevelReader world, BlockPos pos) {
        for (Direction e : Direction.values()) {
            if (!world.hasChunkAt(pos.relative(e)) || !world.getBlockState(pos.relative(e)).isSolid()) continue;
            return true;
        }
        return false;
    }
}

