/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.world.components.layer.BiomeDensitySource;
import twilightforest.world.components.layer.BorderLayer;
import twilightforest.world.components.layer.CompanionBiomesLayer;
import twilightforest.world.components.layer.FilteredBiomeLayer;
import twilightforest.world.components.layer.KeyBiomesLayer;
import twilightforest.world.components.layer.RandomBiomeLayer;
import twilightforest.world.components.layer.SeamLayer;
import twilightforest.world.components.layer.StabilizeLayer;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.SmoothLayer;
import twilightforest.world.components.layer.vanillalegacy.ZoomLayer;
import twilightforest.world.registration.biomes.BiomeMaker;

public class BiomeLayerStack {
    public static final Codec<BiomeLayerFactory> DISPATCH_CODEC = BiomeLayerTypes.CODEC.dispatch("layer_type", BiomeLayerFactory::getType, BiomeLayerType::getCodec);
    public static final Codec<Holder<BiomeLayerFactory>> HOLDER_CODEC = RegistryFileCodec.create(TFRegistries.Keys.BIOME_STACK, DISPATCH_CODEC, (boolean)true);
    public static final ResourceKey<BiomeLayerFactory> RANDOM_FOREST_BIOMES = BiomeLayerStack.registerKey("random_forest_biomes");
    public static final ResourceKey<BiomeLayerFactory> BIOMES_ALONG_STREAMS = BiomeLayerStack.registerKey("biomes_along_streams");
    public static final ResourceKey<BiomeDensitySource> BIOME_GRID = ResourceKey.create(TFRegistries.Keys.BIOME_TERRAIN_DATA, (ResourceLocation)TwilightForestMod.prefix("biome_grid"));

    public static ResourceKey<BiomeLayerFactory> registerKey(String name) {
        return ResourceKey.create(TFRegistries.Keys.BIOME_STACK, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<BiomeLayerFactory> context) {
        BiomeLayerFactory biomes = new RandomBiomeLayer.Factory(1L, 15, (List<ResourceKey<Biome>>)ImmutableList.of(TFBiomes.FOREST, TFBiomes.DENSE_FOREST, TFBiomes.MUSHROOM_FOREST, TFBiomes.OAK_SAVANNAH, TFBiomes.FIREFLY_FOREST), (List<ResourceKey<Biome>>)ImmutableList.of(TFBiomes.LAKE, TFBiomes.DENSE_MUSHROOM_FOREST, TFBiomes.ENCHANTED_FOREST, TFBiomes.CLEARING, TFBiomes.SPOOKY_FOREST));
        biomes = new KeyBiomesLayer.Factory(1000L, List.of(TFBiomes.GLACIER, TFBiomes.FIRE_SWAMP, TFBiomes.DARK_FOREST_CENTER, TFBiomes.FINAL_PLATEAU), (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new CompanionBiomesLayer.Factory(1000L, List.of(Pair.of(TFBiomes.FIRE_SWAMP, TFBiomes.SWAMP), Pair.of(TFBiomes.GLACIER, TFBiomes.SNOWY_FOREST), Pair.of(TFBiomes.DARK_FOREST_CENTER, TFBiomes.DARK_FOREST), Pair.of(TFBiomes.FINAL_PLATEAU, TFBiomes.HIGHLANDS)), (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new ZoomLayer.Factory(1000L, false, (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new ZoomLayer.Factory(1001L, false, (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new StabilizeLayer.Factory(700L, (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new BorderLayer.Factory(500L, TFBiomes.FINAL_PLATEAU, TFBiomes.THORNLANDS, (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new ZoomLayer.Factory(1002L, false, (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new ZoomLayer.Factory(1003L, false, (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new ZoomLayer.Factory(1004L, false, (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        biomes = new ZoomLayer.Factory(1005L, false, (Holder<BiomeLayerFactory>)Holder.direct((Object)biomes));
        Holder.Reference randomBiomes = context.register(RANDOM_FOREST_BIOMES, (Object)biomes);
        BiomeLayerFactory riverLayer = new SeamLayer.Factory(1L, TFBiomes.STREAM, List.of(TFBiomes.LAKE, TFBiomes.THORNLANDS, TFBiomes.CLEARING, TFBiomes.OAK_SAVANNAH), List.of(Pair.of(TFBiomes.SNOWY_FOREST, TFBiomes.GLACIER), Pair.of(TFBiomes.MUSHROOM_FOREST, TFBiomes.DENSE_MUSHROOM_FOREST), Pair.of(TFBiomes.SWAMP, TFBiomes.FIRE_SWAMP), Pair.of(TFBiomes.DARK_FOREST, TFBiomes.DARK_FOREST_CENTER), Pair.of(TFBiomes.HIGHLANDS, TFBiomes.FINAL_PLATEAU)), (Holder<BiomeLayerFactory>)randomBiomes);
        riverLayer = new SmoothLayer.Factory(7000L, (Holder<BiomeLayerFactory>)Holder.direct((Object)riverLayer));
        context.register(BIOMES_ALONG_STREAMS, (Object)new FilteredBiomeLayer.Factory(100L, TFBiomes.STREAM, (Holder<BiomeLayerFactory>)Holder.direct((Object)riverLayer), (Holder<BiomeLayerFactory>)randomBiomes));
    }

    public static void bootstrapData(BootstrapContext<BiomeDensitySource> context) {
        HolderGetter biomeRegistry = context.lookup(Registries.BIOME);
        context.register(BIOME_GRID, (Object)new BiomeDensitySource(BiomeMaker.makeBiomeList((HolderGetter<Biome>)biomeRegistry, (Holder<Biome>)biomeRegistry.getOrThrow(TFBiomes.UNDERGROUND)), (Holder<BiomeLayerFactory>)context.lookup(TFRegistries.Keys.BIOME_STACK).getOrThrow(BIOMES_ALONG_STREAMS)));
    }
}

