/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.BiasedToBottomHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.world.components.TFCavesCarver;

public class TFCaveCarvers {
    public static final DeferredRegister<WorldCarver<?>> CARVER_TYPES = DeferredRegister.create((ResourceKey)Registries.CARVER, (String)"twilightforest");
    public static final DeferredHolder<WorldCarver<?>, TFCavesCarver> TF_CAVES = CARVER_TYPES.register("tf_caves", () -> new TFCavesCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.CODEC, false, (BlockStateProvider)new NoiseProvider(6972119253061020355L, new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.5f, List.of(Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.ROOTED_DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.COARSE_DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState()))));
    public static final DeferredHolder<WorldCarver<?>, TFCavesCarver> HIGHLAND_CAVES = CARVER_TYPES.register("highland_caves", () -> new TFCavesCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.CODEC, true, (BlockStateProvider)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().add((Object)((Block)TFBlocks.TROLLSTEINN.value()).defaultBlockState(), 1).add((Object)Blocks.STONE.defaultBlockState(), 3))));
    public static final ResourceKey<ConfiguredWorldCarver<?>> TFCAVES_CONFIGURED = TFCaveCarvers.registerKey("tf_caves");
    public static final ResourceKey<ConfiguredWorldCarver<?>> HIGHLANDCAVES_CONFIGURED = TFCaveCarvers.registerKey("highland_caves");

    private static ResourceKey<ConfiguredWorldCarver<?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_CARVER, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredWorldCarver<?>> context) {
        HolderGetter blocks = context.lookup(Registries.BLOCK);
        context.register(TFCAVES_CONFIGURED, (Object)((TFCavesCarver)((Object)TF_CAVES.value())).configured((CarverConfiguration)new CaveCarverConfiguration(0.1f, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)16), (VerticalAnchor)VerticalAnchor.absolute((int)-8)), (FloatProvider)ConstantFloat.of((float)0.6f), VerticalAnchor.bottom(), (HolderSet)blocks.getOrThrow(BlockTagGenerator.CARVER_REPLACEABLES), (FloatProvider)ConstantFloat.of((float)1.05f), (FloatProvider)ConstantFloat.of((float)1.05f), (FloatProvider)ConstantFloat.of((float)-0.7f))));
        context.register(HIGHLANDCAVES_CONFIGURED, (Object)((TFCavesCarver)((Object)HIGHLAND_CAVES.value())).configured((CarverConfiguration)new CaveCarverConfiguration(1.0f, (HeightProvider)BiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)8), (VerticalAnchor)VerticalAnchor.absolute((int)32), (int)16), (FloatProvider)ConstantFloat.of((float)0.6f), VerticalAnchor.bottom(), (HolderSet)blocks.getOrThrow(BlockTagGenerator.CARVER_REPLACEABLES), (FloatProvider)UniformFloat.of((float)1.1f, (float)1.3f), (FloatProvider)ConstantFloat.of((float)1.1f), (FloatProvider)UniformFloat.of((float)-0.9f, (float)-0.65f))));
    }
}

