/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.entity.ai.goal.RedcapBaseGoal;
import twilightforest.entity.monster.Redcap;

public class RedcapPlantTNTGoal
extends RedcapBaseGoal {
    public RedcapPlantTNTGoal(Redcap redcap) {
        super(redcap);
    }

    public boolean canUse() {
        LivingEntity attackTarget = this.redcap.getTarget();
        return attackTarget != null && !this.redcap.heldTNT.isEmpty() && this.redcap.distanceToSqr((Entity)attackTarget) < 25.0 && !this.isTargetLookingAtMe(attackTarget) && EventHooks.canEntityGrief((Level)this.redcap.level(), (Entity)this.redcap) && !this.isLitTNTNearby(8) && this.findBlockTNTNearby(5) == null;
    }

    public void start() {
        BlockPos entityPos = new BlockPos((Vec3i)this.redcap.blockPosition());
        this.redcap.setItemSlot(EquipmentSlot.MAINHAND, this.redcap.heldTNT);
        if (this.redcap.level().isEmptyBlock(entityPos)) {
            this.redcap.heldTNT.shrink(1);
            this.redcap.playAmbientSound();
            this.redcap.level().setBlockAndUpdate(entityPos, Blocks.TNT.defaultBlockState());
            this.redcap.gameEvent((Holder)GameEvent.BLOCK_PLACE);
        }
    }

    public void stop() {
        this.redcap.setItemSlot(EquipmentSlot.MAINHAND, this.redcap.heldPick);
    }
}

