/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.gameevent.GameEvent;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.entity.boss.Lich;
import twilightforest.init.TFSounds;
import twilightforest.item.LifedrainScepterItem;
import twilightforest.util.entities.EntityUtil;

public class LichPopMobsGoal
extends Goal {
    private final Lich lich;

    public LichPopMobsGoal(Lich lich) {
        this.lich = lich;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        super.start();
        this.lich.setScepterTime();
    }

    public void stop() {
        super.stop();
        this.lich.resetScepterTime();
    }

    public boolean canUse() {
        return !this.lich.isShadowClone() && this.lich.getHealth() < this.lich.getMaxHealth() && this.lich.getPopCooldown() == 0 && !this.lich.level().getEntitiesOfClass(Mob.class, this.lich.getBoundingBox().inflate(32.0, 16.0, 32.0), e -> e.getType().is(EntityTagGenerator.LICH_POPPABLES) && this.lich.hasLineOfSight((Entity)e)).isEmpty();
    }

    public void tick() {
        if (this.lich.getTeleportInvisibility() > 0) {
            return;
        }
        super.tick();
        if (this.lich.getScepterTimeLeft() > 0 || this.lich.level().isClientSide()) {
            return;
        }
        for (Mob mob : this.lich.level().getEntitiesOfClass(Mob.class, this.lich.getBoundingBox().inflate(32.0, 16.0, 32.0), e -> e.getType().is(EntityTagGenerator.LICH_POPPABLES) && e != this.lich)) {
            if (!this.lich.getSensing().hasLineOfSight((Entity)mob)) continue;
            mob.discard();
            LifedrainScepterItem.animateTargetShatter((ServerLevel)this.lich.level(), (LivingEntity)mob);
            SoundEvent deathSound = EntityUtil.getDeathSound((LivingEntity)mob);
            if (deathSound != null) {
                this.lich.level().playSound(null, mob.blockPosition(), deathSound, SoundSource.HOSTILE, 1.0f, mob.getVoicePitch());
            }
            this.lich.playSound((SoundEvent)TFSounds.LICH_POP_MOB.get(), 3.0f, 0.4f + this.lich.getRandom().nextFloat() * 0.2f);
            mob.playSound((SoundEvent)TFSounds.LICH_POP_MOB.get(), 3.0f, 0.4f + this.lich.getRandom().nextFloat() * 0.2f);
            this.lich.makeMagicTrail(mob.getEyePosition(), this.lich.getEyePosition(), 1.0f, 0.5f, 0.5f);
            this.lich.heal(2.0f);
            this.lich.swing(InteractionHand.MAIN_HAND);
            this.lich.setPopCooldown(40);
            this.lich.gameEvent((Holder)GameEvent.ENTITY_DIE);
            break;
        }
    }
}

