/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.dispenser;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.util.TFItemStackUtils;

public abstract class DamageableStackDispenseBehavior
extends DefaultDispenseItemBehavior {
    private boolean fired = false;

    public ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        Position pos = DispenserBlock.getDispensePosition((BlockSource)source);
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        if (stack.getMaxDamage() >= stack.getDamageValue() + this.getDamageAmount()) {
            Projectile projectileentity = this.getProjectileEntity((Level)level, pos, stack);
            projectileentity.shoot((double)direction.getStepX(), (double)((float)direction.getStepY() + 0.1f), (double)direction.getStepZ(), this.getProjectileVelocity(), this.getProjectileInaccuracy());
            level.addFreshEntity((Entity)projectileentity);
            TFItemStackUtils.hurtButDontBreak(stack, 1, level, null);
            this.fired = true;
        }
        return stack;
    }

    protected void playSound(BlockSource source) {
        if (this.fired) {
            source.level().playSound(null, source.center().x(), source.center().y(), source.center().z(), this.getFiredSound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.fired = false;
        } else {
            source.level().levelEvent(1001, source.pos(), 0);
        }
    }

    protected abstract Projectile getProjectileEntity(Level var1, Position var2, ItemStack var3);

    protected abstract int getDamageAmount();

    protected abstract SoundEvent getFiredSound();

    protected float getProjectileInaccuracy() {
        return 18.0f;
    }

    protected float getProjectileVelocity() {
        return 1.1f;
    }
}

