/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.rei.entries;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class NbtHasher
implements EntryComparator<Tag> {
    private final Predicate<String> filter;

    NbtHasher(@Nullable String[] ignoredKeys) {
        if (ignoredKeys == null || ignoredKeys.length == 0) {
            this.filter = key -> true;
        } else if (ignoredKeys.length == 1) {
            String s = ignoredKeys[0];
            this.filter = key -> !Objects.equals(s, key);
        } else {
            HashSet<String> set = new HashSet<String>(Arrays.asList(ignoredKeys));
            this.filter = Predicates.not(set::contains);
        }
    }

    private boolean shouldHash(String key) {
        return this.filter.test((Object)key);
    }

    public long hash(ComparisonContext context, Tag value) {
        return this.hashTag(value);
    }

    private int hashTag(@Nullable Tag tag) {
        if (tag == null) {
            return 0;
        }
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            return this.hashListTag(list);
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            return this.hashCompoundTag(compound);
        }
        return tag.hashCode();
    }

    private int hashListTag(ListTag tag) {
        int i = tag.size();
        for (Tag innerTag : tag) {
            i = i * 31 + this.hashTag(innerTag);
        }
        return i;
    }

    private int hashCompoundTag(CompoundTag tag) {
        int i = 1;
        for (Map.Entry entry : tag.tags.entrySet()) {
            if (!this.shouldHash((String)entry.getKey())) continue;
            i = i * 31 + (Objects.hashCode(entry.getKey()) ^ this.hashTag((Tag)entry.getValue()));
        }
        return i;
    }
}

