/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.monster.LowerGoblinKnight;

public class LowerGoblinKnightModel
extends HumanoidModel<LowerGoblinKnight> {
    private final ModelPart tunic;

    public LowerGoblinKnightModel(ModelPart root) {
        super(root);
        this.tunic = root.getChild("tunic");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? LowerGoblinKnightModel.createJappaModel() : LowerGoblinKnightModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 32).addBox(-2.5f, -5.0f, -3.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 48).addBox(-3.5f, 0.0f, -2.0f, 7.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("tunic", CubeListBuilder.create().texOffs(64, 19).addBox(-6.0f, 0.0f, -3.0f, 12.0f, 9.0f, 6.0f), PartPose.offset((float)0.0f, (float)7.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 48).addBox(-2.0f, -2.0f, -1.5f, 2.0f, 8.0f, 3.0f), PartPose.offset((float)-3.5f, (float)10.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(40, 48).addBox(0.0f, -2.0f, -1.5f, 2.0f, 8.0f, 3.0f), PartPose.offset((float)3.5f, (float)10.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-3.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)-2.5f, (float)16.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(0, 48).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)2.5f, (float)16.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 30).addBox(-2.5f, -5.0f, -3.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 48).addBox(-3.5f, 0.0f, -2.0f, 7.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("tunic", CubeListBuilder.create().texOffs(64, 19).addBox(-6.0f, 0.0f, -3.0f, 12.0f, 9.0f, 6.0f), PartPose.offset((float)0.0f, (float)7.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(48, 48).addBox(-2.0f, -2.0f, -1.5f, 2.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)-3.5f, (float)10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(38, 48).addBox(0.0f, -2.0f, -1.5f, 2.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)3.5f, (float)10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.10000737f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 40).addBox(-3.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)-2.5f, (float)16.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 52).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)2.5f, (float)16.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        super.renderToBuffer(stack, builder, light, overlay, color);
        this.tunic.render(stack, builder, light, overlay, color);
    }

    public void setupAnim(LowerGoblinKnight entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isVehicle()) {
            this.head.yRot = 0.0f;
            this.head.xRot = 0.0f;
        } else {
            this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
            this.head.xRot = headPitch * ((float)Math.PI / 180);
        }
        this.hat.yRot = this.head.yRot;
        this.hat.xRot = this.head.xRot;
        if (!entity.hasArmor() && !entity.isVehicle()) {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        } else {
            this.rightArm.xRot = 0.0f;
            this.leftArm.xRot = 0.0f;
        }
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        if (!entity.hasArmor() && !entity.isVehicle()) {
            AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        }
        this.tunic.visible = entity.hasArmor();
    }
}

