/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.TwilightForestMod;
import twilightforest.client.UncraftingRecipeBookComponent;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.inventory.UncraftingMenu;
import twilightforest.network.UncraftingGuiPacket;

public class UncraftingScreen
extends AbstractContainerScreen<UncraftingMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation TEXTURE = TwilightForestMod.getGuiTexture("guigoblintinkering.png");
    private final RecipeBookComponent recipeBookComponent = new UncraftingRecipeBookComponent();
    private boolean widthTooNarrow;

    public UncraftingScreen(UncraftingMenu container, Inventory player, Component name) {
        super((AbstractContainerMenu)container, player, name);
    }

    protected void init() {
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.recipeBookComponent.init(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
        this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 145, this.topPos + 7, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, button -> {
            this.recipeBookComponent.toggleVisibility();
            this.repositionElements();
        }));
        this.addWidget((GuiEventListener)this.recipeBookComponent);
        this.setInitialFocus((GuiEventListener)this.recipeBookComponent);
        this.addRenderableWidget((GuiEventListener)new CycleButton(this.leftPos + 40, this.topPos + 22, true, button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ++((UncraftingMenu)this.menu).unrecipeInCycle;
            ((UncraftingMenu)this.menu).slotsChanged(((UncraftingMenu)this.menu).tinkerInput);
        }, Component.translatable((String)"container.twilightforest.uncrafting_table.cycle_next_uncraft")));
        this.addRenderableWidget((GuiEventListener)new CycleButton(this.leftPos + 40, this.topPos + 55, false, button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            --((UncraftingMenu)this.menu).unrecipeInCycle;
            ((UncraftingMenu)this.menu).slotsChanged(((UncraftingMenu)this.menu).tinkerInput);
        }, Component.translatable((String)"container.twilightforest.uncrafting_table.cycle_back_uncraft")));
        if (!TFConfig.disableIngredientSwitching) {
            this.addRenderableWidget((GuiEventListener)new CycleButtonMini(this.leftPos + 27, this.topPos + 56, true, button -> {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ++((UncraftingMenu)this.menu).ingredientsInCycle;
                ((UncraftingMenu)this.menu).slotsChanged(((UncraftingMenu)this.menu).tinkerInput);
            }, Component.translatable((String)"container.twilightforest.uncrafting_table.cycle_next_ingredient")));
            this.addRenderableWidget((GuiEventListener)new CycleButtonMini(this.leftPos + 27, this.topPos + 63, false, button -> {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(3), (CustomPacketPayload[])new CustomPacketPayload[0]);
                --((UncraftingMenu)this.menu).ingredientsInCycle;
                ((UncraftingMenu)this.menu).slotsChanged(((UncraftingMenu)this.menu).tinkerInput);
            }, Component.translatable((String)"container.twilightforest.uncrafting_table.cycle_back_ingredient")));
        }
        this.addRenderableWidget((GuiEventListener)new CycleButton(this.leftPos + 121, this.topPos + 22, true, button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(4), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ++((UncraftingMenu)this.menu).recipeInCycle;
            ((UncraftingMenu)this.menu).slotsChanged((Container)((UncraftingMenu)this.menu).assemblyMatrix);
        }, Component.translatable((String)"container.twilightforest.uncrafting_table.cycle_next_recipe")));
        this.addRenderableWidget((GuiEventListener)new CycleButton(this.leftPos + 121, this.topPos + 55, false, button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            --((UncraftingMenu)this.menu).recipeInCycle;
            ((UncraftingMenu)this.menu).slotsChanged((Container)((UncraftingMenu)this.menu).assemblyMatrix);
        }, Component.translatable((String)"container.twilightforest.uncrafting_table.cycle_back_recipe")));
    }

    protected void containerTick() {
        super.containerTick();
        this.recipeBookComponent.tick();
    }

    public boolean mouseScrolled(double x, double y, double vertScroll, double horizScroll) {
        boolean scrolled = super.mouseScrolled(x, y, vertScroll, horizScroll);
        if (!TFConfig.disableIngredientSwitching && x > (double)(this.leftPos + 27) && x < (double)(this.leftPos + 33) && y > (double)(this.topPos + 56) && y < (double)(this.topPos + 69)) {
            if (vertScroll > 0.0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ++((UncraftingMenu)this.menu).ingredientsInCycle;
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(3), (CustomPacketPayload[])new CustomPacketPayload[0]);
                --((UncraftingMenu)this.menu).ingredientsInCycle;
            }
            ((UncraftingMenu)this.menu).slotsChanged(((UncraftingMenu)this.menu).tinkerInput);
        }
        if (x > (double)(this.leftPos + 40) && x < (double)(this.leftPos + 54) && y > (double)(this.topPos + 22) && y < (double)(this.topPos + 64)) {
            if (vertScroll > 0.0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ++((UncraftingMenu)this.menu).unrecipeInCycle;
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                --((UncraftingMenu)this.menu).unrecipeInCycle;
            }
            ((UncraftingMenu)this.menu).slotsChanged(((UncraftingMenu)this.menu).tinkerInput);
        }
        if (x > (double)(this.leftPos + 121) && x < (double)(this.leftPos + 135) && y > (double)(this.topPos + 22) && y < (double)(this.topPos + 64)) {
            if (vertScroll > 0.0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(4), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ++((UncraftingMenu)this.menu).recipeInCycle;
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingGuiPacket(5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                --((UncraftingMenu)this.menu).recipeInCycle;
            }
            ((UncraftingMenu)this.menu).slotsChanged((Container)((UncraftingMenu)this.menu).assemblyMatrix);
        }
        return scrolled;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.recipeBookComponent.isVisible() && this.widthTooNarrow) {
            this.renderBackground(graphics, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.render(graphics, mouseX, mouseY, partialTicks);
        } else {
            super.render(graphics, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.render(graphics, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.renderGhostRecipe(graphics, this.leftPos, this.topPos, true, partialTicks);
        }
        this.renderTooltip(graphics, mouseX, mouseY);
        this.recipeBookComponent.renderTooltip(graphics, this.leftPos, this.topPos, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 6, 6, 0x404040, false);
        if (TFConfig.disableUncraftingOnly) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"container.twilightforest.uncrafting_table.uncrafting_disabled").withStyle(ChatFormatting.DARK_RED), 6, this.imageHeight - 96 + 2, 0x404040, false);
        } else {
            graphics.drawString(this.font, I18n.get((String)"container.inventory", (Object[])new Object[0]), 7, this.imageHeight - 96 + 2, 0x404040, false);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        String cost;
        int frameX = this.leftPos;
        int frameY = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, frameX, frameY, 0, 0, this.imageWidth, this.imageHeight);
        UncraftingMenu tfContainer = (UncraftingMenu)this.menu;
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        for (int i = 0; i < 9; ++i) {
            Slot uncrafting = tfContainer.getSlot(2 + i);
            Slot assembly = tfContainer.getSlot(11 + i);
            if (!uncrafting.hasItem()) continue;
            this.drawSlotAsBackground(graphics, uncrafting, assembly);
        }
        graphics.pose().popPose();
        int costVal = tfContainer.getUncraftingCost();
        if (costVal > 0) {
            cost = "" + costVal;
            int color = this.minecraft.player.experienceLevel < costVal && !this.minecraft.player.getAbilities().instabuild ? 0xA00000 : 8453920;
            graphics.drawString(this.font, cost, frameX + 48 - this.font.width(cost), frameY + 38, color);
        }
        if ((costVal = tfContainer.getRecraftingCost()) > 0) {
            cost = "" + costVal;
            int color = this.minecraft.player.experienceLevel < costVal && !this.minecraft.player.getAbilities().instabuild ? 0xA00000 : 8453920;
            graphics.drawString(this.font, cost, frameX + 130 - this.font.width(cost), frameY + 38, color);
        }
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBookComponent.isVisible()) && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.recipeBookComponent.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.recipeBookComponent);
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.isVisible() || super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return this.recipeBookComponent.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, mouseButton) && super.hasClickedOutside(mouseX, mouseY, guiLeft, guiTop, mouseButton);
    }

    private void drawSlotAsBackground(GuiGraphics graphics, Slot backgroundSlot, Slot appearSlot) {
        int screenX = appearSlot.x;
        int screenY = appearSlot.y;
        ItemStack itemStackToRender = backgroundSlot.getItem();
        graphics.renderFakeItem(itemStackToRender, screenX, screenY);
        boolean itemBroken = UncraftingMenu.isMarked(itemStackToRender);
        RenderSystem.disableDepthTest();
        graphics.pose().pushPose();
        graphics.pose().translate(0.0, 0.0, 200.0);
        graphics.fill(appearSlot.x, appearSlot.y, appearSlot.x + 16, appearSlot.y + 16, itemBroken ? -2130736245 : -1618244725);
        graphics.pose().popPose();
        RenderSystem.enableDepthTest();
    }

    protected void renderTooltip(GuiGraphics graphics, int pX, int pY) {
        UncraftingMenu container = (UncraftingMenu)this.menu;
        for (int i = 0; i < 9; ++i) {
            if (!container.getCarried().isEmpty() || !((Slot)container.slots.get(2 + i)).hasItem() || this.hoveredSlot != container.slots.get(11 + i) || ((Slot)container.slots.get(11 + i)).hasItem()) continue;
            graphics.renderTooltip(this.font, ((Slot)container.slots.get(2 + i)).getItem(), pX, pY);
        }
        if (((Slot)container.slots.getFirst()).hasItem() && ((Slot)container.slots.getFirst()).getItem().is(ItemTagGenerator.BANNED_UNCRAFTABLES) && ((Slot)container.slots.getFirst()).equals(this.hoveredSlot)) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"container.twilightforest.uncrafting_table.disabled_item").withStyle(ChatFormatting.RED), pX, pY);
        } else {
            super.renderTooltip(graphics, pX, pY);
        }
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
        this.recipeBookComponent.slotClicked(slot);
    }

    public void recipesUpdated() {
        this.recipeBookComponent.recipesUpdated();
    }

    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookComponent;
    }

    private static class CycleButton
    extends Button {
        private final boolean up;

        CycleButton(int x, int y, boolean up, Button.OnPress onClick, MutableComponent tooltip) {
            super(x, y, 14, 9, (Component)Component.empty(), onClick, message -> Component.empty());
            this.up = up;
            this.setTooltip(Tooltip.create((Component)tooltip));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
                int textureX = 176;
                int textureY = 0;
                if (this.isHovered) {
                    textureX += this.width;
                }
                if (!this.up) {
                    textureY += this.height;
                }
                graphics.blit(TEXTURE, this.getX(), this.getY(), textureX, textureY, this.width, this.height);
            }
        }
    }

    private static class CycleButtonMini
    extends Button {
        private final boolean up;

        CycleButtonMini(int x, int y, boolean up, Button.OnPress onClick, MutableComponent tooltip) {
            super(x, y, 8, 6, (Component)Component.empty(), onClick, message -> Component.empty());
            this.up = up;
            this.setTooltip(Tooltip.create((Component)tooltip));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
                int textureX = 176;
                int textureY = 41;
                if (this.isHovered) {
                    textureX += this.width;
                }
                if (!this.up) {
                    textureY += this.height;
                }
                graphics.blit(TEXTURE, this.getX(), this.getY(), textureX, textureY, this.width, this.height);
            }
        }
    }
}

