/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import com.mojang.serialization.DynamicOps;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFSounds;

public class SkullChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private static final int SIZE = 45;
    public NonNullList<ItemStack> contents = NonNullList.withSize((int)45, (Object)ItemStack.EMPTY);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, pos, (SoundEvent)TFSounds.SKULL_CHEST_OPEN.get(), SoundSource.BLOCKS, 0.5f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, pos, (SoundEvent)TFSounds.SKULL_CHEST_CLOSE.get(), SoundSource.BLOCKS, 0.5f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int id, int param) {
            Block block = state.getBlock();
            level.blockEvent(pos, block, 1, param);
        }

        protected boolean isOwnContainer(Player player) {
            if (player.containerMenu instanceof ChestMenu) {
                Container container = ((ChestMenu)player.containerMenu).getContainer();
                return container == SkullChestBlockEntity.this;
            }
            return false;
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    @Nullable
    public ResolvableProfile owner;

    public SkullChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.SKULL_CHEST.get(), pos, state);
    }

    public SkullChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SkullChestBlockEntity te) {
        te.chestLidController.tickLid();
    }

    public ContainerOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    public NonNullList<ItemStack> getItems() {
        return this.contents;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.contents = items;
    }

    protected Component getDefaultName() {
        return this.getBlockState().getBlock().getName();
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new ChestMenu(MenuType.GENERIC_9x5, id, player, (Container)this, 5);
    }

    public int getContainerSize() {
        return 45;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.contents, (HolderLookup.Provider)provider);
        }
        if (this.owner != null) {
            tag.put("owner", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.owner).getOrThrow());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.contents = NonNullList.withSize((int)45, (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.contents, (HolderLookup.Provider)provider);
        }
        if (tag.contains("owner")) {
            ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("owner")).resultOrPartial(s -> TwilightForestMod.LOGGER.error("Failed to load owner for casket: {}", s)).ifPresent(resolvableProfile -> {
                this.owner = resolvableProfile;
            });
        }
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.getOpenersCounter().incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.getOpenersCounter().decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.isRemoved()) {
            this.getOpenersCounter().recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    public boolean stillValid(Player player) {
        if (this.owner != null) {
            if (player.hasPermissions(3) || player.getGameProfile().equals((Object)this.owner.gameProfile())) {
                return super.stillValid(player);
            }
            return false;
        }
        return super.stillValid(player);
    }

    public boolean canOpen(Player player) {
        if (this.owner != null) {
            if (player.hasPermissions(3) || player.getGameProfile().equals((Object)this.owner.gameProfile())) {
                return super.canOpen(player);
            }
            this.displayLockedInfo(player);
            return false;
        }
        return super.canOpen(player);
    }

    public void displayLockedInfo(Player player) {
        player.playNotifySound((SoundEvent)TFSounds.SKULL_CHEST_LOCKED.get(), SoundSource.BLOCKS, 0.5f, 0.5f);
        player.displayClientMessage((Component)Component.translatable((String)"block.twilightforest.skull_chest.locked", (Object[])new Object[]{this.owner.gameProfile().getName()}).withStyle(ChatFormatting.RED), true);
    }

    public void setRemoved() {
        this.owner = null;
        super.setRemoved();
    }
}

