/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import twilightforest.init.TFItems;
import twilightforest.init.TFStats;

public class Experiment115Block
extends Block {
    public static final IntegerProperty BITES_TAKEN = IntegerProperty.create((String)"omnomnom", (int)0, (int)7);
    public static final BooleanProperty REGENERATE = BooleanProperty.create((String)"regenerate");
    private static final VoxelShape QUARTER_SHAPE = Experiment115Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)8.0);
    private static final VoxelShape HALF_SHAPE = Experiment115Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)15.0);
    private static final VoxelShape THREE_QUARTER_SHAPE = Shapes.join((VoxelShape)HALF_SHAPE, (VoxelShape)Experiment115Block.box((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0, (double)15.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape FULL_SHAPE = Experiment115Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);

    public Experiment115Block(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BITES_TAKEN, (Comparable)Integer.valueOf(7))).setValue((Property)REGENERATE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)BITES_TAKEN)) {
            default -> FULL_SHAPE;
            case 2, 3 -> THREE_QUARTER_SHAPE;
            case 4, 5 -> HALF_SHAPE;
            case 6, 7 -> QUARTER_SHAPE;
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int bitesTaken = (Integer)state.getValue((Property)BITES_TAKEN);
        if (!player.isSecondaryUseActive()) {
            if (stack.is((Item)TFItems.EXPERIMENT_115.get())) {
                if (bitesTaken == 0) {
                    return ItemInteractionResult.FAIL;
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BITES_TAKEN, (Comparable)Integer.valueOf(bitesTaken - 1)));
                level.playSound(null, pos, state.getSoundType((LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.consume(1, (LivingEntity)player);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos, stack);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            if (!((Boolean)state.getValue((Property)REGENERATE)).booleanValue() && bitesTaken == 0 && stack.is(Items.REDSTONE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)REGENERATE, (Comparable)Boolean.valueOf(true)));
                level.playSound(null, pos, state.getSoundType((LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.consume(1, (LivingEntity)player);
                if (player instanceof ServerPlayer) {
                    player.awardStat(Stats.ITEM_USED.get((Object)Items.REDSTONE));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        } else if (!((Boolean)state.getValue((Property)REGENERATE)).booleanValue()) {
            if (bitesTaken < 7) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BITES_TAKEN, (Comparable)Integer.valueOf(bitesTaken + 1)));
            } else {
                level.removeBlock(pos, false);
            }
            player.playSound(SoundEvents.ITEM_PICKUP, 0.5f, 1.0f);
            if (!player.isCreative()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFItems.EXPERIMENT_115.get()));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat((ResourceLocation)TFStats.E115_SLICES_EATEN.get());
        player.getFoodData().eat(4, 0.3f);
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        int i = (Integer)state.getValue((Property)BITES_TAKEN);
        if (i < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES_TAKEN, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, new ItemStack((ItemLike)TFItems.EXPERIMENT_115.get(), 8 - i));
            player.awardStat(Stats.ITEM_USED.get((Object)((Item)TFItems.EXPERIMENT_115.get())));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)REGENERATE)).booleanValue() && (Integer)state.getValue((Property)BITES_TAKEN) != 0) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BITES_TAKEN, (Comparable)Integer.valueOf((Integer)state.getValue((Property)BITES_TAKEN) - 1)));
        }
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos.below()).isSolid();
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES_TAKEN, REGENERATE});
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return 8 - (Integer)state.getValue((Property)BITES_TAKEN) + ((Boolean)state.getValue((Property)REGENERATE) != false ? 7 : 0);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)REGENERATE);
    }

    public int getSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)REGENERATE) != false ? 15 - (Integer)state.getValue((Property)BITES_TAKEN) * 2 : 0;
    }
}

