/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import twilightforest.block.VerticalHollowLogBlock;
import twilightforest.block.WaterloggedBlock;
import twilightforest.enums.HollowLogVariants;

public class ClimbableHollowLogBlock
extends HorizontalDirectionalBlock
implements WaterloggedBlock {
    public static final EnumProperty<HollowLogVariants.Climbable> VARIANT = EnumProperty.create((String)"variant", HollowLogVariants.Climbable.class);
    public static final MapCodec<ClimbableHollowLogBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("vertical_log").forGetter(o -> o.vertical), (App)ClimbableHollowLogBlock.propertiesCodec()).apply((Applicative)instance, ClimbableHollowLogBlock::new));
    private static final VoxelShape LADDER_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape LADDER_WEST = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LADDER_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape LADDER_NORTH = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape HOLLOW_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape HOLLOW_SHAPE_SOUTH = Shapes.or((VoxelShape)HOLLOW_SHAPE, (VoxelShape)LADDER_SOUTH);
    private static final VoxelShape HOLLOW_SHAPE_NORTH = Shapes.or((VoxelShape)HOLLOW_SHAPE, (VoxelShape)LADDER_NORTH);
    private static final VoxelShape HOLLOW_SHAPE_EAST = Shapes.or((VoxelShape)HOLLOW_SHAPE, (VoxelShape)LADDER_EAST);
    private static final VoxelShape HOLLOW_SHAPE_WEST = Shapes.or((VoxelShape)HOLLOW_SHAPE, (VoxelShape)LADDER_WEST);
    private static final VoxelShape COLLISION_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape COLLISION_SHAPE_SOUTH = Shapes.or((VoxelShape)COLLISION_SHAPE, (VoxelShape)LADDER_SOUTH);
    private static final VoxelShape COLLISION_SHAPE_NORTH = Shapes.or((VoxelShape)COLLISION_SHAPE, (VoxelShape)LADDER_NORTH);
    private static final VoxelShape COLLISION_SHAPE_EAST = Shapes.or((VoxelShape)COLLISION_SHAPE, (VoxelShape)LADDER_EAST);
    private static final VoxelShape COLLISION_SHAPE_WEST = Shapes.or((VoxelShape)COLLISION_SHAPE, (VoxelShape)LADDER_WEST);
    private final Holder<Block> vertical;

    public ClimbableHollowLogBlock(Holder<Block> vertical, BlockBehaviour.Properties properties) {
        super(properties);
        this.vertical = vertical;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Climbable.VINE))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static boolean isInside(HitResult result, BlockPos pos) {
        Vec3 vec = result.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return 0.124 <= vec.x() && vec.x() <= 0.876 && 0.124 <= vec.z() && vec.z() <= 0.876;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        if (state.getValue(VARIANT) == HollowLogVariants.Climbable.VINE) {
            voxelShape = HOLLOW_SHAPE;
        } else {
            switch ((Direction)state.getValue((Property)FACING)) {
                case SOUTH: {
                    voxelShape = HOLLOW_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    voxelShape = HOLLOW_SHAPE_WEST;
                    break;
                }
                case EAST: {
                    voxelShape = HOLLOW_SHAPE_EAST;
                    break;
                }
                default: {
                    voxelShape = HOLLOW_SHAPE_NORTH;
                }
            }
        }
        return voxelShape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        if (state.getValue(VARIANT) == HollowLogVariants.Climbable.VINE) {
            voxelShape = COLLISION_SHAPE;
        } else {
            switch ((Direction)state.getValue((Property)FACING)) {
                case SOUTH: {
                    voxelShape = COLLISION_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    voxelShape = COLLISION_SHAPE_WEST;
                    break;
                }
                case EAST: {
                    voxelShape = COLLISION_SHAPE_EAST;
                    break;
                }
                default: {
                    voxelShape = COLLISION_SHAPE_NORTH;
                }
            }
        }
        return voxelShape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VARIANT, FACING});
    }

    @Override
    public boolean isStateWaterlogged(BlockState state) {
        return state.getValue(VARIANT) == HollowLogVariants.Climbable.LADDER_WATERLOGGED;
    }

    @Override
    public BlockState setWaterlog(BlockState prior, boolean doWater) {
        return switch ((HollowLogVariants.Climbable)((Object)prior.getValue(VARIANT))) {
            default -> throw new MatchException(null, null);
            case HollowLogVariants.Climbable.VINE -> {
                if (doWater) {
                    yield (BlockState)((Block)this.vertical.value()).defaultBlockState().setValue((Property)VerticalHollowLogBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                yield prior;
            }
            case HollowLogVariants.Climbable.LADDER -> (BlockState)prior.setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Climbable.LADDER_WATERLOGGED));
            case HollowLogVariants.Climbable.LADDER_WATERLOGGED -> (BlockState)prior.setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Climbable.LADDER));
        };
    }

    public FluidState getFluidState(BlockState state) {
        return state.getValue(VARIANT) == HollowLogVariants.Climbable.LADDER_WATERLOGGED ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (this.isStateWaterlogged(state)) {
            accessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, neighborState, accessor, pos, neighborPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!ClimbableHollowLogBlock.isInside((HitResult)hit, pos)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        if (stack.canPerformAction(ItemAbilities.SHEARS_HARVEST)) {
            HollowLogVariants.Climbable variant = (HollowLogVariants.Climbable)((Object)state.getValue(VARIANT));
            level.setBlock(pos, (BlockState)((Block)this.vertical.value()).defaultBlockState().setValue((Property)VerticalHollowLogBlock.WATERLOGGED, (Comparable)Boolean.valueOf(variant == HollowLogVariants.Climbable.LADDER_WATERLOGGED)), 3);
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)(variant == HollowLogVariants.Climbable.VINE ? Blocks.VINE : Blocks.LADDER))));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

