/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.enums.BanisterShape;

public class BanisterBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<BanisterShape> SHAPE = EnumProperty.create((String)"shape", BanisterShape.class);
    public static final BooleanProperty EXTENDED = BooleanProperty.create((String)"extended");
    public static final MapCodec<BanisterBlock> CODEC = BanisterBlock.simpleCodec(BanisterBlock::new);
    private static final VoxelShape NORTH_SUPPORTS_TALL = Shapes.or((VoxelShape)Block.box((double)2.5, (double)0.0, (double)0.0, (double)5.5, (double)16.0, (double)3.0), (VoxelShape)Block.box((double)10.5, (double)0.0, (double)0.0, (double)13.5, (double)16.0, (double)3.0));
    private static final VoxelShape EAST_SUPPORTS_TALL = Shapes.or((VoxelShape)Block.box((double)13.0, (double)0.0, (double)2.5, (double)16.0, (double)16.0, (double)5.5), (VoxelShape)Block.box((double)13.0, (double)0.0, (double)10.5, (double)16.0, (double)16.0, (double)13.5));
    private static final VoxelShape SOUTH_SUPPORTS_TALL = Shapes.or((VoxelShape)Block.box((double)2.5, (double)0.0, (double)13.0, (double)5.5, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)10.5, (double)0.0, (double)13.0, (double)13.5, (double)16.0, (double)16.0));
    private static final VoxelShape WEST_SUPPORTS_TALL = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.5, (double)3.0, (double)16.0, (double)5.5), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)10.5, (double)3.0, (double)16.0, (double)13.5));
    private static final VoxelShape NORTH_SUPPORTS_SHORT = Shapes.or((VoxelShape)Block.box((double)2.5, (double)0.0, (double)0.0, (double)5.5, (double)4.0, (double)3.0), (VoxelShape)Block.box((double)10.5, (double)0.0, (double)0.0, (double)13.5, (double)4.0, (double)3.0));
    private static final VoxelShape EAST_SUPPORTS_SHORT = Shapes.or((VoxelShape)Block.box((double)13.0, (double)0.0, (double)2.5, (double)16.0, (double)4.0, (double)5.5), (VoxelShape)Block.box((double)13.0, (double)0.0, (double)10.5, (double)16.0, (double)4.0, (double)13.5));
    private static final VoxelShape SOUTH_SUPPORTS_SHORT = Shapes.or((VoxelShape)Block.box((double)2.5, (double)0.0, (double)13.0, (double)5.5, (double)4.0, (double)16.0), (VoxelShape)Block.box((double)10.5, (double)0.0, (double)13.0, (double)13.5, (double)4.0, (double)16.0));
    private static final VoxelShape WEST_SUPPORTS_SHORT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.5, (double)3.0, (double)4.0, (double)5.5), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)10.5, (double)3.0, (double)4.0, (double)13.5));
    private static final VoxelShape NORTH_EXTENSION = Shapes.or((VoxelShape)Block.box((double)2.5, (double)-8.0, (double)0.0, (double)5.5, (double)0.0, (double)3.0), (VoxelShape)Block.box((double)10.5, (double)-8.0, (double)0.0, (double)13.5, (double)0.0, (double)3.0));
    private static final VoxelShape EAST_EXTENSION = Shapes.or((VoxelShape)Block.box((double)13.0, (double)-8.0, (double)2.5, (double)16.0, (double)0.0, (double)5.5), (VoxelShape)Block.box((double)13.0, (double)-8.0, (double)10.5, (double)16.0, (double)0.0, (double)13.5));
    private static final VoxelShape SOUTH_EXTENSION = Shapes.or((VoxelShape)Block.box((double)2.5, (double)-8.0, (double)13.0, (double)5.5, (double)0.0, (double)16.0), (VoxelShape)Block.box((double)10.5, (double)-8.0, (double)13.0, (double)13.5, (double)0.0, (double)16.0));
    private static final VoxelShape WEST_EXTENSION = Shapes.or((VoxelShape)Block.box((double)0.0, (double)-8.0, (double)2.5, (double)3.0, (double)0.0, (double)5.5), (VoxelShape)Block.box((double)0.0, (double)-8.0, (double)10.5, (double)3.0, (double)0.0, (double)13.5));
    private static final VoxelShape NORTH_TALL = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape)NORTH_SUPPORTS_TALL);
    private static final VoxelShape NORTH_TALL_EXTENDED = Shapes.or((VoxelShape)NORTH_TALL, (VoxelShape)NORTH_EXTENSION);
    private static final VoxelShape EAST_TALL = Shapes.or((VoxelShape)Block.box((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)EAST_SUPPORTS_TALL);
    private static final VoxelShape EAST_TALL_EXTENDED = Shapes.or((VoxelShape)EAST_TALL, (VoxelShape)EAST_EXTENSION);
    private static final VoxelShape SOUTH_TALL = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)SOUTH_SUPPORTS_TALL);
    private static final VoxelShape SOUTH_TALL_EXTENDED = Shapes.or((VoxelShape)SOUTH_TALL, (VoxelShape)SOUTH_EXTENSION);
    private static final VoxelShape WEST_TALL = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape)WEST_SUPPORTS_TALL);
    private static final VoxelShape WEST_TALL_EXTENDED = Shapes.or((VoxelShape)WEST_TALL, (VoxelShape)WEST_EXTENSION);
    private static final VoxelShape NORTH_SHORT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0), (VoxelShape)NORTH_SUPPORTS_SHORT);
    private static final VoxelShape NORTH_SHORT_EXTENDED = Shapes.or((VoxelShape)NORTH_SHORT, (VoxelShape)NORTH_EXTENSION);
    private static final VoxelShape EAST_SHORT = Shapes.or((VoxelShape)Block.box((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)EAST_SUPPORTS_SHORT);
    private static final VoxelShape EAST_SHORT_EXTENDED = Shapes.or((VoxelShape)EAST_SHORT, (VoxelShape)EAST_EXTENSION);
    private static final VoxelShape SOUTH_SHORT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)SOUTH_SUPPORTS_SHORT);
    private static final VoxelShape SOUTH_SHORT_EXTENDED = Shapes.or((VoxelShape)SOUTH_SHORT, (VoxelShape)SOUTH_EXTENSION);
    private static final VoxelShape WEST_SHORT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0), (VoxelShape)WEST_SUPPORTS_SHORT);
    private static final VoxelShape WEST_SHORT_EXTENDED = Shapes.or((VoxelShape)WEST_SHORT, (VoxelShape)WEST_EXTENSION);
    private static final VoxelShape NORTH_CONNECTED_EXTENDED = Shapes.or((VoxelShape)NORTH_SUPPORTS_TALL, (VoxelShape)NORTH_EXTENSION);
    private static final VoxelShape EAST_CONNECTED_EXTENDED = Shapes.or((VoxelShape)EAST_SUPPORTS_TALL, (VoxelShape)EAST_EXTENSION);
    private static final VoxelShape SOUTH_CONNECTED_EXTENDED = Shapes.or((VoxelShape)SOUTH_SUPPORTS_TALL, (VoxelShape)SOUTH_EXTENSION);
    private static final VoxelShape WEST_CONNECTED_EXTENDED = Shapes.or((VoxelShape)WEST_SUPPORTS_TALL, (VoxelShape)WEST_EXTENSION);

    public BanisterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(SHAPE, (Comparable)((Object)BanisterShape.TALL))).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(SHAPE, (Comparable)((Object)(context.getLevel().getBlockState(pos.above()).is(BlockTagGenerator.BANISTERS) ? BanisterShape.CONNECTED : BanisterShape.TALL)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(pos).getType() == Fluids.WATER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean extended = (Boolean)state.getValue((Property)EXTENDED);
        return switch ((BanisterShape)((Object)state.getValue(SHAPE))) {
            default -> throw new MatchException(null, null);
            case BanisterShape.SHORT -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        if (extended) {
                            yield NORTH_SHORT_EXTENDED;
                        }
                        yield NORTH_SHORT;
                    }
                    case WEST: {
                        if (extended) {
                            yield WEST_SHORT_EXTENDED;
                        }
                        yield WEST_SHORT;
                    }
                    case EAST: {
                        if (extended) {
                            yield EAST_SHORT_EXTENDED;
                        }
                        yield EAST_SHORT;
                    }
                }
                if (extended) {
                    yield SOUTH_SHORT_EXTENDED;
                }
                yield SOUTH_SHORT;
            }
            case BanisterShape.CONNECTED -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        if (extended) {
                            yield NORTH_CONNECTED_EXTENDED;
                        }
                        yield NORTH_SUPPORTS_TALL;
                    }
                    case WEST: {
                        if (extended) {
                            yield WEST_CONNECTED_EXTENDED;
                        }
                        yield WEST_SUPPORTS_TALL;
                    }
                    case EAST: {
                        if (extended) {
                            yield EAST_CONNECTED_EXTENDED;
                        }
                        yield EAST_SUPPORTS_TALL;
                    }
                }
                if (extended) {
                    yield SOUTH_CONNECTED_EXTENDED;
                }
                yield SOUTH_SUPPORTS_TALL;
            }
            case BanisterShape.TALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        if (extended) {
                            yield NORTH_TALL_EXTENDED;
                        }
                        yield NORTH_TALL;
                    }
                    case WEST: {
                        if (extended) {
                            yield WEST_TALL_EXTENDED;
                        }
                        yield WEST_TALL;
                    }
                    case EAST: {
                        if (extended) {
                            yield EAST_TALL_EXTENDED;
                        }
                        yield EAST_TALL;
                    }
                }
                yield extended ? SOUTH_TALL_EXTENDED : SOUTH_TALL;
            }
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"block.twilightforest.banister.cycle").withStyle(ChatFormatting.GRAY));
    }

    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.FENCE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{SHAPE, EXTENDED, FACING, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (held.canPerformAction(ItemAbilities.AXE_WAX_OFF)) {
            BlockState newState = (BlockState)state.cycle(SHAPE);
            BlockState belowState = level.getBlockState(pos.below());
            level.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (belowState.getBlock() instanceof BanisterBlock && belowState.getValue(SHAPE) != BanisterShape.SHORT) {
                level.setBlock(pos, (BlockState)newState.setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                level.setBlock(pos, newState.getValue(SHAPE) == BanisterShape.TALL ? (BlockState)newState.cycle((Property)EXTENDED) : newState, 3);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(held, state, level, pos, player, hand, result);
    }

    protected BlockState updateShape(BlockState thisState, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos thisPos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && neighborState.getBlock() instanceof BanisterBlock && neighborState.getValue(SHAPE) != BanisterShape.SHORT && ((Boolean)thisState.getValue((Property)EXTENDED)).booleanValue()) {
            return (BlockState)thisState.setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false));
        }
        return super.updateShape(thisState, direction, neighborState, level, thisPos, neighborPos);
    }
}

