/*
 * Decompiled with CFR 0.152.
 */
package auroras.util;

import auroras.Auroras;
import auroras.config.Config;
import auroras.util.AHelpers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;

public class AuroraData {
    public static final String OVERWORLD = "overworld.json";
    public static final String AETHER = "aether.json";
    public static final String THE_END = "the_end.json";
    public static final String CURRENT_VERSION = AHelpers.getVersion().toString();
    public static final List<AuroraData> DATA_CACHE = new ArrayList<AuroraData>();
    public static final Map<String, Tuple<Long, AuroraData>> LAST_MODIFIED_TIMES = new HashMap<String, Tuple<Long, AuroraData>>();
    public static final String DEFAULT_VERSION = "0";
    public static final boolean DEFAULT_SHOULD_AUTO_UPDATE = true;
    public static final double DEFAULT_EQUATOR_Z = 10000.0;
    public static final double DEFAULT_BLOCKS_90 = 20000.0;
    public static final boolean DEFAULT_IGNORE_STAR_BRIGHTNESS = false;
    public static final boolean DEFAULT_ENDLESS_POLES = false;
    public static final double DEFAULT_AURORA_HEIGHT_OFFSET = -4000.0;
    public static final boolean DEFAULT_PIXEL_STYLE = true;
    public static final int DEFAULT_AURORA_DETAIL = 200;
    public static final int DEFAULT_YEAR_LENGTH = 365;
    public static final int DEFAULT_AURORA_WAVE_OCTAVES = 1;
    public static final double DEFAULT_AURORA_WAVE_AMPLITUDE = 1200.0;
    public static final double DEFAULT_AURORA_WAVE_FREQUENCY = 25.0;
    public static final double DEFAULT_AURORA_WAVE_SPEED = 1.0E-6;
    public static final int DEFAULT_AURORA_HEIGHT_OCTAVES = 1;
    public static final double DEFAULT_AURORA_HEIGHT_FREQUENCY = 100.0;
    public static final double DEFAULT_AURORA_HEIGHT_SPEED = 2.0E-6;
    public static final double DEFAULT_AURORA_HEIGHT_AMPLITUDE_TOP = 3000.0;
    public static final double DEFAULT_AURORA_HEIGHT_AMPLITUDE_MID = 500.0;
    public static final double DEFAULT_AURORA_HEIGHT_AMPLITUDE_LOWER = 200.0;
    public static final double DEFAULT_AURORA_WIDTH = 0.5;
    public static final double DEFAULT_AURORA_HEIGHT = 0.02;
    public static final double DEFAULT_AURORA_FREQUENCY = 1.0;
    public static final double DEFAULT_AURORA_WIDTH_RADIUS = 0.5;
    public static final double DEFAULT_AURORA_LENGTH_RADIUS = 0.5;
    public static final double DEFAULT_AURORA_DISTANCE_FACTOR = 1.5;
    public static final double DEFAULT_AURORA_MAX_POLE_OFFSET = 5000.0;
    public static final double DEFAULT_AURORA_ROTATION_SPEED = 0.5;
    public static final int DEFAULT_AURORA_VISIBILITY_OCTAVES = 1;
    public static final boolean DEFAULT_ABOVE_HEAD_POSITION = false;
    public static final double DEFAULT_PLAYER_MOVEMENT_FACTOR = 1.0E-4;
    public static final double DEFAULT_PLAYER_ALTITUDE_FACTOR = 1.0;
    public static final double DEFAULT_AURORA_BAND_DISTANCE_FACTOR = 1600.0;
    public static final int DEFAULT_AURORA_AMOUNT_OCTAVES = 4;
    public static final double DEFAULT_AURORA_AMOUNT_AMPLITUDE = 1.0;
    public static final double DEFAULT_AURORA_COLOR_UPDATE_SPEED = 1.0;
    public static final double DEFAULT_BLUE_LAYER_FACTOR_EXTRA = 0.5;
    public static final double DEFAULT_RED_LAYER_FACTOR_EXTRA = 1.0;
    public static final double DEFAULT_RED_LAYER_FACTOR = 2.0;
    public static final double DEFAULT_GREEN_LAYER_FACTOR = 6.0;
    public static final double DEFAULT_BLUE_LAYER_FACTOR = -1.0;
    public static final int DEFAULT_TOP_COLOR_CYCLE = 1200;
    public static final int DEFAULT_MID_COLOR_CYCLE = 1200;
    public static final int DEFAULT_LOWER_COLOR_CYCLE = 1200;
    public static final int DEFAULT_TOP_COLOR_OCTAVES = 2;
    public static final int DEFAULT_MID_COLOR_OCTAVES = 3;
    public static final int DEFAULT_LOWER_COLOR_OCTAVES = 1;
    public static final double DEFAULT_TOP_COLOR_HSB_MIN = 0.0;
    public static final double DEFAULT_TOP_COLOR_HSB_MAX = 0.05;
    public static final double DEFAULT_MID_COLOR_HSB_MIN = 0.22;
    public static final double DEFAULT_MID_COLOR_HSB_MAX = 0.41;
    public static final double DEFAULT_LOWER_COLOR_HSB_MIN = 0.6;
    public static final double DEFAULT_LOWER_COLOR_HSB_MAX = 0.88;
    public String version;
    public boolean shouldAutoUpdate;
    public List<String> allowedDimensions;
    public List<String> allowedBiomes;
    public double equatorZ;
    public double blocks90;
    public boolean ignoreStarBrightness;
    public boolean endlessPoles;
    public double auroraHeightOffset;
    public boolean pixelStyle;
    public int auroraDetail;
    public int yearLength;
    public int auroraWaveOctaves;
    public double auroraWaveAmplitude;
    public double auroraWaveFrequency;
    public double auroraWaveSpeed;
    public int auroraHeightOctaves;
    public double auroraHeightFrequency;
    public double auroraHeightSpeed;
    public double auroraHeightAmplitudeTop;
    public double auroraHeightAmplitudeMid;
    public double auroraHeightAmplitudeLower;
    public double auroraWidth;
    public double auroraHeight;
    public double auroraFrequency;
    public double auroraWidthRadius;
    public double auroraLengthRadius;
    public double auroraDistanceFactor;
    public double auroraMaxPoleOffset;
    public double auroraRotationSpeed;
    public int auroraVisibilityOctaves;
    public boolean aboveHeadPosition;
    public double playerMovementFactor;
    public double playerAltitudeFactor;
    public double auroraBandDistanceFactor;
    public int auroraAmountOctaves;
    public double auroraAmountAmplitude;
    public double auroraColorUpdateSpeed;
    public double blueLayerFactorExtra;
    public double redLayerFactorExtra;
    public double redLayerFactor;
    public double greenLayerFactor;
    public double blueLayerFactor;
    public int topColorCycle;
    public int midColorCycle;
    public int lowerColorCycle;
    public int topColorOctaves;
    public int midColorOctaves;
    public int lowerColorOctaves;
    public double topColorHSBMin;
    public double topColorHSBMax;
    public double midColorHSBMin;
    public double midColorHSBMax;
    public double lowerColorHSBMax;
    public double lowerColorHSBMin;

    public static void init(IEventBus bus) {
        bus.addListener(EventPriority.HIGHEST, AuroraData::createConfigsOnSetup);
    }

    public static void createConfigsOnSetup(FMLCommonSetupEvent event) {
        AuroraData.createConfigs();
    }

    public static void createConfigs() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        File subDir = new File(configPath.toString(), "auroras");
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        if (subDir.isDirectory()) {
            String configSubDir = subDir.getPath();
            if (subDir.list().length > 0 && ((Boolean)Config.STARTUP.globalShouldAutoUpdate.get()).booleanValue()) {
                for (File file : subDir.listFiles()) {
                    JsonObject jsonObject;
                    if (!file.isFile() || !file.getName().endsWith(".json") || (jsonObject = AuroraData.readJsonFile(file.getPath())) == null) continue;
                    boolean isOld = AHelpers.compareVersions(AHelpers.getAsString(jsonObject, "version", DEFAULT_VERSION)) >= 1;
                    boolean shouldUpdate = AHelpers.getAsBoolean(jsonObject, "shouldAutoUpdate", true);
                    if (!shouldUpdate || !isOld) continue;
                    if (file.getName().equals(OVERWORLD)) {
                        AuroraData.createOverworldConfig(configSubDir, file.getName());
                        continue;
                    }
                    if (file.getName().equals(AETHER)) {
                        AuroraData.createAetherConfig(configSubDir, file.getName());
                        continue;
                    }
                    if (file.getName().equals(THE_END)) {
                        AuroraData.createEndConfig(configSubDir, file.getName());
                        continue;
                    }
                    AuroraData.updateConfigValues(file, configSubDir, jsonObject);
                }
            } else if (subDir.list().length <= 0) {
                AuroraData.createOverworldConfig(configSubDir, OVERWORLD);
                AuroraData.createAetherConfig(configSubDir, AETHER);
                AuroraData.createEndConfig(configSubDir, THE_END);
            }
        }
    }

    public boolean updateConfig(File configFile) {
        JsonObject data = AuroraData.readJsonFile(configFile.getPath());
        if (data == null || !data.isJsonObject()) {
            return false;
        }
        this.version = AHelpers.getAsString(data, "version", DEFAULT_VERSION);
        this.shouldAutoUpdate = AHelpers.getAsBoolean(data, "shouldAutoUpdate", true);
        ArrayList<String> dimensions = new ArrayList<String>();
        if (data.getAsJsonArray("allowedDimensions") != null) {
            for (JsonElement element : data.getAsJsonArray("allowedDimensions")) {
                dimensions.add(element.getAsString());
            }
        }
        this.allowedDimensions = dimensions;
        ArrayList<String> biomes = new ArrayList<String>();
        if (data.getAsJsonArray("allowedBiomes") != null) {
            for (JsonElement element : data.getAsJsonArray("allowedBiomes")) {
                biomes.add(element.getAsString());
            }
        }
        this.allowedBiomes = biomes;
        this.equatorZ = AHelpers.getAsDouble(data, "equatorZ", 10000.0);
        this.blocks90 = AHelpers.getAsDouble(data, "blocks90", 20000.0);
        this.ignoreStarBrightness = AHelpers.getAsBoolean(data, "ignoreStarBrightness", false);
        this.endlessPoles = AHelpers.getAsBoolean(data, "endlessPoles", false);
        this.auroraHeightOffset = AHelpers.getAsDouble(data, "auroraHeightOffset", -4000.0);
        this.pixelStyle = AHelpers.getAsBoolean(data, "pixelStyle", true);
        this.auroraDetail = AHelpers.getAsInt(data, "auroraDetail", 200);
        this.yearLength = AHelpers.getAsInt(data, "yearLength", 365);
        this.auroraWaveOctaves = AHelpers.getAsInt(data, "auroraWaveOctaves", 1);
        this.auroraWaveAmplitude = AHelpers.getAsDouble(data, "auroraWaveAmplitude", 1200.0);
        this.auroraWaveFrequency = AHelpers.getAsDouble(data, "auroraWaveFrequency", 25.0);
        this.auroraWaveSpeed = AHelpers.getAsDouble(data, "auroraWaveSpeed", 1.0E-6);
        this.auroraHeightOctaves = AHelpers.getAsInt(data, "auroraHeightOctaves", 1);
        this.auroraHeightFrequency = AHelpers.getAsDouble(data, "auroraHeightFrequency", 100.0);
        this.auroraHeightSpeed = AHelpers.getAsDouble(data, "auroraHeightSpeed", 2.0E-6);
        this.auroraHeightAmplitudeTop = AHelpers.getAsDouble(data, "auroraHeightAmplitudeTop", 3000.0);
        this.auroraHeightAmplitudeMid = AHelpers.getAsDouble(data, "auroraHeightAmplitudeMid", 500.0);
        this.auroraHeightAmplitudeLower = AHelpers.getAsDouble(data, "auroraHeightAmplitudeLower", 200.0);
        this.auroraWidth = AHelpers.getAsDouble(data, "auroraWidth", 0.5);
        this.auroraHeight = AHelpers.getAsDouble(data, "auroraHeight", 0.02);
        this.auroraFrequency = AHelpers.getAsDouble(data, "auroraFrequency", 1.0);
        this.auroraWidthRadius = AHelpers.getAsDouble(data, "auroraWidthRadius", 0.5);
        this.auroraLengthRadius = AHelpers.getAsDouble(data, "auroraLengthRadius", 0.5);
        this.auroraDistanceFactor = AHelpers.getAsDouble(data, "auroraDistanceFactor", 1.5);
        this.auroraMaxPoleOffset = AHelpers.getAsDouble(data, "auroraMaxPoleOffset", 5000.0);
        this.auroraRotationSpeed = AHelpers.getAsDouble(data, "auroraRotationSpeed", 0.5);
        this.auroraVisibilityOctaves = AHelpers.getAsInt(data, "auroraVisibilityOctaves", 1);
        this.aboveHeadPosition = AHelpers.getAsBoolean(data, "aboveHeadPosition", false);
        this.playerMovementFactor = AHelpers.getAsDouble(data, "playerMovementFactor", 1.0E-4);
        this.playerAltitudeFactor = AHelpers.getAsDouble(data, "playerAltitudeFactor", 1.0);
        this.auroraBandDistanceFactor = AHelpers.getAsDouble(data, "auroraBandDistanceFactor", 1600.0);
        this.auroraAmountOctaves = AHelpers.getAsInt(data, "auroraAmountOctaves", 4);
        this.auroraAmountAmplitude = AHelpers.getAsDouble(data, "auroraAmountAmplitude", 1.0);
        this.auroraColorUpdateSpeed = AHelpers.getAsDouble(data, "auroraColorUpdateSpeed", 1.0);
        this.blueLayerFactorExtra = AHelpers.getAsDouble(data, "blueLayerFactorExtra", 0.5);
        this.redLayerFactorExtra = AHelpers.getAsDouble(data, "redLayerFactorExtra", 1.0);
        this.redLayerFactor = AHelpers.getAsDouble(data, "redLayerFactor", 2.0);
        this.greenLayerFactor = AHelpers.getAsDouble(data, "greenLayerFactor", 6.0);
        this.blueLayerFactor = AHelpers.getAsDouble(data, "blueLayerFactor", -1.0);
        this.topColorCycle = AHelpers.getAsInt(data, "topColorCycle", 1200);
        this.midColorCycle = AHelpers.getAsInt(data, "midColorCycle", 1200);
        this.lowerColorCycle = AHelpers.getAsInt(data, "lowerColorCycle", 1200);
        this.topColorOctaves = AHelpers.getAsInt(data, "topColorOctaves", 2);
        this.midColorOctaves = AHelpers.getAsInt(data, "midColorOctaves", 3);
        this.lowerColorOctaves = AHelpers.getAsInt(data, "lowerColorOctaves", 1);
        this.topColorHSBMin = AHelpers.getAsDouble(data, "topColorHSBMin", 0.0);
        this.topColorHSBMax = AHelpers.getAsDouble(data, "topColorHSBMax", 0.05);
        this.midColorHSBMin = AHelpers.getAsDouble(data, "midColorHSBMin", 0.22);
        this.midColorHSBMax = AHelpers.getAsDouble(data, "midColorHSBMax", 0.41);
        this.lowerColorHSBMin = AHelpers.getAsDouble(data, "lowerColorHSBMin", 0.6);
        this.lowerColorHSBMax = AHelpers.getAsDouble(data, "lowerColorHSBMax", 0.88);
        return true;
    }

    public static List<AuroraData> getDataList(Level level) {
        ArrayList<AuroraData> dataList = new ArrayList<AuroraData>();
        String dimension = level.dimension().location().toString();
        for (AuroraData data : DATA_CACHE) {
            if (!data.allowedDimensions.contains(dimension)) continue;
            dataList.add(data);
        }
        return dataList;
    }

    public static void updateConfigs() {
        File subDir = AuroraData.getSubDirPath().toFile();
        ArrayList<String> paths = new ArrayList<String>();
        if (subDir.exists() && subDir.isDirectory()) {
            for (File file : subDir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                String path = file.getPath();
                paths.add(path);
                if (!LAST_MODIFIED_TIMES.containsKey(path)) {
                    AuroraData data = new AuroraData();
                    if (!data.updateConfig(file)) continue;
                    DATA_CACHE.add(data);
                    LAST_MODIFIED_TIMES.put(path, (Tuple<Long, AuroraData>)new Tuple((Object)file.lastModified(), (Object)data));
                    continue;
                }
                if (((Long)LAST_MODIFIED_TIMES.get(path).getA()).longValue() == file.lastModified()) continue;
                LAST_MODIFIED_TIMES.get(path).setA((Object)file.lastModified());
                boolean result = ((AuroraData)LAST_MODIFIED_TIMES.get(path).getB()).updateConfig(file);
                if (result) continue;
                Auroras.LOGGER.warn("There was an error loading config: " + path);
            }
        }
        if (!paths.isEmpty()) {
            HashSet<String> keys = new HashSet<String>(LAST_MODIFIED_TIMES.keySet());
            ArrayList<AuroraData> items = new ArrayList<AuroraData>();
            for (String dataPath : keys) {
                if (paths.contains(dataPath)) continue;
                items.add((AuroraData)LAST_MODIFIED_TIMES.get(dataPath).getB());
                LAST_MODIFIED_TIMES.remove(dataPath);
            }
            if (!items.isEmpty()) {
                for (AuroraData data : items) {
                    DATA_CACHE.remove(data);
                }
            }
        }
    }

    public static File readConfigs(String dimension) {
        File subDir = AuroraData.getSubDirPath().toFile();
        if (subDir.exists() && subDir.isDirectory()) {
            for (File file : subDir.listFiles()) {
                JsonObject jsonObject;
                if (!file.isFile() || !file.getName().endsWith(".json") || (jsonObject = AuroraData.readJsonFile(file.getPath())) == null) continue;
                JsonArray allowedDimensions = jsonObject.getAsJsonArray("allowedDimensions");
                ArrayList<String> dimensions = new ArrayList<String>();
                for (JsonElement element : allowedDimensions) {
                    dimensions.add(element.getAsString());
                }
                if (allowedDimensions == null || !dimensions.contains(dimension)) continue;
                return file;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readJsonFile(String filePath) {
        try (FileReader reader = new FileReader(filePath);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (element == null) return null;
            if (!element.isJsonObject()) return null;
            JsonObject jsonObject = element.getAsJsonObject();
            return jsonObject;
        }
        catch (JsonSyntaxException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void updateConfigValues(File file, String filePath, JsonObject inputJson) {
        JsonObject jsonObject = inputJson.deepCopy();
        if (!jsonObject.has("version") || !jsonObject.get("version").getAsString().equals(CURRENT_VERSION)) {
            jsonObject.addProperty("version", CURRENT_VERSION);
        }
        if (!jsonObject.has("equatorZ") || jsonObject.get("equatorZ").getAsDouble() != 10000.0) {
            jsonObject.addProperty("equatorZ", (Number)10000.0);
        }
        if (!jsonObject.has("blocks90") || jsonObject.get("blocks90").getAsDouble() != 20000.0) {
            jsonObject.addProperty("blocks90", (Number)20000.0);
        }
        if (!jsonObject.has("ignoreStarBrightness") || jsonObject.get("ignoreStarBrightness").getAsBoolean()) {
            jsonObject.addProperty("ignoreStarBrightness", Boolean.valueOf(false));
        }
        if (!jsonObject.has("endlessPoles") || jsonObject.get("endlessPoles").getAsBoolean()) {
            jsonObject.addProperty("endlessPoles", Boolean.valueOf(false));
        }
        if (!jsonObject.has("auroraHeightOffset") || jsonObject.get("auroraHeightOffset").getAsDouble() != -4000.0) {
            jsonObject.addProperty("auroraHeightOffset", (Number)-4000.0);
        }
        if (!jsonObject.has("pixelStyle") || !jsonObject.get("pixelStyle").getAsBoolean()) {
            jsonObject.addProperty("pixelStyle", Boolean.valueOf(true));
        }
        if (!jsonObject.has("auroraDetail") || jsonObject.get("auroraDetail").getAsInt() != 200) {
            jsonObject.addProperty("auroraDetail", (Number)200);
        }
        if (!jsonObject.has("yearLength") || jsonObject.get("yearLength").getAsInt() != 365) {
            jsonObject.addProperty("yearLength", (Number)365);
        }
        if (!jsonObject.has("auroraWaveOctaves") || jsonObject.get("auroraWaveOctaves").getAsInt() != 1) {
            jsonObject.addProperty("auroraWaveOctaves", (Number)1);
        }
        if (!jsonObject.has("auroraWaveAmplitude") || jsonObject.get("auroraWaveAmplitude").getAsDouble() != 1200.0) {
            jsonObject.addProperty("auroraWaveAmplitude", (Number)1200.0);
        }
        if (!jsonObject.has("auroraWaveFrequency") || jsonObject.get("auroraWaveFrequency").getAsDouble() != 25.0) {
            jsonObject.addProperty("auroraWaveFrequency", (Number)25.0);
        }
        if (!jsonObject.has("auroraWaveSpeed") || jsonObject.get("auroraWaveSpeed").getAsDouble() != 1.0E-6) {
            jsonObject.addProperty("auroraWaveSpeed", (Number)1.0E-6);
        }
        if (!jsonObject.has("auroraHeightOctaves") || jsonObject.get("auroraHeightOctaves").getAsInt() != 1) {
            jsonObject.addProperty("auroraHeightOctaves", (Number)1);
        }
        if (!jsonObject.has("auroraHeightFrequency") || jsonObject.get("auroraHeightFrequency").getAsDouble() != 100.0) {
            jsonObject.addProperty("auroraHeightFrequency", (Number)100.0);
        }
        if (!jsonObject.has("auroraHeightSpeed") || jsonObject.get("auroraHeightSpeed").getAsDouble() != 2.0E-6) {
            jsonObject.addProperty("auroraHeightSpeed", (Number)2.0E-6);
        }
        if (!jsonObject.has("auroraHeightAmplitudeTop") || jsonObject.get("auroraHeightAmplitudeTop").getAsDouble() != 3000.0) {
            jsonObject.addProperty("auroraHeightAmplitudeTop", (Number)3000.0);
        }
        if (!jsonObject.has("auroraHeightAmplitudeMid") || jsonObject.get("auroraHeightAmplitudeMid").getAsDouble() != 500.0) {
            jsonObject.addProperty("auroraHeightAmplitudeMid", (Number)500.0);
        }
        if (!jsonObject.has("auroraHeightAmplitudeLower") || jsonObject.get("auroraHeightAmplitudeLower").getAsDouble() != 200.0) {
            jsonObject.addProperty("auroraHeightAmplitudeLower", (Number)200.0);
        }
        if (!jsonObject.has("auroraWidth") || jsonObject.get("auroraWidth").getAsDouble() != 0.5) {
            jsonObject.addProperty("auroraWidth", (Number)0.5);
        }
        if (!jsonObject.has("auroraHeight") || jsonObject.get("auroraHeight").getAsDouble() != 0.02) {
            jsonObject.addProperty("auroraHeight", (Number)0.02);
        }
        if (!jsonObject.has("auroraFrequency") || jsonObject.get("auroraFrequency").getAsDouble() != 1.0) {
            jsonObject.addProperty("auroraFrequency", (Number)1.0);
        }
        if (!jsonObject.has("auroraWidthRadius") || jsonObject.get("auroraWidthRadius").getAsDouble() != 0.5) {
            jsonObject.addProperty("auroraWidthRadius", (Number)0.5);
        }
        if (!jsonObject.has("auroraLengthRadius") || jsonObject.get("auroraLengthRadius").getAsDouble() != 0.5) {
            jsonObject.addProperty("auroraLengthRadius", (Number)0.5);
        }
        if (!jsonObject.has("auroraDistanceFactor") || jsonObject.get("auroraDistanceFactor").getAsDouble() != 1.5) {
            jsonObject.addProperty("auroraDistanceFactor", (Number)1.5);
        }
        if (!jsonObject.has("auroraMaxPoleOffset") || jsonObject.get("auroraMaxPoleOffset").getAsDouble() != 5000.0) {
            jsonObject.addProperty("auroraMaxPoleOffset", (Number)5000.0);
        }
        if (!jsonObject.has("auroraRotationSpeed") || jsonObject.get("auroraRotationSpeed").getAsDouble() != 0.5) {
            jsonObject.addProperty("auroraRotationSpeed", (Number)0.5);
        }
        if (!jsonObject.has("auroraVisibilityOctaves") || jsonObject.get("auroraVisibilityOctaves").getAsInt() != 1) {
            jsonObject.addProperty("auroraVisibilityOctaves", (Number)1);
        }
        if (!jsonObject.has("aboveHeadPosition") || jsonObject.get("aboveHeadPosition").getAsBoolean()) {
            jsonObject.addProperty("aboveHeadPosition", Boolean.valueOf(false));
        }
        if (!jsonObject.has("playerMovementFactor") || jsonObject.get("playerMovementFactor").getAsDouble() != 1.0E-4) {
            jsonObject.addProperty("playerMovementFactor", (Number)1.0E-4);
        }
        if (!jsonObject.has("playerAltitudeFactor") || jsonObject.get("playerAltitudeFactor").getAsDouble() != 1.0) {
            jsonObject.addProperty("playerAltitudeFactor", (Number)1.0);
        }
        if (!jsonObject.has("auroraBandDistanceFactor") || jsonObject.get("auroraBandDistanceFactor").getAsDouble() != 1600.0) {
            jsonObject.addProperty("auroraBandDistanceFactor", (Number)1600.0);
        }
        if (!jsonObject.has("auroraAmountOctaves") || jsonObject.get("auroraAmountOctaves").getAsInt() != 4) {
            jsonObject.addProperty("auroraAmountOctaves", (Number)4);
        }
        if (!jsonObject.has("auroraAmountAmplitude") || jsonObject.get("auroraAmountAmplitude").getAsDouble() != 1.0) {
            jsonObject.addProperty("auroraAmountAmplitude", (Number)1.0);
        }
        if (!jsonObject.has("auroraColorUpdateSpeed") || jsonObject.get("auroraColorUpdateSpeed").getAsDouble() != 1.0) {
            jsonObject.addProperty("auroraColorUpdateSpeed", (Number)1.0);
        }
        if (!jsonObject.has("blueLayerFactorExtra") || jsonObject.get("blueLayerFactorExtra").getAsDouble() != 0.5) {
            jsonObject.addProperty("blueLayerFactorExtra", (Number)0.5);
        }
        if (!jsonObject.has("redLayerFactorExtra") || jsonObject.get("redLayerFactorExtra").getAsDouble() != 1.0) {
            jsonObject.addProperty("redLayerFactorExtra", (Number)1.0);
        }
        if (!jsonObject.has("redLayerFactor") || jsonObject.get("redLayerFactor").getAsDouble() != 2.0) {
            jsonObject.addProperty("redLayerFactor", (Number)2.0);
        }
        if (!jsonObject.has("greenLayerFactor") || jsonObject.get("greenLayerFactor").getAsDouble() != 6.0) {
            jsonObject.addProperty("greenLayerFactor", (Number)6.0);
        }
        if (!jsonObject.has("blueLayerFactor") || jsonObject.get("blueLayerFactor").getAsDouble() != -1.0) {
            jsonObject.addProperty("blueLayerFactor", (Number)-1.0);
        }
        if (!jsonObject.has("topColorCycle") || jsonObject.get("topColorCycle").getAsInt() != 1200) {
            jsonObject.addProperty("topColorCycle", (Number)1200);
        }
        if (!jsonObject.has("midColorCycle") || jsonObject.get("midColorCycle").getAsInt() != 1200) {
            jsonObject.addProperty("midColorCycle", (Number)1200);
        }
        if (!jsonObject.has("lowerColorCycle") || jsonObject.get("lowerColorCycle").getAsInt() != 1200) {
            jsonObject.addProperty("lowerColorCycle", (Number)1200);
        }
        if (!jsonObject.has("topColorOctaves") || jsonObject.get("topColorOctaves").getAsInt() != 2) {
            jsonObject.addProperty("topColorOctaves", (Number)2);
        }
        if (!jsonObject.has("midColorOctaves") || jsonObject.get("midColorOctaves").getAsInt() != 3) {
            jsonObject.addProperty("midColorOctaves", (Number)3);
        }
        if (!jsonObject.has("lowerColorOctaves") || jsonObject.get("lowerColorOctaves").getAsInt() != 1) {
            jsonObject.addProperty("lowerColorOctaves", (Number)1);
        }
        if (!jsonObject.has("topColorHSBMin") || jsonObject.get("topColorHSBMin").getAsDouble() != 0.0) {
            jsonObject.addProperty("topColorHSBMin", (Number)0.0);
        }
        if (!jsonObject.has("topColorHSBMax") || jsonObject.get("topColorHSBMax").getAsDouble() != 0.05) {
            jsonObject.addProperty("topColorHSBMax", (Number)0.05);
        }
        if (!jsonObject.has("midColorHSBMin") || jsonObject.get("midColorHSBMin").getAsDouble() != 0.22) {
            jsonObject.addProperty("midColorHSBMin", (Number)0.22);
        }
        if (!jsonObject.has("midColorHSBMax") || jsonObject.get("midColorHSBMax").getAsDouble() != 0.41) {
            jsonObject.addProperty("midColorHSBMax", (Number)0.41);
        }
        if (!jsonObject.has("lowerColorHSBMin") || jsonObject.get("lowerColorHSBMin").getAsDouble() != 0.6) {
            jsonObject.addProperty("lowerColorHSBMin", (Number)0.6);
        }
        if (!jsonObject.has("lowerColorHSBMax") || jsonObject.get("lowerColorHSBMax").getAsDouble() != 0.88) {
            jsonObject.addProperty("lowerColorHSBMax", (Number)0.88);
        }
        AuroraData.createFile(jsonObject, filePath + File.separator + file.getName());
    }

    public static Path getSubDirPath() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        return new File(configPath.toString(), "auroras").toPath();
    }

    public static void createOverworldConfig(String filePath, String fileName) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", CURRENT_VERSION);
        jsonObject.addProperty("shouldAutoUpdate", Boolean.valueOf(true));
        JsonArray allowedDimensions = new JsonArray();
        allowedDimensions.add("minecraft:overworld");
        jsonObject.add("allowedDimensions", (JsonElement)allowedDimensions);
        jsonObject.add("allowedBiomes", (JsonElement)new JsonArray());
        jsonObject.addProperty("equatorZ", (Number)10000.0);
        jsonObject.addProperty("blocks90", (Number)20000.0);
        jsonObject.addProperty("ignoreStarBrightness", Boolean.valueOf(false));
        jsonObject.addProperty("endlessPoles", Boolean.valueOf(false));
        jsonObject.addProperty("auroraHeightOffset", (Number)-4000.0);
        jsonObject.addProperty("pixelStyle", Boolean.valueOf(true));
        jsonObject.addProperty("auroraDetail", (Number)200);
        jsonObject.addProperty("yearLength", (Number)365);
        jsonObject.addProperty("auroraWaveOctaves", (Number)1);
        jsonObject.addProperty("auroraWaveAmplitude", (Number)1200.0);
        jsonObject.addProperty("auroraWaveFrequency", (Number)25.0);
        jsonObject.addProperty("auroraWaveSpeed", (Number)1.0E-6);
        jsonObject.addProperty("auroraHeightOctaves", (Number)1);
        jsonObject.addProperty("auroraHeightFrequency", (Number)100.0);
        jsonObject.addProperty("auroraHeightSpeed", (Number)2.0E-6);
        jsonObject.addProperty("auroraHeightAmplitudeTop", (Number)3000.0);
        jsonObject.addProperty("auroraHeightAmplitudeMid", (Number)500.0);
        jsonObject.addProperty("auroraHeightAmplitudeLower", (Number)200.0);
        jsonObject.addProperty("auroraWidth", (Number)0.5);
        jsonObject.addProperty("auroraHeight", (Number)0.02);
        jsonObject.addProperty("auroraFrequency", (Number)1.0);
        jsonObject.addProperty("auroraWidthRadius", (Number)0.5);
        jsonObject.addProperty("auroraLengthRadius", (Number)0.5);
        jsonObject.addProperty("auroraDistanceFactor", (Number)1.5);
        jsonObject.addProperty("auroraMaxPoleOffset", (Number)5000.0);
        jsonObject.addProperty("auroraRotationSpeed", (Number)0.5);
        jsonObject.addProperty("auroraVisibilityOctaves", (Number)1);
        jsonObject.addProperty("aboveHeadPosition", Boolean.valueOf(false));
        jsonObject.addProperty("playerMovementFactor", (Number)1.0E-4);
        jsonObject.addProperty("playerAltitudeFactor", (Number)1.0);
        jsonObject.addProperty("auroraBandDistanceFactor", (Number)1600.0);
        jsonObject.addProperty("auroraAmountOctaves", (Number)4);
        jsonObject.addProperty("auroraAmountAmplitude", (Number)1.0);
        jsonObject.addProperty("auroraColorUpdateSpeed", (Number)1.0);
        jsonObject.addProperty("blueLayerFactorExtra", (Number)0.5);
        jsonObject.addProperty("redLayerFactorExtra", (Number)1.0);
        jsonObject.addProperty("redLayerFactor", (Number)2.0);
        jsonObject.addProperty("greenLayerFactor", (Number)6.0);
        jsonObject.addProperty("blueLayerFactor", (Number)-1.0);
        jsonObject.addProperty("topColorCycle", (Number)1200);
        jsonObject.addProperty("midColorCycle", (Number)1200);
        jsonObject.addProperty("lowerColorCycle", (Number)1200);
        jsonObject.addProperty("topColorOctaves", (Number)2);
        jsonObject.addProperty("midColorOctaves", (Number)3);
        jsonObject.addProperty("lowerColorOctaves", (Number)1);
        jsonObject.addProperty("topColorHSBMin", (Number)0.0);
        jsonObject.addProperty("topColorHSBMax", (Number)0.05);
        jsonObject.addProperty("midColorHSBMin", (Number)0.22);
        jsonObject.addProperty("midColorHSBMax", (Number)0.41);
        jsonObject.addProperty("lowerColorHSBMin", (Number)0.6);
        jsonObject.addProperty("lowerColorHSBMax", (Number)0.88);
        AuroraData.createFile(jsonObject, filePath + File.separator + fileName);
    }

    public static void createAetherConfig(String filePath, String fileName) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", CURRENT_VERSION);
        jsonObject.addProperty("shouldAutoUpdate", Boolean.valueOf(true));
        JsonArray allowedDimensions = new JsonArray();
        allowedDimensions.add("aether:the_aether");
        allowedDimensions.add("aether_ii:aether_highlands");
        jsonObject.add("allowedDimensions", (JsonElement)allowedDimensions);
        jsonObject.add("allowedBiomes", (JsonElement)new JsonArray());
        jsonObject.addProperty("equatorZ", (Number)0);
        jsonObject.addProperty("blocks90", (Number)20000);
        jsonObject.addProperty("ignoreStarBrightness", Boolean.valueOf(false));
        jsonObject.addProperty("endlessPoles", Boolean.valueOf(false));
        jsonObject.addProperty("auroraHeightOffset", (Number)-2000);
        jsonObject.addProperty("pixelStyle", Boolean.valueOf(true));
        jsonObject.addProperty("auroraDetail", (Number)200);
        jsonObject.addProperty("yearLength", (Number)365);
        jsonObject.addProperty("auroraWaveOctaves", (Number)1);
        jsonObject.addProperty("auroraWaveAmplitude", (Number)1200);
        jsonObject.addProperty("auroraWaveFrequency", (Number)25);
        jsonObject.addProperty("auroraWaveSpeed", (Number)1.0E-6);
        jsonObject.addProperty("auroraHeightOctaves", (Number)1);
        jsonObject.addProperty("auroraHeightFrequency", (Number)100);
        jsonObject.addProperty("auroraHeightSpeed", (Number)2.0E-6);
        jsonObject.addProperty("auroraHeightAmplitudeTop", (Number)3000);
        jsonObject.addProperty("auroraHeightAmplitudeMid", (Number)500);
        jsonObject.addProperty("auroraHeightAmplitudeLower", (Number)200);
        jsonObject.addProperty("auroraWidth", (Number)0.5);
        jsonObject.addProperty("auroraHeight", (Number)0.02);
        jsonObject.addProperty("auroraFrequency", (Number)1);
        jsonObject.addProperty("auroraWidthRadius", (Number)0.5);
        jsonObject.addProperty("auroraLengthRadius", (Number)0.5);
        jsonObject.addProperty("auroraDistanceFactor", (Number)1.5);
        jsonObject.addProperty("auroraMaxPoleOffset", (Number)5000);
        jsonObject.addProperty("auroraRotationSpeed", (Number)0.5);
        jsonObject.addProperty("auroraVisiblityOctaves", (Number)1);
        jsonObject.addProperty("aboveHeadPosition", Boolean.valueOf(false));
        jsonObject.addProperty("playerMovementFactor", (Number)1.0E-4);
        jsonObject.addProperty("playerAltitudeFactor", (Number)1);
        jsonObject.addProperty("auroraBandDistanceFactor", (Number)1600);
        jsonObject.addProperty("auroraAmountOctaves", (Number)4);
        jsonObject.addProperty("auroraAmountAmplitude", (Number)1);
        jsonObject.addProperty("auroraColorUpdateSpeed", (Number)1);
        jsonObject.addProperty("blueLayerFactorExtra", (Number)0.5);
        jsonObject.addProperty("redLayerFactorExtra", (Number)1);
        jsonObject.addProperty("redLayerFactor", (Number)2);
        jsonObject.addProperty("greenLayerFactor", (Number)6);
        jsonObject.addProperty("blueLayerFactor", (Number)-1);
        jsonObject.addProperty("topColorCycle", (Number)1200);
        jsonObject.addProperty("midColorCycle", (Number)1200);
        jsonObject.addProperty("lowerColorCycle", (Number)1200);
        jsonObject.addProperty("topColorOctaves", (Number)2);
        jsonObject.addProperty("midColorOctaves", (Number)3);
        jsonObject.addProperty("lowerColorOctaves", (Number)1);
        jsonObject.addProperty("topColorHSBMin", (Number)0.0);
        jsonObject.addProperty("topColorHSBMax", (Number)0.05);
        jsonObject.addProperty("midColorHSBMin", (Number)0.22);
        jsonObject.addProperty("midColorHSBMax", (Number)0.41);
        jsonObject.addProperty("lowerColorHSBMin", (Number)0.6);
        jsonObject.addProperty("lowerColorHSBMax", (Number)0.88);
        AuroraData.createFile(jsonObject, filePath + File.separator + fileName);
    }

    public static void createEndConfig(String filePath, String fileName) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", CURRENT_VERSION);
        jsonObject.addProperty("shouldAutoUpdate", Boolean.valueOf(true));
        JsonArray allowedDimensions = new JsonArray();
        allowedDimensions.add("minecraft:the_end");
        jsonObject.add("allowedDimensions", (JsonElement)allowedDimensions);
        jsonObject.add("allowedBiomes", (JsonElement)new JsonArray());
        jsonObject.addProperty("equatorZ", (Number)0);
        jsonObject.addProperty("blocks90", (Number)20000);
        jsonObject.addProperty("ignoreStarBrightness", Boolean.valueOf(true));
        jsonObject.addProperty("endlessPoles", Boolean.valueOf(true));
        jsonObject.addProperty("auroraHeightOffset", (Number)-6000);
        jsonObject.addProperty("pixelStyle", Boolean.valueOf(true));
        jsonObject.addProperty("auroraDetail", (Number)200);
        jsonObject.addProperty("yearLength", (Number)365);
        jsonObject.addProperty("auroraWaveOctaves", (Number)1);
        jsonObject.addProperty("auroraWaveAmplitude", (Number)1200);
        jsonObject.addProperty("auroraWaveFrequency", (Number)25);
        jsonObject.addProperty("auroraWaveSpeed", (Number)1.0E-6);
        jsonObject.addProperty("auroraHeightOctaves", (Number)1);
        jsonObject.addProperty("auroraHeightFrequency", (Number)100);
        jsonObject.addProperty("auroraHeightSpeed", (Number)2.0E-6);
        jsonObject.addProperty("auroraHeightAmplitudeTop", (Number)3000);
        jsonObject.addProperty("auroraHeightAmplitudeMid", (Number)500);
        jsonObject.addProperty("auroraHeightAmplitudeLower", (Number)200);
        jsonObject.addProperty("auroraWidth", (Number)0.5);
        jsonObject.addProperty("auroraHeight", (Number)0.02);
        jsonObject.addProperty("auroraFrequency", (Number)1);
        jsonObject.addProperty("auroraWidthRadius", (Number)0.5);
        jsonObject.addProperty("auroraLengthRadius", (Number)0.5);
        jsonObject.addProperty("auroraDistanceFactor", (Number)1.5);
        jsonObject.addProperty("auroraMaxPoleOffset", (Number)5000);
        jsonObject.addProperty("auroraRotationSpeed", (Number)0.5);
        jsonObject.addProperty("auroraVisiblityOctaves", (Number)1);
        jsonObject.addProperty("aboveHeadPosition", Boolean.valueOf(true));
        jsonObject.addProperty("playerMovementFactor", (Number)1.0E-4);
        jsonObject.addProperty("playerAltitudeFactor", (Number)1);
        jsonObject.addProperty("auroraBandDistanceFactor", (Number)1600);
        jsonObject.addProperty("auroraAmountOctaves", (Number)4);
        jsonObject.addProperty("auroraAmountAmplitude", (Number)1);
        jsonObject.addProperty("auroraColorUpdateSpeed", (Number)1);
        jsonObject.addProperty("blueLayerFactorExtra", (Number)0.5);
        jsonObject.addProperty("redLayerFactorExtra", (Number)1);
        jsonObject.addProperty("redLayerFactor", (Number)2);
        jsonObject.addProperty("greenLayerFactor", (Number)6);
        jsonObject.addProperty("blueLayerFactor", (Number)-1);
        jsonObject.addProperty("topColorCycle", (Number)1200);
        jsonObject.addProperty("midColorCycle", (Number)1200);
        jsonObject.addProperty("lowerColorCycle", (Number)1200);
        jsonObject.addProperty("topColorOctaves", (Number)2);
        jsonObject.addProperty("midColorOctaves", (Number)3);
        jsonObject.addProperty("lowerColorOctaves", (Number)1);
        jsonObject.addProperty("topColorHSBMin", (Number)0.83);
        jsonObject.addProperty("topColorHSBMax", (Number)0.9);
        jsonObject.addProperty("midColorHSBMin", (Number)0.7);
        jsonObject.addProperty("midColorHSBMax", (Number)0.83);
        jsonObject.addProperty("lowerColorHSBMin", (Number)0.64);
        jsonObject.addProperty("lowerColorHSBMax", (Number)0.83);
        AuroraData.createFile(jsonObject, filePath + File.separator + fileName);
    }

    public static void createFile(JsonObject jsonObject, String fileName) {
        try (FileWriter file = new FileWriter(fileName);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String pretty = gson.toJson((JsonElement)jsonObject);
            file.write(pretty);
            file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

