/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.eternal_starlight;

import cn.leolezury.eternalstarlight.common.item.combat.ESItemTiers;
import cn.leolezury.eternalstarlight.common.registry.ESArmorMaterials;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class StarlightAffixLootProvider
extends AffixLootEntryProvider {
    String mod = "eternal_starlight";
    private static ResourceKey<Level> STARLIGHT = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"eternal_starlight:starlight"));
    public Map<Holder<ArmorMaterial>, TieredWeights> armorWeights = new HashMap<Holder<ArmorMaterial>, TieredWeights>();
    public Map<Tier, TieredWeights> toolWeights = new HashMap<Tier, TieredWeights>();
    public Map<Item, TieredWeights> itemWeights = new HashMap<Item, TieredWeights>();
    protected static final TieredWeights ALCHEMIST = TieredWeights.builder().with(WorldTier.FRONTIER, 5, 0.0f).with(WorldTier.ASCENT, 10, 0.0f).build();
    protected static final TieredWeights AIR_SAC = TieredWeights.builder().with(WorldTier.FRONTIER, 5, 0.0f).with(WorldTier.ASCENT, 10, 0.0f).build();
    protected static final TieredWeights AMARAMBER = TieredWeights.builder().with(WorldTier.FRONTIER, 5, 0.0f).with(WorldTier.ASCENT, 10, 0.0f).build();
    protected static final TieredWeights AETHERSENT = TieredWeights.builder().with(WorldTier.FRONTIER, 10, 0.0f).with(WorldTier.ASCENT, 10, 0.0f).build();
    protected static final TieredWeights SWAMP_SILVER = TieredWeights.builder().with(WorldTier.ASCENT, 5, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights PETAL = TieredWeights.builder().with(WorldTier.ASCENT, 5, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights THERMAL = TieredWeights.builder().with(WorldTier.SUMMIT, 5, 0.0f).with(WorldTier.PINNACLE, 10, 0.0f).build();
    protected static final TieredWeights GLACITE = TieredWeights.builder().with(WorldTier.SUMMIT, 5, 0.0f).with(WorldTier.PINNACLE, 10, 0.0f).build();
    protected static final TieredWeights WEAPONS = TieredWeights.builder().with(WorldTier.FRONTIER, 5, 0.0f).with(WorldTier.ASCENT, 10, 0.0f).with(WorldTier.SUMMIT, 15, 0.0f).build();

    public StarlightAffixLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void generate() {
        this.armorWeights.put((Holder<ArmorMaterial>)ESArmorMaterials.ALCHEMIST.asHolder(), ALCHEMIST);
        this.armorWeights.put((Holder<ArmorMaterial>)ESArmorMaterials.AIR_SAC.asHolder(), AIR_SAC);
        this.armorWeights.put((Holder<ArmorMaterial>)ESArmorMaterials.AMARAMBER.asHolder(), AMARAMBER);
        this.armorWeights.put((Holder<ArmorMaterial>)ESArmorMaterials.AETHERSENT.asHolder(), AETHERSENT);
        this.armorWeights.put((Holder<ArmorMaterial>)ESArmorMaterials.SWAMP_SILVER.asHolder(), SWAMP_SILVER);
        this.armorWeights.put((Holder<ArmorMaterial>)ESArmorMaterials.THERMAL_SPRINGSTONE.asHolder(), THERMAL);
        this.armorWeights.put((Holder<ArmorMaterial>)ESArmorMaterials.GLACITE.asHolder(), GLACITE);
        this.toolWeights.put((Tier)ESItemTiers.AMARAMBER, AMARAMBER);
        this.toolWeights.put((Tier)ESItemTiers.AETHERSENT, AETHERSENT);
        this.toolWeights.put((Tier)ESItemTiers.SWAMP_SILVER, SWAMP_SILVER);
        this.toolWeights.put((Tier)ESItemTiers.THERMAL_SPRINGSTONE, THERMAL);
        this.toolWeights.put((Tier)ESItemTiers.PETAL, PETAL);
        this.toolWeights.put((Tier)ESItemTiers.GLACITE, GLACITE);
        this.addEntry(WEAPONS, new ItemStack(ESItems.GLACITE_SHIELD.asHolder()));
        this.addEntry(WEAPONS, new ItemStack(ESItems.CRESCENT_SPEAR.asHolder()));
        this.addEntry(WEAPONS, new ItemStack(ESItems.CRYSTAL_CROSSBOW.asHolder()));
        this.addEntry(WEAPONS, new ItemStack(ESItems.MECHANICAL_CROSSBOW.asHolder()));
        this.addEntry(WEAPONS, new ItemStack(ESItems.MOONRING_BOW.asHolder()));
        this.addEntry(WEAPONS, new ItemStack(ESItems.STARFALL_LONGBOW.asHolder()));
        for (Item i : BuiltInRegistries.ITEM) {
            ArmorItem a;
            TieredWeights weights;
            LootCategory cat;
            if (!this.mod.equals(BuiltInRegistries.ITEM.getKey((Object)i).getNamespace()) || (cat = LootCategory.forItem((ItemStack)i.getDefaultInstance())).isNone()) continue;
            if (i instanceof TieredItem) {
                TieredItem t = (TieredItem)i;
                weights = this.toolWeights.get(t.getTier());
                if (weights == null) continue;
                this.addEntry(weights, new ItemStack((ItemLike)i));
                continue;
            }
            if (!(i instanceof ArmorItem) || (a = (ArmorItem)i).getType() == ArmorItem.Type.BODY || (weights = this.armorWeights.get(a.getMaterial())) == null) continue;
            this.addEntry(weights, new ItemStack((ItemLike)i));
        }
    }

    public String getName() {
        return "Eternal Starlight Affix Loot Entries";
    }

    protected void addEntry(TieredWeights weights, ItemStack stack) {
        ResourceLocation key = ApothicCompats.loc(this.mod + "/" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath());
        this.addConditionally(key, (CodecProvider)new AffixLootEntry(weights, Constraints.forDimension(STARLIGHT), stack, Set.of()), new ICondition[]{new ModLoadedCondition(this.mod)});
    }
}

