/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.curios;

import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.affix.AttributeAffix;
import dev.shadowsoffire.apotheosis.data.AffixProvider;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import ianm1647.ancientreforging.AncientReforging;
import ianm1647.apothic_compats.ApothicCompats;
import ianm1647.apothic_compats.loot.ModLootCategories;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class CuriosAffixProvider
extends AffixProvider {
    String mod = "curios";
    public static final LootCategory[] CURIOS = new LootCategory[]{ModLootCategories.BACK, ModLootCategories.BELT, ModLootCategories.BODY, ModLootCategories.BRACELET, ModLootCategories.CHARM, ModLootCategories.CURIO, ModLootCategories.FEET, ModLootCategories.HANDS, ModLootCategories.HEAD, ModLootCategories.NECKLACE, ModLootCategories.RING};

    public CuriosAffixProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "Curios Affixes";
    }

    public void generate() {
        LootRarity common = CuriosAffixProvider.rarity("common");
        LootRarity uncommon = CuriosAffixProvider.rarity("uncommon");
        LootRarity rare = CuriosAffixProvider.rarity("rare");
        LootRarity epic = CuriosAffixProvider.rarity("epic");
        LootRarity mythic = CuriosAffixProvider.rarity("mythic");
        LootRarity ancient = CuriosAffixProvider.ancientRarity("ancient");
        this.addArsAttribute("curios", "mana", (Holder<Attribute>)PerkAttributes.MAX_MANA, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 5.0f, 15.0f)).value(uncommon, 20.0f, 30.0f)).value(rare, 35.0f, 45.0f)).value(epic, 50.0f, 60.0f)).value(mythic, 65.0f, 75.0f));
        this.addAncientArsAttribute("curios", "mana", (Holder<Attribute>)PerkAttributes.MAX_MANA, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 80.0f, 90.0f));
        this.addArsAttribute("curios", "spell_damaged", (Holder<Attribute>)PerkAttributes.SPELL_DAMAGE_BONUS, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 0.05f, 0.1f)).value(uncommon, 0.125f, 0.175f)).value(rare, 0.2f, 0.25f)).value(epic, 0.275f, 0.325f)).value(mythic, 0.35f, 0.4f));
        this.addAncientArsAttribute("curios", "spell_damaged", (Holder<Attribute>)PerkAttributes.SPELL_DAMAGE_BONUS, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.425f, 0.475f));
        this.addArsAttribute("curios", "regenerative", (Holder<Attribute>)PerkAttributes.MANA_REGEN_BONUS, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 0.05f, 0.1f)).value(uncommon, 0.15f, 0.2f)).value(rare, 0.25f, 0.3f)).value(epic, 0.35f, 0.4f)).value(mythic, 0.45f, 0.5f));
        this.addAncientArsAttribute("curios", "regenerative", (Holder<Attribute>)PerkAttributes.MANA_REGEN_BONUS, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.55f, 0.6f));
        this.addAttribute("curios", "lucky", (Holder<Attribute>)Attributes.LUCK, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(0.25f)).value(uncommon, 1.0f, 1.5f)).value(rare, 2.0f, 3.0f)).value(epic, 2.5f, 4.0f)).value(mythic, 3.0f, 6.0f));
        this.addAttribute("curios", "windswept", (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 0.05f, 0.15f)).value(uncommon, 0.1f, 0.2f)).value(rare, 0.15f, 0.25f)).value(epic, 0.2f, 0.3f)).value(mythic, 0.25f, 0.35f));
        this.addAttribute("curios", "aquatic", (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 0.1f, 0.15f)).value(uncommon, 0.15f, 0.2f)).value(rare, 0.25f, 0.3f)).value(epic, 0.35f, 0.4f)).value(mythic, 0.45f, 0.5f));
        this.addAttribute("curios", "blessed", (Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(0.25f)).value(common, 1.0f, 2.0f)).value(uncommon, 2.0f, 3.0f)).value(rare, 3.0f, 4.0f)).value(epic, 4.0f, 5.0f)).value(mythic, 5.0f, 6.0f));
        this.addAttribute("curios", "gravitational", (Holder<Attribute>)Attributes.GRAVITY, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(-0.01f)).value(common, -0.1f, -0.15f)).value(uncommon, -0.1f, -0.2f)).value(rare, -0.15f, -0.25f)).value(epic, -0.2f, -0.3f)).value(mythic, -0.25f, -0.4f));
        this.addAttribute("curios", "ironforged", (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(0.25f)).value(common, 1.0f, 1.5f)).value(uncommon, 1.0f, 2.0f)).value(rare, 2.0f, 4.0f)).value(epic, 3.0f, 4.0f)).value(mythic, 3.0f, 5.0f));
        this.addAttribute("curios", "spiritual", (Holder<Attribute>)ALObjects.Attributes.HEALING_RECEIVED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(rare, 0.05f, 0.15f)).value(epic, 0.2f, 0.25f)).value(mythic, 0.2f, 0.35f));
        this.addAttribute("curios", "stalwart", (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(uncommon, 0.05f, 0.1f)).value(rare, 0.05f, 0.1f)).value(epic, 0.15f, 0.2f)).value(mythic, 0.25f, 0.35f));
        this.addAttribute("curios", "fireproof", (Holder<Attribute>)Attributes.BURNING_TIME, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(-0.05f)).value(uncommon, -0.1f, -0.15f)).value(rare, -0.1f, -0.2f)).value(epic, -0.15f, -0.45f)).value(mythic, -0.35f, -0.65f));
        this.addAttribute("curios", "oxygenated", (Holder<Attribute>)Attributes.OXYGEN_BONUS, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(uncommon, 0.1f, 0.25f)).value(rare, 0.15f, 0.35f)).value(epic, 0.2f, 0.5f)).value(mythic, 0.35f, 0.85f));
        this.addAttribute("curios", "experienced", (Holder<Attribute>)ALObjects.Attributes.EXPERIENCE_GAINED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 0.15f, 0.25f)).value(uncommon, 0.2f, 0.3f)).value(rare, 0.25f, 0.35f)).value(epic, 0.3f, 0.5f)).value(mythic, 0.45f, 0.65f));
        this.addAttribute("curios", "submerged", (Holder<Attribute>)Attributes.SUBMERGED_MINING_SPEED, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 0.05f, 0.1f)).value(uncommon, 0.15f, 0.25f)).value(rare, 0.25f, 0.45f)).value(epic, 0.4f, 0.55f)).value(mythic, 0.55f, 0.75f));
        this.addAttribute("curios", "vampiric", (Holder<Attribute>)ALObjects.Attributes.LIFE_STEAL, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, d -> d.weights(TieredWeights.forAllTiers((int)25, (float)0.1f)))).categories(CURIOS).value(common, 0.1f, 0.15f)).value(uncommon, 0.1f, 0.25f)).value(rare, 0.2f, 0.35f)).value(epic, 0.25f, 0.4f)).value(mythic, 0.35f, 0.45f));
        this.addAttribute("curios", "murderous", (Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(rare, 0.1f, 0.25f)).value(epic, 0.2f, 0.38f)).value(mythic, 0.3f, 0.5f));
        this.addAttribute("curios", "lacerating", (Holder<Attribute>)ALObjects.Attributes.CRIT_DAMAGE, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 0.05f, 0.15f)).value(uncommon, 0.1f, 0.2f)).value(rare, 0.15f, 0.25f)).value(epic, 0.15f, 0.35f)).value(mythic, 0.25f, 0.45f));
        this.addAttribute("curios", "graceful", (Holder<Attribute>)Attributes.ATTACK_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(common, 0.1f, 0.2f)).value(uncommon, 0.2f, 0.3f)).value(rare, 0.3f, 0.4f)).value(epic, 0.4f, 0.5f)).value(mythic, 0.45f, 0.6f));
        this.addAttribute("curios", "berserking", (Holder<Attribute>)ALObjects.Attributes.OVERHEAL, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, d -> d.weights(TieredWeights.forAllTiers((int)25, (float)0.1f)).exclusiveWith(CuriosAffixProvider.afx("melee/attribute/vampiric")))).categories(CURIOS).value(common, 0.1f, 0.2f)).value(uncommon, 0.1f, 0.25f)).value(rare, 0.15f, 0.3f)).value(epic, 0.2f, 0.4f)).value(mythic, 0.35f, 0.5f));
        this.addAncientAttribute("curios", "lucky", (Holder<Attribute>)Attributes.LUCK, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(0.25f)).value(ancient, 6.0f, 12.0f));
        this.addAncientAttribute("curios", "windswept", (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.3f, 0.4f));
        this.addAncientAttribute("curios", "aquatic", (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.5f, 0.75f));
        this.addAncientAttribute("curios", "blessed", (Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(0.25f)).value(ancient, 6.0f, 10.0f));
        this.addAncientAttribute("curios", "gravitational", (Holder<Attribute>)Attributes.GRAVITY, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(-0.01f)).value(ancient, -0.4f, -0.85f));
        this.addAncientAttribute("curios", "ironforged", (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(0.25f)).value(ancient, 5.0f, 8.0f));
        this.addAncientAttribute("curios", "spiritual", (Holder<Attribute>)ALObjects.Attributes.HEALING_RECEIVED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.4f, 0.65f));
        this.addAncientAttribute("curios", "stalwart", (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.4f, 0.65f));
        this.addAncientAttribute("curios", "fireproof", (Holder<Attribute>)Attributes.BURNING_TIME, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).step(-0.05f)).value(ancient, -0.45f, -0.85f));
        this.addAncientAttribute("curios", "oxygenated", (Holder<Attribute>)Attributes.OXYGEN_BONUS, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.55f, 0.95f));
        this.addAncientAttribute("curios", "experienced", (Holder<Attribute>)ALObjects.Attributes.EXPERIENCE_GAINED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.55f, 0.85f));
        this.addAncientAttribute("curios", "submerged", (Holder<Attribute>)Attributes.SUBMERGED_MINING_SPEED, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.65f, 0.95f));
        this.addAncientAttribute("curios", "vampiric", (Holder<Attribute>)ALObjects.Attributes.LIFE_STEAL, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, d -> d.weights(TieredWeights.forAllTiers((int)25, (float)0.1f)))).categories(CURIOS).value(ancient, 0.45f, 0.55f));
        this.addAncientAttribute("curios", "murderous", (Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.4f, 0.55f));
        this.addAncientAttribute("curios", "lacerating", (Holder<Attribute>)ALObjects.Attributes.CRIT_DAMAGE, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.3f, 0.65f));
        this.addAncientAttribute("curios", "graceful", (Holder<Attribute>)Attributes.ATTACK_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(CURIOS).value(ancient, 0.55f, 0.7f));
        this.addAncientAttribute("curios", "berserking", (Holder<Attribute>)ALObjects.Attributes.OVERHEAL, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, d -> d.weights(TieredWeights.forAllTiers((int)25, (float)0.1f)).exclusiveWith(CuriosAffixProvider.afx("melee/attribute/vampiric")))).categories(CURIOS).value(ancient, 0.4f, 0.55f));
    }

    public void addAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    public void addArsAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ars_nouveau")});
    }

    public void addAncientAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    public void addAncientArsAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ars_nouveau"), new ModLoadedCondition("ancientreforging")});
    }

    private static DynamicHolder<Affix> afx(String path) {
        return AffixRegistry.INSTANCE.holder(ApothicCompats.loc(path));
    }

    private static LootRarity rarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(Apotheosis.loc((String)path))));
    }

    private static LootRarity ancientRarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(AncientReforging.loc((String)path))));
    }
}

