/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.ars_nouveau;

import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.affix.AttributeAffix;
import dev.shadowsoffire.apotheosis.affix.effect.DamageReductionAffix;
import dev.shadowsoffire.apotheosis.affix.effect.EnchantmentAffix;
import dev.shadowsoffire.apotheosis.affix.effect.MobEffectAffix;
import dev.shadowsoffire.apotheosis.data.AffixProvider;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.ancientreforging.AncientReforging;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class ArsAffixProvider
extends AffixProvider {
    String mod = "ars_nouveau";

    public ArsAffixProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "Ars Nouveau Affixes";
    }

    public void generate() {
        LootRarity common = ArsAffixProvider.rarity("common");
        LootRarity uncommon = ArsAffixProvider.rarity("uncommon");
        LootRarity rare = ArsAffixProvider.rarity("rare");
        LootRarity epic = ArsAffixProvider.rarity("epic");
        LootRarity mythic = ArsAffixProvider.rarity("mythic");
        LootRarity ancient = ArsAffixProvider.ancientRarity("ancient");
        this.addAttribute("armor", "mana", (Holder<Attribute>)PerkAttributes.MAX_MANA, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).categories(new LootCategory[]{Apoth.LootCategories.SHIELD}).value(common, 15.0f, 25.0f)).value(uncommon, 30.0f, 40.0f)).value(rare, 45.0f, 55.0f)).value(epic, 60.0f, 70.0f)).value(mythic, 75.0f, 85.0f));
        this.addAncientAttribute("armor", "mana", (Holder<Attribute>)PerkAttributes.MAX_MANA, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).categories(new LootCategory[]{Apoth.LootCategories.SHIELD}).value(ancient, 90.0f, 100.0f));
        this.addMobEffect("melee", "freezing", (Holder<MobEffect>)ModPotions.FREEZING_EFFECT, MobEffectAffix.Target.ATTACK_TARGET, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(uncommon, 100, 100, 0, 80).value(rare, 100, 120, 0, 80).value(epic, 100, 120, 0, 80).value(mythic, 100, 120, StepFunction.fromBounds((float)0.0f, (float)1.0f, (float)0.125f), 80));
        this.addAncientMobEffect("melee", "freezing", (Holder<MobEffect>)ModPotions.FREEZING_EFFECT, MobEffectAffix.Target.ATTACK_TARGET, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(ancient, 200, 360, StepFunction.fromBounds((float)1.0f, (float)2.0f, (float)0.125f), 80));
        this.addMobEffect("melee", "blasting", (Holder<MobEffect>)ModPotions.BLAST_EFFECT, MobEffectAffix.Target.ATTACK_TARGET, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(uncommon, 100, 100, 0, 80).value(rare, 100, 120, 0, 80).value(epic, 100, 120, 0, 80).value(mythic, 100, 120, StepFunction.fromBounds((float)0.0f, (float)1.0f, (float)0.125f), 80));
        this.addAncientMobEffect("melee", "blasting", (Holder<MobEffect>)ModPotions.BLAST_EFFECT, MobEffectAffix.Target.ATTACK_TARGET, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(ancient, 200, 360, StepFunction.fromBounds((float)1.0f, (float)2.0f, (float)0.125f), 80));
        this.addMobEffect("melee", "shocking", (Holder<MobEffect>)ModPotions.SHOCKED_EFFECT, MobEffectAffix.Target.ATTACK_TARGET, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(uncommon, 100, 100, 0, 80).value(rare, 100, 120, 0, 80).value(epic, 100, 120, 0, 80).value(mythic, 100, 120, StepFunction.fromBounds((float)0.0f, (float)1.0f, (float)0.125f), 80));
        this.addAncientMobEffect("melee", "shocking", (Holder<MobEffect>)ModPotions.SHOCKED_EFFECT, MobEffectAffix.Target.ATTACK_TARGET, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(ancient, 200, 360, StepFunction.fromBounds((float)1.0f, (float)2.0f, (float)0.125f), 80));
        this.addMobEffect("melee", "snaring", (Holder<MobEffect>)ModPotions.SNARE_EFFECT, MobEffectAffix.Target.ATTACK_TARGET, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(uncommon, 100, 100, 0, 80).value(rare, 100, 120, 0, 80).value(epic, 100, 120, 0, 80).value(mythic, 100, 120, StepFunction.fromBounds((float)0.0f, (float)1.0f, (float)0.125f), 80));
        this.addAncientMobEffect("melee", "snaring", (Holder<MobEffect>)ModPotions.SNARE_EFFECT, MobEffectAffix.Target.ATTACK_TARGET, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(ancient, 200, 360, StepFunction.fromBounds((float)1.0f, (float)2.0f, (float)0.125f), 80));
        this.addMobEffect("melee", "mana_regen", (Holder<MobEffect>)ModPotions.MANA_REGEN_EFFECT, MobEffectAffix.Target.ATTACK_SELF, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(uncommon, 100, 100, 0, 80).value(rare, 100, 120, 0, 80).value(epic, 100, 120, 0, 80).value(mythic, 100, 120, StepFunction.fromBounds((float)0.0f, (float)1.0f, (float)0.125f), 80));
        this.addAncientMobEffect("melee", "mana_regen", (Holder<MobEffect>)ModPotions.MANA_REGEN_EFFECT, MobEffectAffix.Target.ATTACK_SELF, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.MELEE_WEAPON, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(ancient, 200, 360, StepFunction.fromBounds((float)1.0f, (float)2.0f, (float)0.125f), 80));
        this.addMobEffect("ranged", "mana_regen", (Holder<MobEffect>)ModPotions.MANA_REGEN_EFFECT, MobEffectAffix.Target.ATTACK_SELF, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.BOW, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(uncommon, 100, 100, 0, 80).value(rare, 100, 120, 0, 80).value(epic, 100, 120, 0, 80).value(mythic, 100, 120, StepFunction.fromBounds((float)0.0f, (float)1.0f, (float)0.125f), 80));
        this.addAncientMobEffect("ranged", "mana_regen", (Holder<MobEffect>)ModPotions.MANA_REGEN_EFFECT, MobEffectAffix.Target.ATTACK_SELF, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.BOW, Apoth.LootCategories.TRIDENT}).stacking().limit(3).value(ancient, 200, 360, StepFunction.fromBounds((float)1.0f, (float)2.0f, (float)0.125f), 80));
    }

    private void addEnchantment(String type, String name, Holder<Enchantment> enchantment, EnchantmentAffix.Mode mode, UnaryOperator<EnchantmentAffix.Builder> config) {
        EnchantmentAffix.Builder builder = new EnchantmentAffix.Builder(enchantment, mode);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/enchantment/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    private void addMobEffect(String type, String name, Holder<MobEffect> effect, MobEffectAffix.Target target, UnaryOperator<MobEffectAffix.Builder> config) {
        MobEffectAffix.Builder builder = new MobEffectAffix.Builder(effect, target);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/mob_effect/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    private void addDamageReduction(String type, String name, DamageReductionAffix.DamageType dType, UnaryOperator<DamageReductionAffix.Builder> config) {
        DamageReductionAffix.Builder builder = new DamageReductionAffix.Builder(dType);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/dmg_reduction/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    private void addAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    private void addAncientEnchantment(String type, String name, Holder<Enchantment> enchantment, EnchantmentAffix.Mode mode, UnaryOperator<EnchantmentAffix.Builder> config) {
        EnchantmentAffix.Builder builder = new EnchantmentAffix.Builder(enchantment, mode);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/enchantment/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private void addAncientMobEffect(String type, String name, Holder<MobEffect> effect, MobEffectAffix.Target target, UnaryOperator<MobEffectAffix.Builder> config) {
        MobEffectAffix.Builder builder = new MobEffectAffix.Builder(effect, target);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/mob_effect/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private void addAncientDamageReduction(String type, String name, DamageReductionAffix.DamageType dType, UnaryOperator<DamageReductionAffix.Builder> config) {
        DamageReductionAffix.Builder builder = new DamageReductionAffix.Builder(dType);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/dmg_reduction/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private void addAncientAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private static LootRarity rarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(Apotheosis.loc((String)path))));
    }

    private static LootRarity ancientRarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(AncientReforging.loc((String)path))));
    }
}

