/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.allthemodium;

import com.thevortex.allthemodium.material.ATMTier;
import com.thevortex.allthemodium.registry.ArmorRegistries;
import com.thevortex.allthemodium.registry.ModRegistry;
import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class ATMAffixLootProvider
extends AffixLootEntryProvider {
    String mod = "allthemodium";
    public Map<Holder<ArmorMaterial>, TieredWeights> armorWeights = new HashMap<Holder<ArmorMaterial>, TieredWeights>();
    public Map<Tier, TieredWeights> toolWeights = new HashMap<Tier, TieredWeights>();
    public Map<Item, TieredWeights> itemWeights = new HashMap<Item, TieredWeights>();
    protected static final TieredWeights ALLTHEMODIUM = TieredWeights.builder().with(WorldTier.PINNACLE, 5, 0.0f).build();
    protected static final TieredWeights VIBRANIUM = TieredWeights.builder().with(WorldTier.PINNACLE, 2, 0.0f).build();
    protected static final TieredWeights UNOBTAINIUM = TieredWeights.builder().with(WorldTier.PINNACLE, 1, 0.0f).build();

    public ATMAffixLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void generate() {
        this.armorWeights.put((Holder<ArmorMaterial>)ArmorRegistries.ATM, ALLTHEMODIUM);
        this.armorWeights.put((Holder<ArmorMaterial>)ArmorRegistries.VIB, VIBRANIUM);
        this.armorWeights.put((Holder<ArmorMaterial>)ArmorRegistries.UNOB, UNOBTAINIUM);
        this.toolWeights.put((Tier)ATMTier.ALLTHEMODIUM, ALLTHEMODIUM);
        this.toolWeights.put((Tier)ATMTier.VIBRANIUM, VIBRANIUM);
        this.toolWeights.put((Tier)ATMTier.UNOBTAINIUM, UNOBTAINIUM);
        this.addEntry(ALLTHEMODIUM, ((MaceItem)ModRegistry.ATM_MACE.get()).getDefaultInstance());
        this.addEntry(ALLTHEMODIUM, ((BowItem)ModRegistry.ATM_BOW.get()).getDefaultInstance());
        this.addEntry(VIBRANIUM, ((MaceItem)ModRegistry.VIB_MACE.get()).getDefaultInstance());
        this.addEntry(UNOBTAINIUM, ((MaceItem)ModRegistry.UNO_MACE.get()).getDefaultInstance());
        this.addEntry(UNOBTAINIUM, ((CrossbowItem)ModRegistry.UNO_BOW.get()).getDefaultInstance());
        for (Item i : BuiltInRegistries.ITEM) {
            ArmorItem a;
            TieredWeights weights;
            LootCategory cat;
            if (!this.mod.equals(BuiltInRegistries.ITEM.getKey((Object)i).getNamespace()) || (cat = LootCategory.forItem((ItemStack)i.getDefaultInstance())).isNone()) continue;
            if (i instanceof TieredItem) {
                TieredItem t = (TieredItem)i;
                weights = this.toolWeights.get(t.getTier());
                if (weights == null) continue;
                this.addEntry(weights, new ItemStack((ItemLike)i));
                continue;
            }
            if (!(i instanceof ArmorItem) || (a = (ArmorItem)i).getType() == ArmorItem.Type.BODY || (weights = this.armorWeights.get(a.getMaterial())) == null) continue;
            this.addEntry(weights, new ItemStack((ItemLike)i));
        }
    }

    public String getName() {
        return "Allthemodium Loot Entries";
    }

    protected void addEntry(TieredWeights weights, ItemStack stack) {
        ResourceLocation key = ApothicCompats.loc(this.mod + "/" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath());
        this.addConditionally(key, (CodecProvider)new AffixLootEntry(weights, Constraints.forDimension((ResourceKey)Level.OVERWORLD), stack, Set.of()), new ICondition[]{new ModLoadedCondition(this.mod)});
    }
}

