/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.aether;

import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.combat.AetherArmorMaterials;
import com.aetherteam.aether.item.combat.AetherItemTiers;
import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class AetherAffixLootProvider
extends AffixLootEntryProvider {
    String mod = "aether";
    private static ResourceKey<Level> AETHER = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"aether:the_aether"));
    public Map<Holder<ArmorMaterial>, TieredWeights> armorWeights = new HashMap<Holder<ArmorMaterial>, TieredWeights>();
    public Map<Tier, TieredWeights> toolWeights = new HashMap<Tier, TieredWeights>();
    public Map<Item, TieredWeights> itemWeights = new HashMap<Item, TieredWeights>();
    protected static final TieredWeights SKYROOT = TieredWeights.builder().with(WorldTier.HAVEN, 25, 1.0f).with(WorldTier.FRONTIER, 10, 0.0f).with(WorldTier.ASCENT, 5, 0.0f).build();
    protected static final TieredWeights HOLYSTONE = TieredWeights.builder().with(WorldTier.FRONTIER, 25, 1.0f).with(WorldTier.ASCENT, 10, 0.0f).with(WorldTier.SUMMIT, 5, 0.0f).build();
    protected static final TieredWeights ZANITE = TieredWeights.builder().with(WorldTier.ASCENT, 25, 0.0f).with(WorldTier.SUMMIT, 15, 0.0f).with(WorldTier.PINNACLE, 5, 0.0f).build();
    protected static final TieredWeights GRAVITITE = TieredWeights.builder().with(WorldTier.ASCENT, 25, 0.0f).with(WorldTier.SUMMIT, 15, 0.0f).with(WorldTier.PINNACLE, 5, 0.0f).build();
    protected static final TieredWeights VALKYRIE = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights OBSIDIAN = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights NEPTUNE = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights PHOENIX = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights SENTRY = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights CANDY_CANE = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights VAMPIRE = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights HOLY = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights LIGHTNING = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights FLAMING = TieredWeights.builder().with(WorldTier.SUMMIT, 10, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights BOWS = TieredWeights.builder().with(WorldTier.SUMMIT, 7, 1.0f).with(WorldTier.PINNACLE, 10, 1.0f).build();
    protected static final TieredWeights SHIELDS = TieredWeights.builder().with(WorldTier.SUMMIT, 7, 1.0f).with(WorldTier.PINNACLE, 10, 1.0f).build();

    public AetherAffixLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void generate() {
        this.armorWeights.put((Holder<ArmorMaterial>)AetherArmorMaterials.ZANITE, ZANITE);
        this.armorWeights.put((Holder<ArmorMaterial>)AetherArmorMaterials.GRAVITITE, GRAVITITE);
        this.armorWeights.put((Holder<ArmorMaterial>)AetherArmorMaterials.VALKYRIE, VALKYRIE);
        this.armorWeights.put((Holder<ArmorMaterial>)AetherArmorMaterials.OBSIDIAN, OBSIDIAN);
        this.armorWeights.put((Holder<ArmorMaterial>)AetherArmorMaterials.NEPTUNE, NEPTUNE);
        this.armorWeights.put((Holder<ArmorMaterial>)AetherArmorMaterials.PHOENIX, PHOENIX);
        this.armorWeights.put((Holder<ArmorMaterial>)AetherArmorMaterials.SENTRY, SENTRY);
        this.toolWeights.put((Tier)AetherItemTiers.SKYROOT, SKYROOT);
        this.toolWeights.put((Tier)AetherItemTiers.HOLYSTONE, HOLYSTONE);
        this.toolWeights.put((Tier)AetherItemTiers.ZANITE, ZANITE);
        this.toolWeights.put((Tier)AetherItemTiers.GRAVITITE, GRAVITITE);
        this.toolWeights.put((Tier)AetherItemTiers.VALKYRIE, VALKYRIE);
        this.toolWeights.put((Tier)AetherItemTiers.CANDY_CANE, CANDY_CANE);
        this.toolWeights.put((Tier)AetherItemTiers.VAMPIRE, VAMPIRE);
        this.toolWeights.put((Tier)AetherItemTiers.HOLY, HOLY);
        this.toolWeights.put((Tier)AetherItemTiers.LIGHTNING, LIGHTNING);
        this.toolWeights.put((Tier)AetherItemTiers.FLAMING, FLAMING);
        this.itemWeights.put((Item)AetherItems.PHOENIX_BOW.get(), BOWS);
        this.addEntry(BOWS, new ItemStack((ItemLike)AetherItems.POISON_DART_SHOOTER.get()));
        this.addEntry(BOWS, new ItemStack((ItemLike)AetherItems.ENCHANTED_DART_SHOOTER.get()));
        this.addEntry(BOWS, new ItemStack((ItemLike)AetherItems.GOLDEN_DART_SHOOTER.get()));
        for (Item i : BuiltInRegistries.ITEM) {
            Item t;
            ArmorItem a;
            TieredWeights weights;
            LootCategory cat;
            if (!this.mod.equals(BuiltInRegistries.ITEM.getKey((Object)i).getNamespace()) || (cat = LootCategory.forItem((ItemStack)i.getDefaultInstance())).isNone()) continue;
            if (i instanceof TieredItem) {
                TieredItem t2 = (TieredItem)i;
                weights = this.toolWeights.get(t2.getTier());
                if (weights == null) continue;
                this.addEntry(weights, new ItemStack((ItemLike)i));
                continue;
            }
            if (i instanceof ArmorItem && (a = (ArmorItem)i).getType() != ArmorItem.Type.BODY) {
                weights = this.armorWeights.get(a.getMaterial());
                if (weights == null) continue;
                this.addEntry(weights, new ItemStack((ItemLike)i));
                continue;
            }
            if (!(i instanceof Item) || (weights = this.itemWeights.get(t = i)) == null) continue;
            this.addEntry(weights, new ItemStack((ItemLike)i));
        }
    }

    public String getName() {
        return "Aether Affix Loot Entries";
    }

    protected void addEntry(TieredWeights weights, ItemStack stack) {
        ResourceLocation key = ApothicCompats.loc(this.mod + "/" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath());
        this.addConditionally(key, (CodecProvider)new AffixLootEntry(weights, Constraints.forDimension(AETHER), stack, Set.of()), new ICondition[]{new ModLoadedCondition(this.mod)});
    }
}

