/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.affix.malum;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.IFestiveMarker;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.apothic_compats.loot.ModLootCategories;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class ScytheFestiveAffix
extends Affix {
    public static Codec<ScytheFestiveAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(ScytheFestiveAffix.affixDef(), (App)LootRarity.mapCodec((Codec)StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, ScytheFestiveAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public ScytheFestiveAffix(AffixDefinition def, Map<LootRarity, StepFunction> values) {
        super(def);
        this.values = values;
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{ScytheFestiveAffix.fmt((float)(100.0f * this.getTrueLevel(inst.getRarity(), inst.level())))});
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        MutableComponent comp = this.getDescription(inst, ctx);
        MutableComponent minComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ScytheFestiveAffix.fmt((float)(100.0f * this.getTrueLevel(inst.getRarity(), 0.0f)))});
        MutableComponent maxComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ScytheFestiveAffix.fmt((float)(100.0f * this.getTrueLevel(inst.getRarity(), 1.0f)))});
        return comp.append((Component)ScytheFestiveAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return ModLootCategories.isScythe(cat) && this.values.containsKey(rarity);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public static void markEquipment(LivingDeathEvent e) {
        if (e.getEntity() instanceof Player || e.getEntity().getPersistentData().getBoolean("apoth.no_pinata")) {
            return;
        }
        e.getEntity().getAllSlots().forEach(i -> {
            if (!i.isEmpty()) {
                ((IFestiveMarker)i).setMarked(true);
            }
        });
    }

    public void modifyEntityLoot(AffixInstance inst, LivingDropsEvent e) {
        LivingEntity dead = e.getEntity();
        if (dead instanceof Player || dead.getPersistentData().getBoolean("apoth.no_pinata")) {
            return;
        }
        Entity entity = e.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!e.getDrops().isEmpty() && inst != null && inst.isValid() && player.level().random.nextFloat() < this.getTrueLevel((LootRarity)inst.rarity().get(), inst.level())) {
                player.level().playSound(null, dead.getX(), dead.getY(), dead.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 4.0f, (1.0f + (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.2f) * 0.7f);
                ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, dead.getX(), dead.getY(), dead.getZ(), 2, 1.0, 0.0, 0.0, 0.0);
                ArrayList drops = new ArrayList(e.getDrops());
                for (ItemEntity item : drops) {
                    if (((IFestiveMarker)item.getItem()).isMarked()) continue;
                    for (int i = 0; i < 20; ++i) {
                        e.getDrops().add(new ItemEntity(player.level(), item.getX(), item.getY(), item.getZ(), item.getItem().copy()));
                    }
                }
                for (ItemEntity item : e.getDrops()) {
                    item.setPos(dead.getX(), dead.getY(), dead.getZ());
                    item.setDeltaMovement(-0.3 + dead.level().random.nextDouble() * 0.6, 0.3 + dead.level().random.nextDouble() * 0.3, -0.3 + dead.level().random.nextDouble() * 0.6);
                }
            }
        }
    }

    public static void removeMarker(LivingDropsEvent e) {
        e.getDrops().stream().forEach(ent -> {
            ItemStack s = ent.getItem();
            ((IFestiveMarker)s).setMarked(false);
            ent.setItem(s);
        });
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

