/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.research;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.hurts.sskirillss.relics.items.relics.base.data.research.StarData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResearchData {
    private Map<Integer, StarData> stars;
    private Multimap<Integer, Integer> links;

    public List<StarData> getConnectedStars(StarData star) {
        ArrayList<StarData> connectedStars = new ArrayList<StarData>();
        int starIndex = star.getIndex();
        if (this.links.containsKey((Object)starIndex)) {
            for (Integer connectedIndex : this.links.get((Object)starIndex)) {
                connectedStars.add(this.stars.get(connectedIndex));
            }
        }
        for (Map.Entry entry : this.links.entries()) {
            if (!((Integer)entry.getValue()).equals(starIndex)) continue;
            connectedStars.add(this.stars.get(entry.getKey()));
        }
        return connectedStars;
    }

    ResearchData(Map<Integer, StarData> stars, Multimap<Integer, Integer> links) {
        this.stars = stars;
        this.links = links;
    }

    public static ResearchDataBuilder builder() {
        return new ResearchDataBuilder();
    }

    public Map<Integer, StarData> getStars() {
        return this.stars;
    }

    public Multimap<Integer, Integer> getLinks() {
        return this.links;
    }

    public void setStars(Map<Integer, StarData> stars) {
        this.stars = stars;
    }

    public void setLinks(Multimap<Integer, Integer> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResearchData)) {
            return false;
        }
        ResearchData other = (ResearchData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, StarData> this$stars = this.getStars();
        Map<Integer, StarData> other$stars = other.getStars();
        if (this$stars == null ? other$stars != null : !((Object)this$stars).equals(other$stars)) {
            return false;
        }
        Multimap<Integer, Integer> this$links = this.getLinks();
        Multimap<Integer, Integer> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !this$links.equals(other$links));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResearchData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, StarData> $stars = this.getStars();
        result = result * 59 + ($stars == null ? 43 : ((Object)$stars).hashCode());
        Multimap<Integer, Integer> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        return result;
    }

    public String toString() {
        return "ResearchData(stars=" + String.valueOf(this.getStars()) + ", links=" + String.valueOf(this.getLinks()) + ")";
    }

    public static class ResearchDataBuilder {
        private Map<Integer, StarData> stars = new HashMap<Integer, StarData>();
        private Multimap<Integer, Integer> links = LinkedHashMultimap.create();

        public ResearchDataBuilder star(int index, int x, int y) {
            this.stars.put(index, new StarData(index, x, y));
            return this;
        }

        public ResearchDataBuilder link(int first, int second) {
            int n;
            if (first > second) {
                int n2 = first + second;
                second = first;
                n = n2 - second;
            } else {
                n = first;
            }
            this.links.put((Object)n, (Object)second);
            return this;
        }

        ResearchDataBuilder() {
        }

        public ResearchDataBuilder stars(Map<Integer, StarData> stars) {
            this.stars = stars;
            return this;
        }

        public ResearchDataBuilder links(Multimap<Integer, Integer> links) {
            this.links = links;
            return this;
        }

        public ResearchData build() {
            return new ResearchData(this.stars, this.links);
        }

        public String toString() {
            return "ResearchData.ResearchDataBuilder(stars=" + String.valueOf(this.stars) + ", links=" + String.valueOf(this.links) + ")";
        }
    }
}

