/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.leveling;

import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class LevelingSourceData {
    private final String id;
    private int initialValue;
    private Pair<UpgradeOperation, Integer> upgradeModifier;
    private int maxLevel;
    private int cost;
    private int requiredLevel;
    private String requiredAbility;
    private Function<ItemStack, ResourceLocation> icon;
    private Function<ItemStack, String> translationPath;
    private GemShape shape;
    private GemColor color;

    private static LevelingSourceDataBuilder builder(String id) {
        LevelingSourceDataBuilder builder = new LevelingSourceDataBuilder();
        builder.id(id);
        return builder;
    }

    public static LevelingSourceDataBuilder genericBuilder(String id) {
        LevelingSourceDataBuilder builder = LevelingSourceData.builder(id);
        builder.translationPath(stack -> "tooltip.relics.leveling_source.generic." + id);
        builder.genericIcon(id);
        return builder;
    }

    public static LevelingSourceDataBuilder abilityBuilder(String id, String ability) {
        LevelingSourceDataBuilder builder = LevelingSourceData.builder(id);
        builder.requiredAbility(ability);
        builder.abilityIcon(ability);
        builder.translationPath(stack -> "tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".leveling_source." + id);
        return builder;
    }

    public static LevelingSourceDataBuilder abilityBuilder(String ability) {
        return LevelingSourceData.abilityBuilder(ability, ability);
    }

    private static int $default$initialValue() {
        return 1;
    }

    private static int $default$maxLevel() {
        return 0;
    }

    private static int $default$cost() {
        return 0;
    }

    private static int $default$requiredLevel() {
        return 0;
    }

    private static String $default$requiredAbility() {
        return "";
    }

    private static GemShape $default$shape() {
        return GemShape.SQUARE;
    }

    private static GemColor $default$color() {
        return GemColor.RED;
    }

    LevelingSourceData(String id, int initialValue, Pair<UpgradeOperation, Integer> upgradeModifier, int maxLevel, int cost, int requiredLevel, String requiredAbility, Function<ItemStack, ResourceLocation> icon, Function<ItemStack, String> translationPath, GemShape shape, GemColor color) {
        this.id = id;
        this.initialValue = initialValue;
        this.upgradeModifier = upgradeModifier;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.requiredLevel = requiredLevel;
        this.requiredAbility = requiredAbility;
        this.icon = icon;
        this.translationPath = translationPath;
        this.shape = shape;
        this.color = color;
    }

    public String getId() {
        return this.id;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public Pair<UpgradeOperation, Integer> getUpgradeModifier() {
        return this.upgradeModifier;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getCost() {
        return this.cost;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public String getRequiredAbility() {
        return this.requiredAbility;
    }

    public Function<ItemStack, ResourceLocation> getIcon() {
        return this.icon;
    }

    public Function<ItemStack, String> getTranslationPath() {
        return this.translationPath;
    }

    public GemShape getShape() {
        return this.shape;
    }

    public GemColor getColor() {
        return this.color;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public void setUpgradeModifier(Pair<UpgradeOperation, Integer> upgradeModifier) {
        this.upgradeModifier = upgradeModifier;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public void setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    public void setRequiredAbility(String requiredAbility) {
        this.requiredAbility = requiredAbility;
    }

    public void setIcon(Function<ItemStack, ResourceLocation> icon) {
        this.icon = icon;
    }

    public void setTranslationPath(Function<ItemStack, String> translationPath) {
        this.translationPath = translationPath;
    }

    public void setShape(GemShape shape) {
        this.shape = shape;
    }

    public void setColor(GemColor color) {
        this.color = color;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LevelingSourceData)) {
            return false;
        }
        LevelingSourceData other = (LevelingSourceData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialValue() != other.getInitialValue()) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        if (this.getCost() != other.getCost()) {
            return false;
        }
        if (this.getRequiredLevel() != other.getRequiredLevel()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Pair<UpgradeOperation, Integer> this$upgradeModifier = this.getUpgradeModifier();
        Pair<UpgradeOperation, Integer> other$upgradeModifier = other.getUpgradeModifier();
        if (this$upgradeModifier == null ? other$upgradeModifier != null : !this$upgradeModifier.equals(other$upgradeModifier)) {
            return false;
        }
        String this$requiredAbility = this.getRequiredAbility();
        String other$requiredAbility = other.getRequiredAbility();
        if (this$requiredAbility == null ? other$requiredAbility != null : !this$requiredAbility.equals(other$requiredAbility)) {
            return false;
        }
        Function<ItemStack, ResourceLocation> this$icon = this.getIcon();
        Function<ItemStack, ResourceLocation> other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        Function<ItemStack, String> this$translationPath = this.getTranslationPath();
        Function<ItemStack, String> other$translationPath = other.getTranslationPath();
        if (this$translationPath == null ? other$translationPath != null : !this$translationPath.equals(other$translationPath)) {
            return false;
        }
        GemShape this$shape = this.getShape();
        GemShape other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !((Object)((Object)this$shape)).equals((Object)other$shape)) {
            return false;
        }
        GemColor this$color = this.getColor();
        GemColor other$color = other.getColor();
        return !(this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LevelingSourceData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialValue();
        result = result * 59 + this.getMaxLevel();
        result = result * 59 + this.getCost();
        result = result * 59 + this.getRequiredLevel();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Pair<UpgradeOperation, Integer> $upgradeModifier = this.getUpgradeModifier();
        result = result * 59 + ($upgradeModifier == null ? 43 : $upgradeModifier.hashCode());
        String $requiredAbility = this.getRequiredAbility();
        result = result * 59 + ($requiredAbility == null ? 43 : $requiredAbility.hashCode());
        Function<ItemStack, ResourceLocation> $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        Function<ItemStack, String> $translationPath = this.getTranslationPath();
        result = result * 59 + ($translationPath == null ? 43 : $translationPath.hashCode());
        GemShape $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : ((Object)((Object)$shape)).hashCode());
        GemColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        return result;
    }

    public String toString() {
        return "LevelingSourceData(id=" + this.getId() + ", initialValue=" + this.getInitialValue() + ", upgradeModifier=" + String.valueOf(this.getUpgradeModifier()) + ", maxLevel=" + this.getMaxLevel() + ", cost=" + this.getCost() + ", requiredLevel=" + this.getRequiredLevel() + ", requiredAbility=" + this.getRequiredAbility() + ", icon=" + String.valueOf(this.getIcon()) + ", translationPath=" + String.valueOf(this.getTranslationPath()) + ", shape=" + String.valueOf((Object)this.getShape()) + ", color=" + String.valueOf((Object)this.getColor()) + ")";
    }

    public static class LevelingSourceDataBuilder {
        private String id;
        private boolean initialValue$set;
        private int initialValue$value;
        private boolean maxLevel$set;
        private int maxLevel$value;
        private boolean cost$set;
        private int cost$value;
        private boolean requiredLevel$set;
        private int requiredLevel$value;
        private boolean requiredAbility$set;
        private String requiredAbility$value;
        private boolean shape$set;
        private GemShape shape$value;
        private boolean color$set;
        private GemColor color$value;
        private Function<ItemStack, ResourceLocation> icon = stack -> ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/abilities/missing.png");
        private Function<ItemStack, String> translationPath = stack -> "";
        private Pair<UpgradeOperation, Integer> upgradeModifier = Pair.of((Object)((Object)UpgradeOperation.ADD), (Object)0);

        private LevelingSourceDataBuilder id(String id) {
            this.id = id;
            return this;
        }

        public LevelingSourceDataBuilder upgradeModifier(UpgradeOperation operation, int step) {
            this.upgradeModifier = Pair.of((Object)((Object)operation), (Object)step);
            return this;
        }

        private LevelingSourceDataBuilder icon(Function<ItemStack, ResourceLocation> icon) {
            this.icon = icon;
            return this;
        }

        public LevelingSourceDataBuilder manualIcon(Function<ItemStack, ResourceLocation> icon) {
            return this.icon(icon);
        }

        public LevelingSourceDataBuilder genericIcon(String icon) {
            return this.manualIcon(stack -> ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/leveling_source/generic/" + icon + ".png")));
        }

        public LevelingSourceDataBuilder abilityIcon(String ability) {
            return this.manualIcon(stack -> DescriptionTextures.getAbilityCardTexture(stack, ability));
        }

        public LevelingSourceDataBuilder gem(GemShape shape, GemColor color) {
            this.shape(shape);
            this.color(color);
            return this;
        }

        LevelingSourceDataBuilder() {
        }

        public LevelingSourceDataBuilder initialValue(int initialValue) {
            this.initialValue$value = initialValue;
            this.initialValue$set = true;
            return this;
        }

        public LevelingSourceDataBuilder maxLevel(int maxLevel) {
            this.maxLevel$value = maxLevel;
            this.maxLevel$set = true;
            return this;
        }

        public LevelingSourceDataBuilder cost(int cost) {
            this.cost$value = cost;
            this.cost$set = true;
            return this;
        }

        public LevelingSourceDataBuilder requiredLevel(int requiredLevel) {
            this.requiredLevel$value = requiredLevel;
            this.requiredLevel$set = true;
            return this;
        }

        public LevelingSourceDataBuilder requiredAbility(String requiredAbility) {
            this.requiredAbility$value = requiredAbility;
            this.requiredAbility$set = true;
            return this;
        }

        public LevelingSourceDataBuilder translationPath(Function<ItemStack, String> translationPath) {
            this.translationPath = translationPath;
            return this;
        }

        public LevelingSourceDataBuilder shape(GemShape shape) {
            this.shape$value = shape;
            this.shape$set = true;
            return this;
        }

        public LevelingSourceDataBuilder color(GemColor color) {
            this.color$value = color;
            this.color$set = true;
            return this;
        }

        public LevelingSourceData build() {
            int initialValue$value = this.initialValue$value;
            if (!this.initialValue$set) {
                initialValue$value = LevelingSourceData.$default$initialValue();
            }
            int maxLevel$value = this.maxLevel$value;
            if (!this.maxLevel$set) {
                maxLevel$value = LevelingSourceData.$default$maxLevel();
            }
            int cost$value = this.cost$value;
            if (!this.cost$set) {
                cost$value = LevelingSourceData.$default$cost();
            }
            int requiredLevel$value = this.requiredLevel$value;
            if (!this.requiredLevel$set) {
                requiredLevel$value = LevelingSourceData.$default$requiredLevel();
            }
            String requiredAbility$value = this.requiredAbility$value;
            if (!this.requiredAbility$set) {
                requiredAbility$value = LevelingSourceData.$default$requiredAbility();
            }
            GemShape shape$value = this.shape$value;
            if (!this.shape$set) {
                shape$value = LevelingSourceData.$default$shape();
            }
            GemColor color$value = this.color$value;
            if (!this.color$set) {
                color$value = LevelingSourceData.$default$color();
            }
            return new LevelingSourceData(this.id, initialValue$value, this.upgradeModifier, maxLevel$value, cost$value, requiredLevel$value, requiredAbility$value, this.icon, this.translationPath, shape$value, color$value);
        }

        public String toString() {
            return "LevelingSourceData.LevelingSourceDataBuilder(id=" + this.id + ", initialValue$value=" + this.initialValue$value + ", upgradeModifier=" + String.valueOf(this.upgradeModifier) + ", maxLevel$value=" + this.maxLevel$value + ", cost$value=" + this.cost$value + ", requiredLevel$value=" + this.requiredLevel$value + ", requiredAbility$value=" + this.requiredAbility$value + ", icon=" + String.valueOf(this.icon) + ", translationPath=" + String.valueOf(this.translationPath) + ", shape$value=" + String.valueOf((Object)this.shape$value) + ", color$value=" + String.valueOf((Object)this.color$value) + ")";
        }
    }
}

