/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.models.items;

import com.google.common.collect.ImmutableList;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.utils.ModelSide;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.item.Item;

public class SidedCurioModel
extends CurioModel {
    private int slot;

    public SidedCurioModel(Item item) {
        super(item);
    }

    public ModelSide getSide() {
        return this.slot % 2 == 0 ? ModelSide.RIGHT : ModelSide.LEFT;
    }

    @Override
    @Nonnull
    protected Iterable<ModelPart> headParts() {
        Object object;
        Item item = this.getItem();
        if (item instanceof IRenderableCurio) {
            IRenderableCurio renderable = (IRenderableCurio)item;
            object = renderable.headParts().stream().filter(entry -> !entry.startsWith(this.getSide().getOpposite().getId())).map(this::getById).toList();
        } else {
            object = ImmutableList.of();
        }
        return object;
    }

    @Override
    @Nonnull
    protected Iterable<ModelPart> bodyParts() {
        Object object;
        Item item = this.getItem();
        if (item instanceof IRenderableCurio) {
            IRenderableCurio renderable = (IRenderableCurio)item;
            object = renderable.bodyParts().stream().filter(entry -> !entry.startsWith(this.getSide().getOpposite().getId())).map(this::getById).toList();
        } else {
            object = ImmutableList.of();
        }
        return object;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }
}

