/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.hidden.ClientHidden;
import com.cmdpro.databank.hidden.ClientHiddenListener;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.networking.Message;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UnlockHiddenSyncS2CPacket(ResourceLocation hidden) implements Message
{
    public static final CustomPacketPayload.Type<UnlockHiddenSyncS2CPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("unlock_hidden_block_sync"));

    public static UnlockHiddenSyncS2CPacket read(FriendlyByteBuf buf) {
        ResourceLocation block = buf.readResourceLocation();
        return new UnlockHiddenSyncS2CPacket(block);
    }

    public static void write(FriendlyByteBuf buf, UnlockHiddenSyncS2CPacket obj) {
        buf.writeResourceLocation(obj.hidden);
    }

    public CustomPacketPayload.Type<UnlockHiddenSyncS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext context) {
        if (!ClientHidden.unlocked.contains(this.hidden) && HiddenManager.hidden.containsKey(this.hidden)) {
            ClientHidden.unlocked.add(this.hidden);
            Hidden hidden2 = HiddenManager.hidden.get(this.hidden);
            ClientHiddenListener.HIDDEN_LISTENERS.forEach(listener -> listener.onUnhide(hidden2));
            ClientHiddenListener.HIDDEN_LISTENERS.forEach(listener -> listener.onUnhide(List.of(hidden2)));
        }
        if (HiddenManager.hidden.containsKey(this.hidden)) {
            HiddenManager.hidden.get((Object)this.hidden).type.getType().updateClient();
        }
    }
}

