/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.music;

import com.cmdpro.databank.music.MusicController;
import com.cmdpro.databank.music.MusicManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="databank")
public class MusicSystem {
    public static SimpleSoundInstance music;

    public static void init() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        ResourceManager resourceManager = mc.getResourceManager();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
            resourceManager2.registerReloadListener((PreparableReloadListener)MusicManager.getOrCreateInstance());
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            SoundManager manager;
            boolean playMusic = false;
            SoundEvent mus = null;
            List<MusicController> sortedControllers = MusicManager.musicControllers.values().stream().sorted((a, b) -> Integer.compare(b.priority, a.priority)).toList();
            for (MusicController i : sortedControllers) {
                SoundEvent getMusic = i.getMusic();
                if (!i.condition.isPlaying()) continue;
                SoundEvent override = i.condition.getMusicOverride(i);
                mus = override == null ? getMusic : override;
                playMusic = true;
                break;
            }
            if ((manager = mc.getSoundManager()).isActive((SoundInstance)music)) {
                mc.getMusicManager().stopPlaying();
                if (!playMusic) {
                    manager.stop((SoundInstance)music);
                } else if (!music.getLocation().equals((Object)mus.getLocation())) {
                    manager.stop((SoundInstance)music);
                }
            }
            if (!manager.isActive((SoundInstance)music) && !manager.isActive((SoundInstance)music) && playMusic) {
                music = SimpleSoundInstance.forMusic(mus);
                manager.play((SoundInstance)music);
            }
        }
    }
}

