/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.multiblock;

import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.multiblock.Multiblock;
import com.cmdpro.databank.multiblock.MultiblockPredicate;
import com.cmdpro.databank.multiblock.MultiblockPredicateSerializer;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;

public class MultiblockSerializer {
    public static final Codec<MultiblockPredicate> PREDICATE_CODEC = DatabankRegistries.MULTIBLOCK_PREDICATE_REGISTRY.byNameCodec().dispatch(MultiblockPredicate::getSerializer, pageSerializer -> pageSerializer.getCodec());
    public static final StreamCodec<RegistryFriendlyByteBuf, MultiblockPredicate> PREDICATE_STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceLocation(DatabankRegistries.MULTIBLOCK_PREDICATE_REGISTRY.getKey((Object)pValue.getSerializer()));
        pValue.getSerializer().getStreamCodec().encode(pBuffer, pValue);
    }, pBuffer -> {
        ResourceLocation type = pBuffer.readResourceLocation();
        MultiblockPredicateSerializer pageSerializer = (MultiblockPredicateSerializer)DatabankRegistries.MULTIBLOCK_PREDICATE_REGISTRY.get(type);
        MultiblockPredicate predicate = (MultiblockPredicate)pageSerializer.getStreamCodec().decode(pBuffer);
        return predicate;
    });
    public static final MapCodec<Multiblock> ORIGINAL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, PREDICATE_CODEC).fieldOf("key").forGetter(multiblock -> {
        Map<String, MultiblockPredicate> map = multiblock.key.entrySet().stream().map(a -> Map.entry(((Character)a.getKey()).toString(), (MultiblockPredicate)a.getValue())).collect(Collectors.toMap(a -> (String)a.getKey(), a -> (MultiblockPredicate)a.getValue()));
        return map;
    }), (App)Codec.STRING.listOf().listOf().fieldOf("layers").forGetter(multiblock -> multiblock.getMultiblockLayersList()), (App)BlockPos.CODEC.fieldOf("center").forGetter(multiblock -> multiblock.center)).apply((Applicative)instance, (key, layers, offset) -> {
        Map<Character, MultiblockPredicate> key2 = key.entrySet().stream().map(a -> Map.entry(Character.valueOf(((String)a.getKey()).charAt(0)), (MultiblockPredicate)a.getValue())).collect(Collectors.toMap(a -> (Character)a.getKey(), a -> (MultiblockPredicate)a.getValue()));
        return new Multiblock((String[][])layers.stream().map(a -> a.toArray(new String[0])).toList().toArray((T[])new String[0][]), key2, (BlockPos)offset);
    }));
    public static final Codec<Optional<WithConditions<Multiblock>>> CODEC = ConditionalOps.createConditionalCodecWithConditions((Codec)ORIGINAL_CODEC.codec());
    public static final StreamCodec<RegistryFriendlyByteBuf, Multiblock> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeMap(pValue.key, (a, b) -> a.writeChar((int)b.charValue()), (a, b) -> PREDICATE_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)a), b));
        pBuffer.writeBlockPos(pValue.center);
        ArrayList<List<String>> layers = new ArrayList<List<String>>();
        for (String[] i : pValue.multiblockLayers) {
            layers.add(List.of(i));
        }
        pBuffer.writeCollection(layers, (a, b) -> a.writeCollection((Collection)b, FriendlyByteBuf::writeUtf));
    }, pBuffer -> {
        HashMap<Character, MultiblockPredicate> key = new HashMap<Character, MultiblockPredicate>(pBuffer.readMap(a -> Character.valueOf(a.readChar()), a -> (MultiblockPredicate)PREDICATE_STREAM_CODEC.decode(pBuffer)));
        BlockPos offset = pBuffer.readBlockPos();
        List layers = pBuffer.readList(a -> a.readList(FriendlyByteBuf::readUtf).toArray(new String[0]));
        return new Multiblock((String[][])layers.toArray((T[])new String[0][]), key, offset);
    });

    public Multiblock read(ResourceLocation entryId, JsonObject json) {
        return ICondition.getWithWithConditionsCodec(CODEC, (DynamicOps)JsonOps.INSTANCE, (Object)json).orElse(null);
    }
}

