/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model.entity;

import com.cmdpro.databank.model.entity.DatabankEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class DatabankLivingEntityModel<T extends LivingEntity>
extends DatabankEntityModel<T> {
    @Override
    public void renderModel(T pEntity, float partialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult) {
        pPoseStack.pushPose();
        float scale = pEntity.getScale();
        pPoseStack.scale(scale, scale, scale);
        this.setupRotations(pEntity, pPoseStack, partialTick, scale);
        super.renderModel(pEntity, partialTick, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor, normalMult);
        pPoseStack.popPose();
    }

    public Vec2 getHeadRot(T entity, float partialTicks) {
        Entity entity2;
        float bodyRot = Mth.rotLerp((float)partialTicks, (float)((LivingEntity)entity).yBodyRotO, (float)((LivingEntity)entity).yBodyRot);
        float headRot = Mth.rotLerp((float)partialTicks, (float)((LivingEntity)entity).yHeadRotO, (float)((LivingEntity)entity).yHeadRot);
        float yRot = headRot - bodyRot;
        if (this.getShouldSit(entity) && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            bodyRot = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            yRot = headRot - bodyRot;
            float f7 = Mth.wrapDegrees((float)yRot);
            if (f7 < -85.0f) {
                f7 = -85.0f;
            }
            if (f7 >= 85.0f) {
                f7 = 85.0f;
            }
            bodyRot = headRot - f7;
            if (f7 * f7 > 2500.0f) {
                bodyRot += f7 * 0.2f;
            }
            yRot = headRot - bodyRot;
        }
        float xRot = Mth.lerp((float)partialTicks, (float)((LivingEntity)entity).xRotO, (float)entity.getXRot());
        if (this.isEntityUpsideDown(entity)) {
            xRot *= -1.0f;
            yRot *= -1.0f;
        }
        yRot = Mth.wrapDegrees((float)yRot);
        return new Vec2(xRot, yRot);
    }

    public float getYBodyRot(T entity, float partialTicks) {
        Entity entity2;
        float bodyRot = Mth.rotLerp((float)partialTicks, (float)((LivingEntity)entity).yBodyRotO, (float)((LivingEntity)entity).yBodyRot);
        float headRot = Mth.rotLerp((float)partialTicks, (float)((LivingEntity)entity).yHeadRotO, (float)((LivingEntity)entity).yHeadRot);
        if (this.getShouldSit(entity) && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            bodyRot = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            float yRot = headRot - bodyRot;
            float f7 = Mth.wrapDegrees((float)yRot);
            if (f7 < -85.0f) {
                f7 = -85.0f;
            }
            if (f7 >= 85.0f) {
                f7 = 85.0f;
            }
            bodyRot = headRot - f7;
            if (f7 * f7 > 2500.0f) {
                bodyRot += f7 * 0.2f;
            }
        }
        if (this.isShaking(entity)) {
            bodyRot += (float)(Math.cos((double)((LivingEntity)entity).tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        return bodyRot;
    }

    public boolean isEntityUpsideDown(T entity) {
        return LivingEntityRenderer.isEntityUpsideDown(entity);
    }

    public boolean getShouldSit(T entity) {
        return entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
    }

    protected boolean isShaking(T entity) {
        return entity.isFullyFrozen();
    }

    protected void setupRotations(T entity, PoseStack poseStack, float partialTick, float scale) {
        float yBodyRot = this.getYBodyRot(entity, partialTick);
        if (!entity.hasPose(Pose.SLEEPING)) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yBodyRot));
        }
        if (((LivingEntity)entity).deathTime > 0) {
            float f = ((float)((LivingEntity)entity).deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            poseStack.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees(entity)));
        } else if (entity.isAutoSpinAttack()) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f - entity.getXRot()));
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)((LivingEntity)entity).tickCount + partialTick) * -75.0f));
        } else if (entity.hasPose(Pose.SLEEPING)) {
            Direction direction = entity.getBedOrientation();
            float f1 = direction != null ? DatabankLivingEntityModel.sleepDirectionToRotation(direction) : yBodyRot;
            poseStack.mulPose(Axis.YP.rotationDegrees(f1));
            poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees(entity)));
            poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (this.isEntityUpsideDown(entity)) {
            poseStack.translate(0.0f, (entity.getBbHeight() + 0.1f) / scale, 0.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    private static float sleepDirectionToRotation(Direction facing) {
        switch (facing) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected float getFlipDegrees(T livingEntity) {
        return 90.0f;
    }
}

