/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankPartDefinition;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelPose {
    public List<ModelPosePart> parts;
    public final HashMap<String, ModelPosePart> stringToPart;

    public ModelPose(List<ModelPosePart> parts, HashMap<String, ModelPosePart> stringToPart) {
        this.parts = parts;
        this.stringToPart = stringToPart;
    }

    public static class ModelPosePart {
        public DatabankPartDefinition part;
        public List<ModelPosePart> children;
        public Vector3f pos;
        public Vector3f rotation;
        public Vector3f scale;

        public ModelPosePart(DatabankPartDefinition part, List<ModelPosePart> children, Vector3f pos, Vector3f rotation, Vector3f scale) {
            this.part = part;
            this.children = children;
            this.pos = pos;
            this.rotation = rotation;
            this.scale = scale;
        }

        public void offsetPosition(Vector3f offset) {
            this.pos.add(-offset.x, -offset.y, offset.z);
        }

        public void offsetRotation(Vector3f offset) {
            this.rotation.add((Vector3fc)offset);
        }

        public void offsetScale(Vector3f offset) {
            this.scale.add((Vector3fc)offset);
        }

        public void render(DatabankModel model, float partialTick, PoseStack pPoseStack, VertexConsumer pConsumer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult, boolean isShadedByNormal, Quaternionf quaternionf) {
            Vec3 x0y0z1;
            pPoseStack.pushPose();
            ArrayList<DatabankPartDefinition.Face> faces = null;
            if (this.part.isCube) {
                pPoseStack.pushPose();
                Vec3 origin = new Vec3((double)this.part.origin.x, (double)this.part.origin.y, (double)this.part.origin.z);
                Vec3 x0y0z0 = new Vec3(0.0, 0.0, 0.0).add((double)(-this.part.inflate), (double)this.part.inflate, (double)(-this.part.inflate)).add(origin);
                Vec3 x1y0z0 = new Vec3((double)this.part.dimensions.x, 0.0, 0.0).add((double)this.part.inflate, (double)this.part.inflate, (double)(-this.part.inflate)).add(origin);
                Vec3 x1y1z0 = new Vec3((double)this.part.dimensions.x, (double)this.part.dimensions.y, 0.0).add((double)this.part.inflate, (double)(-this.part.inflate), (double)(-this.part.inflate)).add(origin);
                Vec3 x0y1z0 = new Vec3(0.0, (double)this.part.dimensions.y, 0.0).add((double)(-this.part.inflate), (double)(-this.part.inflate), (double)(-this.part.inflate)).add(origin);
                x0y0z1 = new Vec3(0.0, 0.0, (double)this.part.dimensions.z).add((double)(-this.part.inflate), (double)this.part.inflate, (double)this.part.inflate).add(origin);
                Vec3 x1y0z1 = new Vec3((double)this.part.dimensions.x, 0.0, (double)this.part.dimensions.z).add((double)this.part.inflate, (double)this.part.inflate, (double)this.part.inflate).add(origin);
                Vec3 x1y1z1 = new Vec3((double)this.part.dimensions.x, (double)this.part.dimensions.y, (double)this.part.dimensions.z).add((double)this.part.inflate, (double)(-this.part.inflate), (double)this.part.inflate).add(origin);
                Vec3 x0y1z1 = new Vec3(0.0, (double)this.part.dimensions.y, (double)this.part.dimensions.z).add((double)(-this.part.inflate), (double)(-this.part.inflate), (double)this.part.inflate).add(origin);
                float uMin = (float)this.part.texOffset.x + this.part.dimensions.z;
                float vMin = this.part.texOffset.y;
                float uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x;
                float vMax = (float)this.part.texOffset.y + this.part.dimensions.z;
                if (this.part.mirror) {
                    float uMinBackup = uMin;
                    uMin = uMax;
                    uMax = uMinBackup;
                }
                ArrayList<DatabankPartDefinition.Vertex> up = new ArrayList<DatabankPartDefinition.Vertex>();
                up.add(new DatabankPartDefinition.Vertex(x1y1z1, uMin, vMin));
                up.add(new DatabankPartDefinition.Vertex(x0y1z1, uMax, vMin));
                up.add(new DatabankPartDefinition.Vertex(x0y1z0, uMax, vMax));
                up.add(new DatabankPartDefinition.Vertex(x1y1z0, uMin, vMax));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x;
                vMin = this.part.texOffset.y;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x + this.part.dimensions.x;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z;
                if (this.part.mirror) {
                    float uMinBackup = uMin;
                    uMin = uMax;
                    uMax = uMinBackup;
                }
                ArrayList<DatabankPartDefinition.Vertex> down = new ArrayList<DatabankPartDefinition.Vertex>();
                down.add(new DatabankPartDefinition.Vertex(x1y0z1, uMin, vMin));
                down.add(new DatabankPartDefinition.Vertex(x0y0z1, uMax, vMin));
                down.add(new DatabankPartDefinition.Vertex(x0y0z0, uMax, vMax));
                down.add(new DatabankPartDefinition.Vertex(x1y0z0, uMin, vMax));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z;
                uMax = this.part.texOffset.x;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z + this.part.dimensions.y;
                if (this.part.mirror) {
                    float uMinBackup = uMin;
                    uMin = uMax;
                    uMax = uMinBackup;
                }
                ArrayList<DatabankPartDefinition.Vertex> east = new ArrayList<DatabankPartDefinition.Vertex>();
                east.add(new DatabankPartDefinition.Vertex(x1y1z1, uMax, vMin));
                east.add(new DatabankPartDefinition.Vertex(x1y1z0, uMin, vMin));
                east.add(new DatabankPartDefinition.Vertex(x1y0z0, uMin, vMax));
                east.add(new DatabankPartDefinition.Vertex(x1y0z1, uMax, vMax));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z + this.part.dimensions.y;
                if (this.part.mirror) {
                    float uMinBackup = uMin;
                    uMin = uMax;
                    uMax = uMinBackup;
                }
                ArrayList<DatabankPartDefinition.Vertex> north = new ArrayList<DatabankPartDefinition.Vertex>();
                north.add(new DatabankPartDefinition.Vertex(x1y1z0, uMin, vMin));
                north.add(new DatabankPartDefinition.Vertex(x0y1z0, uMax, vMin));
                north.add(new DatabankPartDefinition.Vertex(x0y0z0, uMax, vMax));
                north.add(new DatabankPartDefinition.Vertex(x1y0z0, uMin, vMax));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x + this.part.dimensions.z;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z + this.part.dimensions.y;
                if (this.part.mirror) {
                    float uMinBackup = uMin;
                    uMin = uMax;
                    uMax = uMinBackup;
                }
                ArrayList<DatabankPartDefinition.Vertex> west = new ArrayList<DatabankPartDefinition.Vertex>();
                west.add(new DatabankPartDefinition.Vertex(x0y1z1, uMin, vMin));
                west.add(new DatabankPartDefinition.Vertex(x0y1z0, uMax, vMin));
                west.add(new DatabankPartDefinition.Vertex(x0y0z0, uMax, vMax));
                west.add(new DatabankPartDefinition.Vertex(x0y0z1, uMin, vMax));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x + this.part.dimensions.z;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x + this.part.dimensions.z + this.part.dimensions.x;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z + this.part.dimensions.y;
                if (this.part.mirror) {
                    float uMinBackup = uMin;
                    uMin = uMax;
                    uMax = uMinBackup;
                }
                ArrayList<DatabankPartDefinition.Vertex> south = new ArrayList<DatabankPartDefinition.Vertex>();
                south.add(new DatabankPartDefinition.Vertex(x1y1z1, uMax, vMin));
                south.add(new DatabankPartDefinition.Vertex(x0y1z1, uMin, vMin));
                south.add(new DatabankPartDefinition.Vertex(x0y0z1, uMin, vMax));
                south.add(new DatabankPartDefinition.Vertex(x1y0z1, uMax, vMax));
                boolean[] facesVisible = new boolean[]{true, true, true, true, true, true};
                Vec3[] normals = new Vec3[]{new Vec3(0.0, 1.0 * normalMult.y, 0.0), new Vec3(0.0, -1.0 * normalMult.y, 0.0), new Vec3(1.0 * normalMult.x, 0.0, 0.0), new Vec3(0.0, 0.0, -1.0 * normalMult.z), new Vec3(-1.0 * normalMult.x, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0 * normalMult.z)};
                if ((double)(this.part.dimensions.x + this.part.inflate) <= 0.001 && (double)(this.part.dimensions.x + this.part.inflate) >= -0.001) {
                    facesVisible[2] = false;
                }
                if ((double)(this.part.dimensions.y + this.part.inflate) <= 0.001 && (double)(this.part.dimensions.y + this.part.inflate) >= -0.001) {
                    facesVisible[1] = false;
                }
                if ((double)(this.part.dimensions.z + this.part.inflate) <= 0.001 && (double)(this.part.dimensions.z + this.part.inflate) >= -0.001) {
                    facesVisible[5] = false;
                }
                faces = new ArrayList();
                if (facesVisible[0]) {
                    faces.add(new DatabankPartDefinition.Face(up, normals[0]));
                }
                if (facesVisible[1]) {
                    faces.add(new DatabankPartDefinition.Face(down, normals[1]));
                }
                if (facesVisible[2]) {
                    faces.add(new DatabankPartDefinition.Face(east, normals[2]));
                }
                if (facesVisible[3]) {
                    faces.add(new DatabankPartDefinition.Face(north, normals[3]));
                }
                if (facesVisible[4]) {
                    faces.add(new DatabankPartDefinition.Face(west, normals[4]));
                }
                if (facesVisible[5]) {
                    faces.add(new DatabankPartDefinition.Face(south, normals[5]));
                }
                Matrix4f matrix4f = new Matrix4f();
                matrix4f.rotateZYX(this.part.rotation.z, this.part.rotation.y, this.part.rotation.x);
                quaternionf.rotateZYX(this.part.rotation.z, -this.part.rotation.y, this.part.rotation.x);
                for (DatabankPartDefinition.Face i : faces) {
                    for (DatabankPartDefinition.Vertex j : i.vertices) {
                        Vector3f pos = j.pos.toVector3f();
                        matrix4f.transformPosition(pos);
                        pos.add((Vector3fc)new Vector3f(this.pos.x, this.pos.y, this.pos.z));
                        j.pos = new Vec3((double)pos.x, (double)pos.y, (double)pos.z);
                    }
                }
                pPoseStack.popPose();
            }
            if (this.part.isMesh) {
                pPoseStack.translate(this.pos.x / 16.0f, this.pos.y / 16.0f, this.pos.z / 16.0f);
                Matrix4f matrix4f = new Matrix4f();
                matrix4f.rotateXYZ(this.rotation.x, -this.rotation.y, this.rotation.z);
                quaternionf.rotateXYZ(this.rotation.x, this.rotation.y, this.rotation.z);
                List faces2 = this.part.faces.orElse(null);
                if (faces2 != null) {
                    faces = new ArrayList<DatabankPartDefinition.Face>();
                    for (Object i : faces2) {
                        if (i.size() != 3 && i.size() != 4) continue;
                        ArrayList<DatabankPartDefinition.Vertex> verts = new ArrayList<DatabankPartDefinition.Vertex>();
                        x0y0z1 = i.iterator();
                        while (x0y0z1.hasNext()) {
                            DatabankPartDefinition.Vertex j = (DatabankPartDefinition.Vertex)x0y0z1.next();
                            Vector3f pos = matrix4f.transformPosition(j.pos.toVector3f());
                            verts.add(new DatabankPartDefinition.Vertex(new Vec3((double)pos.x, (double)pos.y, (double)pos.z), j.u, j.v));
                        }
                        Vec3 vecA = ((DatabankPartDefinition.Vertex)i.get((int)1)).pos.subtract(((DatabankPartDefinition.Vertex)i.get((int)0)).pos);
                        Vec3 vecB = ((DatabankPartDefinition.Vertex)i.get((int)2)).pos.subtract(((DatabankPartDefinition.Vertex)i.get((int)0)).pos);
                        Vector3f normal = vecA.cross(vecB).toVector3f().normalize();
                        faces.add(new DatabankPartDefinition.Face(verts, new Vec3((double)normal.x, (double)normal.y, (double)normal.z)));
                    }
                }
            }
            if (faces != null) {
                for (DatabankPartDefinition.Face i : faces) {
                    if (i.vertices.size() != 3 && i.vertices.size() != 4) continue;
                    Vector3f normal = i.normal.toVector3f().rotate((Quaternionfc)quaternionf);
                    if (!isShadedByNormal) {
                        normal = new Vec3(0.0, 1.0, 0.0).multiply(normalMult).toVector3f();
                    }
                    for (DatabankPartDefinition.Vertex j : i.vertices) {
                        float x = (float)j.pos.x() / 16.0f;
                        float y = (float)j.pos.y() / 16.0f;
                        float z = (float)j.pos.z() / 16.0f;
                        pConsumer.addVertex(pPoseStack.last(), x, y, z);
                        pConsumer.setColor(pColor);
                        pConsumer.setUv((float)j.u / (float)model.textureSize.x, (float)j.v / (float)model.textureSize.y);
                        pConsumer.setOverlay(pPackedOverlay);
                        pConsumer.setLight(pPackedLight);
                        pConsumer.setNormal(normal.x, normal.y, normal.z);
                    }
                    if (i.vertices.size() != 3) continue;
                    DatabankPartDefinition.Vertex j = i.vertices.getLast();
                    float x = (float)j.pos.x() / 16.0f;
                    float y = (float)j.pos.y() / 16.0f;
                    float z = (float)j.pos.z() / 16.0f;
                    pConsumer.addVertex(pPoseStack.last(), x, y, z);
                    pConsumer.setColor(pColor);
                    pConsumer.setUv((float)j.u / (float)model.textureSize.x, (float)j.v / (float)model.textureSize.y);
                    pConsumer.setOverlay(pPackedOverlay);
                    pConsumer.setLight(pPackedLight);
                    pConsumer.setNormal(normal.x, normal.y, normal.z);
                }
            }
            pPoseStack.popPose();
        }
    }
}

