/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.mixin.client;

import com.cmdpro.databank.DatabankUtils;
import com.cmdpro.databank.hidden.types.BlockHiddenType;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockColors.class})
public abstract class BlockColorsMixin {
    @Shadow
    @Final
    private Map<Block, BlockColor> blockColors;
    @Shadow
    @Final
    private Map<Block, Set<Property<?>>> coloringStates;

    @Inject(method={"getColor(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getColor(BlockState state, Level level, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        Block block;
        if (state != null && (block = BlockHiddenType.getHiddenBlockClient(state)) != null && block != state.getBlock()) {
            BlockState state2 = DatabankUtils.changeBlockType(state, block);
            BlockColor blockcolor = this.blockColors.get(state2.getBlock());
            if (blockcolor != null) {
                cir.setReturnValue((Object)blockcolor.getColor(state2, null, null, 0));
            } else {
                MapColor mapcolor = state2.getMapColor((BlockGetter)level, pos);
                cir.setReturnValue((Object)(mapcolor != null ? mapcolor.col : -1));
            }
        }
    }

    @Inject(method={"getColor(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;I)I"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getColor(BlockState state, BlockAndTintGetter level, BlockPos pos, int tintIndex, CallbackInfoReturnable<Integer> cir) {
        Block block;
        if (state != null && (block = BlockHiddenType.getHiddenBlockClient(state)) != null && block != state.getBlock()) {
            BlockState state2 = DatabankUtils.changeBlockType(state, block);
            BlockColor blockcolor = this.blockColors.get(state2.getBlock());
            cir.setReturnValue((Object)(blockcolor == null ? -1 : blockcolor.getColor(state2, level, pos, tintIndex)));
        }
    }

    @Inject(method={"getColoringProperties"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getColoringProperties(Block block, CallbackInfoReturnable<Set<Property<?>>> cir) {
        Block block2;
        if (block != null && (block2 = BlockHiddenType.getHiddenBlockClient(block)) != null && block2 != block) {
            cir.setReturnValue((Object)((Set)this.coloringStates.getOrDefault(block2, (Set<Property<?>>)ImmutableSet.of())));
        }
    }
}

