/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden.types;

import com.cmdpro.databank.ClientDatabankUtils;
import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.DatabankUtils;
import com.cmdpro.databank.config.DatabankClientConfig;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenCondition;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.hidden.HiddenSerializer;
import com.cmdpro.databank.hidden.HiddenTypeInstance;
import com.cmdpro.databank.hidden.conditions.ActualPlayerCondition;
import com.cmdpro.databank.mixin.client.BlockColorsAccessor;
import com.cmdpro.databank.registry.HiddenTypeRegistry;
import com.cmdpro.databank.rendering.ShaderHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockHiddenType
extends HiddenTypeInstance.HiddenType<BlockHiddenTypeInstance> {
    public static final BlockHiddenType INSTANCE = new BlockHiddenType();
    public static final MapCodec<BlockHiddenTypeInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.BLOCK).fieldOf("original").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), i -> (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(i).orElseThrow()).forGetter(type -> type.original), (App)ResourceKey.codec((ResourceKey)Registries.BLOCK).fieldOf("hidden_as").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), i -> (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(i).orElseThrow()).forGetter(type -> type.hiddenAs), (App)ComponentSerialization.CODEC.optionalFieldOf("name_override").forGetter(type -> type.nameOverride), (App)HiddenSerializer.HIDDEN_CONDITION_CODEC.optionalFieldOf("drop_original_loot_condition", (Object)new ActualPlayerCondition()).forGetter(type -> type.dropOriginalLootCondition), (App)Codec.BOOL.optionalFieldOf("should_overwrite_loot_if_hidden", (Object)true).forGetter(type -> type.shouldOverwriteLootIfHidden), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("should_apply_predicate").forGetter(type -> type.shouldApplyPredicate), (App)BlockHiddenOverride.CODEC.codec().listOf().optionalFieldOf("overrides", new ArrayList()).forGetter(type -> type.overrides)).apply((Applicative)instance, BlockHiddenTypeInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockHiddenTypeInstance> STREAM_CODEC = StreamCodec.of((buf, val) -> {
        buf.writeResourceKey((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)val.original).orElseThrow());
        buf.writeResourceKey((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)val.hiddenAs).orElseThrow());
        buf.writeOptional(val.nameOverride, (buf2, val2) -> ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf2), val2));
        buf.writeResourceKey((ResourceKey)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.getResourceKey((Object)val.dropOriginalLootCondition.getSerializer()).orElseThrow());
        val.dropOriginalLootCondition.getSerializer().streamCodec().encode(buf, (Object)val.dropOriginalLootCondition);
        buf.writeBoolean(val.shouldOverwriteLootIfHidden);
        buf.writeOptional(val.shouldApplyPredicate, (StreamEncoder)StatePropertiesPredicate.STREAM_CODEC);
        buf.writeCollection(val.overrides, (buf2, override) -> BlockHiddenOverride.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf2), override));
    }, buf -> {
        ResourceKey originalKey = buf.readResourceKey(Registries.BLOCK);
        ResourceKey hiddenAsKey = buf.readResourceKey(Registries.BLOCK);
        Block original = (Block)BuiltInRegistries.BLOCK.get(originalKey);
        Block hiddenAs = (Block)BuiltInRegistries.BLOCK.get(hiddenAsKey);
        Optional nameOverride = buf.readOptional(buf2 -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf2)));
        ResourceKey dropConditionKey = buf.readResourceKey(DatabankRegistries.HIDDEN_CONDITION_REGISTRY_KEY);
        HiddenCondition.Serializer dropConditionSerializer = (HiddenCondition.Serializer)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.get(dropConditionKey);
        HiddenCondition dropCondition = (HiddenCondition)dropConditionSerializer.streamCodec().decode(buf);
        boolean shouldOverwriteLootIfHidden = buf.readBoolean();
        Optional shouldApplyPredicate = buf.readOptional((StreamDecoder)StatePropertiesPredicate.STREAM_CODEC);
        List overrides = buf.readList(buf2 -> (BlockHiddenOverride)BlockHiddenOverride.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf2)));
        return new BlockHiddenTypeInstance(original, hiddenAs, nameOverride, dropCondition, shouldOverwriteLootIfHidden, shouldApplyPredicate, overrides);
    });
    private static HashMap<BlockState, Hidden> cache = new HashMap();

    @Override
    public MapCodec<BlockHiddenTypeInstance> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, BlockHiddenTypeInstance> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void updateClient() {
        cache.clear();
        ClientDatabankUtils.updateWorld();
    }

    @Override
    public void onRecieveClient() {
        ClientHandler.updateBlockColors();
    }

    public static boolean isVisible(Block block, Player player) {
        if (player.level().isClientSide) {
            return BlockHiddenType.isVisibleClient(block);
        }
        return BlockHiddenType.getHiddenBlock(block, player) == null;
    }

    public static boolean isVisible(BlockState block, Player player) {
        if (player.level().isClientSide) {
            return BlockHiddenType.isVisibleClient(block);
        }
        return BlockHiddenType.getHiddenBlock(block, player) == null;
    }

    public static boolean isVisibleClient(Block block) {
        return BlockHiddenType.getHiddenBlockClient(block) == null;
    }

    public static boolean isVisibleClient(BlockState block) {
        return BlockHiddenType.getHiddenBlockClient(block) == null;
    }

    public static Block getHiddenBlock(Block block, Player player) {
        if (player.level().isClientSide) {
            return BlockHiddenType.getHiddenBlockClient(block);
        }
        return BlockHiddenType.getHiddenBlock(block.defaultBlockState(), player);
    }

    public static Block getHiddenBlock(BlockState block, Player player) {
        if (player.level().isClientSide) {
            return BlockHiddenType.getHiddenBlockClient(block);
        }
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null) continue;
            if (type.isHidden(block.getBlock(), player)) {
                boolean applies = true;
                if (type.shouldApplyPredicate.isPresent()) {
                    applies = type.shouldApplyPredicate.get().matches(block);
                }
                if (!applies) continue;
                BlockHiddenOverride override = BlockHiddenType.findOverride(type, block);
                return override != null ? override.hiddenAs : type.hiddenAs;
            }
            if (!type.matches(block.getBlock())) continue;
            break;
        }
        return null;
    }

    public static boolean shouldDropOriginalBlock(Block block, Player player) {
        return BlockHiddenType.shouldDropOriginalBlock(block.defaultBlockState(), player);
    }

    public static boolean shouldDropOriginalBlock(BlockState block, Player player) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null) continue;
            if (type.isHidden(block.getBlock(), player) && type.shouldOverwriteLootIfHidden) {
                return false;
            }
            if (!type.matches(block.getBlock())) continue;
            boolean applies = true;
            if (type.shouldApplyPredicate.isPresent()) {
                applies = type.shouldApplyPredicate.get().matches(block);
            }
            if (!applies) continue;
            BlockHiddenOverride override = BlockHiddenType.findOverride(type, block);
            return override != null ? override.dropOriginalLootCondition.isUnlocked(player) : type.dropOriginalLootCondition.isUnlocked(player);
        }
        return false;
    }

    public static Block getHiddenBlock(Block block) {
        return BlockHiddenType.getHiddenBlock(block.defaultBlockState());
    }

    public static Block getHiddenBlock(BlockState block) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null || !type.matches(block.getBlock())) continue;
            boolean applies = true;
            if (type.shouldApplyPredicate.isPresent()) {
                applies = type.shouldApplyPredicate.get().matches(block);
            }
            if (!applies) continue;
            BlockHiddenOverride override = BlockHiddenType.findOverride(type, block);
            return override != null ? override.hiddenAs : type.hiddenAs;
        }
        return null;
    }

    public static Optional<Component> getHiddenBlockNameOverride(Block block) {
        return BlockHiddenType.getHiddenBlockNameOverride(block.defaultBlockState());
    }

    public static Optional<Component> getHiddenBlockNameOverride(BlockState block) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || !type.matches(block.getBlock())) continue;
            boolean applies = true;
            if (type.shouldApplyPredicate.isPresent()) {
                applies = type.shouldApplyPredicate.get().matches(block);
            }
            if (!applies) continue;
            BlockHiddenOverride override = BlockHiddenType.findOverride(type, block);
            return override != null ? override.nameOverride : type.nameOverride;
        }
        return Optional.empty();
    }

    public static BlockHiddenOverride findOverride(BlockHiddenTypeInstance instance, BlockState state) {
        for (BlockHiddenOverride j : instance.overrides) {
            if (!j.predicate.matches(state)) continue;
            return j;
        }
        return null;
    }

    public static Block getHiddenBlockClient(Block block) {
        return BlockHiddenType.getHiddenBlockClient(block.defaultBlockState());
    }

    public static Block getHiddenBlockClient(BlockState block) {
        BlockHiddenTypeInstance type;
        HiddenTypeInstance<?> hiddenTypeInstance;
        Hidden hidden = cache.get(block);
        if (!cache.containsKey(block)) {
            for (Map.Entry<ResourceLocation, Hidden> entry : new HashMap<ResourceLocation, Hidden>(HiddenManager.hidden).entrySet()) {
                HiddenTypeInstance<?> hiddenTypeInstance2 = entry.getValue().type;
                if (!(hiddenTypeInstance2 instanceof BlockHiddenTypeInstance)) continue;
                BlockHiddenTypeInstance type2 = (BlockHiddenTypeInstance)hiddenTypeInstance2;
                if (type2.original == null || type2.hiddenAs == null || !type2.matches(block.getBlock())) continue;
                hidden = entry.getValue();
                break;
            }
            cache.put(block, hidden);
        }
        if (hidden != null && (hiddenTypeInstance = hidden.type) instanceof BlockHiddenTypeInstance && (type = (BlockHiddenTypeInstance)hiddenTypeInstance).isHiddenClient(block.getBlock())) {
            boolean bl;
            boolean bl2 = true;
            if (type.shouldApplyPredicate.isPresent()) {
                bl = type.shouldApplyPredicate.get().matches(block);
            }
            if (bl) {
                BlockHiddenOverride override = BlockHiddenType.findOverride(type, block);
                return override != null ? override.hiddenAs : type.hiddenAs;
            }
        }
        return null;
    }

    private static class ClientHandler {
        static HashMap<Block, BlockColor> overriden = new HashMap();

        private ClientHandler() {
        }

        public static void updateBlockColors() {
            if (!ShaderHelper.isSodiumOrSimilarActive() && !DatabankClientConfig.forceAlternateHiddenColors) {
                return;
            }
            BlockColors colors = Minecraft.getInstance().getBlockColors();
            HashMap<Block, List> wrappingData = new HashMap<Block, List>();
            for (Hidden i : HiddenTypeRegistry.BLOCK.get().getHiddenOfType().values()) {
                BlockColor color;
                HiddenTypeInstance<?> hiddenTypeInstance = i.type;
                if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
                BlockHiddenTypeInstance blockHiddenTypeInstance = (BlockHiddenTypeInstance)hiddenTypeInstance;
                Block block = blockHiddenTypeInstance.original;
                WrappingData data = new WrappingData(blockHiddenTypeInstance, blockHiddenTypeInstance.shouldApplyPredicate);
                List wrapData = wrappingData.getOrDefault(block, new ArrayList());
                wrapData.add(data);
                wrappingData.put(block, wrapData);
                if (overriden.containsKey(block) || (color = ((BlockColorsAccessor)colors).getBlockColors().get(block)) == null) continue;
                overriden.put(block, color);
            }
            ArrayList<Block> blocksNotWrapped = new ArrayList<Block>(overriden.keySet());
            for (Map.Entry entry : wrappingData.entrySet()) {
                BlockColor original = overriden.get(entry.getKey());
                BlockColor wrapped = ClientHandler.createWrapped(original, (List)entry.getValue());
                ((BlockColorsAccessor)colors).getBlockColors().remove(entry.getKey());
                colors.register(wrapped, new Block[]{(Block)entry.getKey()});
                blocksNotWrapped.remove(entry.getKey());
            }
            for (Block block : blocksNotWrapped) {
                ((BlockColorsAccessor)colors).getBlockColors().remove(block);
                colors.register(overriden.get(block), new Block[]{block});
                overriden.remove(block);
            }
            Minecraft.getInstance().levelRenderer.allChanged();
        }

        public static BlockColor createWrapped(BlockColor original, List<WrappingData> wrappingData) {
            BlockColors colors = Minecraft.getInstance().getBlockColors();
            BlockColor wrapped = (state, level, pos, tintIndex) -> {
                HiddenTypeInstance finalType = null;
                for (WrappingData i : wrappingData) {
                    boolean apply = true;
                    if (i.shouldApplyPredicate.isPresent()) {
                        apply = i.shouldApplyPredicate.get().matches(state);
                    }
                    if (!apply) continue;
                    finalType = i.instance;
                }
                if (finalType != null && finalType.isHiddenClient(((BlockHiddenTypeInstance)finalType).original)) {
                    Block hiddenAs = ((BlockHiddenTypeInstance)finalType).hiddenAs;
                    for (BlockHiddenOverride i : ((BlockHiddenTypeInstance)finalType).overrides) {
                        if (!i.predicate.matches(state)) continue;
                        hiddenAs = i.hiddenAs;
                    }
                    if (hiddenAs != ((BlockHiddenTypeInstance)finalType).original) {
                        return colors.getColor(DatabankUtils.changeBlockType(state, hiddenAs), level, pos, tintIndex);
                    }
                }
                if (original != null) {
                    return original.getColor(state, level, pos, tintIndex);
                }
                return -1;
            };
            return wrapped;
        }

        private record WrappingData(BlockHiddenTypeInstance instance, Optional<StatePropertiesPredicate> shouldApplyPredicate) {
        }
    }

    public static class BlockHiddenTypeInstance
    extends HiddenTypeInstance<Block> {
        public Block original;
        public Block hiddenAs;
        public Optional<Component> nameOverride;
        public HiddenCondition dropOriginalLootCondition;
        public boolean shouldOverwriteLootIfHidden;
        public Optional<StatePropertiesPredicate> shouldApplyPredicate;
        public List<BlockHiddenOverride> overrides;

        public BlockHiddenTypeInstance(Block original, Block hiddenAs, Optional<Component> nameOverride, HiddenCondition dropOriginalLootCondition, boolean shouldOverwiteLootIfHidden, Optional<StatePropertiesPredicate> shouldApplyPredicate, List<BlockHiddenOverride> overrides) {
            this.original = original;
            this.hiddenAs = hiddenAs;
            this.nameOverride = nameOverride;
            this.dropOriginalLootCondition = dropOriginalLootCondition;
            this.shouldOverwriteLootIfHidden = shouldOverwiteLootIfHidden;
            this.shouldApplyPredicate = shouldApplyPredicate;
            this.overrides = overrides;
        }

        @Override
        public boolean matches(Block obj) {
            return obj.equals(this.original);
        }

        @Override
        public HiddenTypeInstance.HiddenType<? extends HiddenTypeInstance<Block>> getType() {
            return INSTANCE;
        }
    }

    public static class BlockHiddenOverride {
        public StatePropertiesPredicate predicate;
        public Block hiddenAs;
        public Optional<Component> nameOverride;
        public HiddenCondition dropOriginalLootCondition;
        public boolean shouldOverwriteLootIfHidden;
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockHiddenOverride> STREAM_CODEC = StreamCodec.of((buf, val) -> {
            StatePropertiesPredicate.STREAM_CODEC.encode(buf, (Object)val.predicate);
            buf.writeResourceKey((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)val.hiddenAs).orElseThrow());
            buf.writeOptional(val.nameOverride, (buf2, val2) -> ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf2), val2));
            buf.writeResourceKey((ResourceKey)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.getResourceKey((Object)val.dropOriginalLootCondition.getSerializer()).orElseThrow());
            val.dropOriginalLootCondition.getSerializer().streamCodec().encode(buf, (Object)val.dropOriginalLootCondition);
            buf.writeBoolean(val.shouldOverwriteLootIfHidden);
        }, buf -> {
            StatePropertiesPredicate predicate = (StatePropertiesPredicate)StatePropertiesPredicate.STREAM_CODEC.decode(buf);
            ResourceKey hiddenAsKey = buf.readResourceKey(Registries.BLOCK);
            Block hiddenAs = (Block)BuiltInRegistries.BLOCK.get(hiddenAsKey);
            Optional nameOverride = buf.readOptional(buf2 -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf2)));
            ResourceKey dropConditionKey = buf.readResourceKey(DatabankRegistries.HIDDEN_CONDITION_REGISTRY_KEY);
            HiddenCondition.Serializer dropConditionSerializer = (HiddenCondition.Serializer)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.get(dropConditionKey);
            HiddenCondition dropCondition = (HiddenCondition)dropConditionSerializer.streamCodec().decode(buf);
            boolean shouldOverwriteLootIfHidden = buf.readBoolean();
            return new BlockHiddenOverride(predicate, hiddenAs, nameOverride, dropCondition, shouldOverwriteLootIfHidden);
        });
        public static final MapCodec<BlockHiddenOverride> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StatePropertiesPredicate.CODEC.fieldOf("predicate").forGetter(type -> type.predicate), (App)ResourceKey.codec((ResourceKey)Registries.BLOCK).fieldOf("hidden_as").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), i -> (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(i).orElseThrow()).forGetter(type -> type.hiddenAs), (App)ComponentSerialization.CODEC.optionalFieldOf("name_override").forGetter(type -> type.nameOverride), (App)HiddenSerializer.HIDDEN_CONDITION_CODEC.optionalFieldOf("drop_original_loot_condition", (Object)new ActualPlayerCondition()).forGetter(type -> type.dropOriginalLootCondition), (App)Codec.BOOL.optionalFieldOf("should_overwrite_loot_if_hidden", (Object)true).forGetter(type -> type.shouldOverwriteLootIfHidden)).apply((Applicative)instance, BlockHiddenOverride::new));

        public BlockHiddenOverride(StatePropertiesPredicate predicate, Block hiddenAs, Optional<Component> nameOverride, HiddenCondition dropOriginalLootCondition, boolean shouldOverwiteLootIfHidden) {
            this.predicate = predicate;
            this.hiddenAs = hiddenAs;
            this.nameOverride = nameOverride;
            this.dropOriginalLootCondition = dropOriginalLootCondition;
            this.shouldOverwriteLootIfHidden = shouldOverwiteLootIfHidden;
        }
    }
}

