/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden.conditions;

import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.hidden.HiddenCondition;
import com.cmdpro.databank.hidden.HiddenSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;

public class OrCondition
extends HiddenCondition {
    public HiddenCondition conditionA;
    public HiddenCondition conditionB;

    public OrCondition(HiddenCondition conditionA, HiddenCondition conditionB) {
        this.conditionA = conditionA;
        this.conditionB = conditionB;
    }

    @Override
    public HiddenCondition.Serializer<?> getSerializer() {
        return OrConditionSerializer.INSTANCE;
    }

    @Override
    public boolean isUnlocked(Player player) {
        return this.conditionA.isUnlocked(player) || this.conditionB.isUnlocked(player);
    }

    public static class OrConditionSerializer
    extends HiddenCondition.Serializer<OrCondition> {
        public static final OrConditionSerializer INSTANCE = new OrConditionSerializer();
        public static final MapCodec<OrCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HiddenSerializer.HIDDEN_CONDITION_CODEC.fieldOf("conditionA").forGetter(condition -> condition.conditionA), (App)HiddenSerializer.HIDDEN_CONDITION_CODEC.fieldOf("conditionB").forGetter(condition -> condition.conditionB)).apply((Applicative)instance, OrCondition::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, OrCondition> STREAM_CODEC = StreamCodec.of((buf, value) -> {
            buf.writeResourceKey((ResourceKey)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.getResourceKey((Object)value.conditionA.getSerializer()).orElseThrow());
            value.conditionA.getSerializer().streamCodec().encode(buf, (Object)value.conditionA);
            buf.writeResourceKey((ResourceKey)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.getResourceKey((Object)value.conditionB.getSerializer()).orElseThrow());
            value.conditionB.getSerializer().streamCodec().encode(buf, (Object)value.conditionB);
        }, buf -> {
            ResourceKey conditionAKey = buf.readResourceKey(DatabankRegistries.HIDDEN_CONDITION_REGISTRY_KEY);
            HiddenCondition.Serializer conditionASerializer = (HiddenCondition.Serializer)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.get(conditionAKey);
            HiddenCondition conditionA = (HiddenCondition)conditionASerializer.streamCodec().decode(buf);
            ResourceKey conditionBKey = buf.readResourceKey(DatabankRegistries.HIDDEN_CONDITION_REGISTRY_KEY);
            HiddenCondition.Serializer conditionBSerializer = (HiddenCondition.Serializer)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.get(conditionBKey);
            HiddenCondition conditionB = (HiddenCondition)conditionBSerializer.streamCodec().decode(buf);
            return new OrCondition(conditionA, conditionB);
        });

        @Override
        public MapCodec<OrCondition> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, OrCondition> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

