/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden.conditions;

import com.cmdpro.databank.hidden.HiddenCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class AdvancementCondition
extends HiddenCondition {
    public ResourceKey<Advancement> advancement;

    public AdvancementCondition(ResourceKey<Advancement> advancement) {
        this.advancement = advancement;
    }

    @Override
    public boolean isUnlocked(Player player) {
        if (player != null) {
            AdvancementHolder advancement2 = ServerLifecycleHooks.getCurrentServer().getAdvancements().get(this.advancement.location());
            if (advancement2 != null) {
                return ((ServerPlayer)player).getAdvancements().getOrStartProgress(advancement2).isDone();
            }
            return false;
        }
        return true;
    }

    @Override
    public HiddenCondition.Serializer<?> getSerializer() {
        return AdvancementConditionSerializer.INSTANCE;
    }

    public static class AdvancementConditionSerializer
    extends HiddenCondition.Serializer<AdvancementCondition> {
        public static final AdvancementConditionSerializer INSTANCE = new AdvancementConditionSerializer();
        public static final MapCodec<AdvancementCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ADVANCEMENT).fieldOf("advancement").forGetter(condition -> condition.advancement)).apply((Applicative)instance, AdvancementCondition::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AdvancementCondition> STREAM_CODEC = StreamCodec.of((buf, val) -> buf.writeResourceKey(val.advancement), buf -> {
            ResourceKey advancement = buf.readResourceKey(Registries.ADVANCEMENT);
            return new AdvancementCondition((ResourceKey<Advancement>)advancement);
        });

        @Override
        public MapCodec<AdvancementCondition> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, AdvancementCondition> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

