/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank;

import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.mixin.PlayerAdvancementsAccessor;
import com.cmdpro.databank.mixin.client.ClientAdvancementsMixin;
import com.cmdpro.databank.networking.ModMessages;
import com.cmdpro.databank.networking.packet.LockAdvancementS2CPacket;
import com.cmdpro.databank.networking.packet.UnlockAdvancementS2CPacket;
import com.cmdpro.databank.networking.packet.UnlockHiddenSyncS2CPacket;
import com.cmdpro.databank.networking.packet.UnlockedHiddenSyncS2CPacket;
import com.cmdpro.databank.registry.CriteriaTriggerRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DatabankUtils {
    public static BlockState changeBlockType(BlockState originalState, Block newType) {
        BlockState state = newType.defaultBlockState();
        for (Property i : originalState.getProperties()) {
            state = DatabankUtils.copyProperty(i, originalState, state);
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(Property<T> property, BlockState original, BlockState newState) {
        if (original.hasProperty(property) && newState.hasProperty(property)) {
            return (BlockState)newState.setValue(property, original.getValue(property));
        }
        return newState;
    }

    public static ItemStack changeItemType(ItemStack originalStack, Item newType) {
        return new ItemStack(Holder.direct((Object)newType), originalStack.getCount(), originalStack.getComponentsPatch());
    }

    public static void updateHidden(Player player) {
        DatabankUtils.updateHidden(player, true);
    }

    public static void updateHidden(Player player, boolean updateListeners) {
        ArrayList<ResourceLocation> unlocked = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, Hidden> i : new HashMap<ResourceLocation, Hidden>(HiddenManager.hidden).entrySet()) {
            if (!i.getValue().condition.isUnlocked(player)) continue;
            unlocked.add(i.getKey());
        }
        ModMessages.sendToPlayer(new UnlockedHiddenSyncS2CPacket(unlocked, updateListeners), (ServerPlayer)player);
    }

    public static void unlockHiddenBlock(Player player, ResourceLocation hiddenBlock) {
        ModMessages.sendToPlayer(new UnlockHiddenSyncS2CPacket(hiddenBlock), (ServerPlayer)player);
    }

    public static void sendUnlockAdvancement(Player player, ResourceLocation advancement) {
        ModMessages.sendToPlayer(new UnlockAdvancementS2CPacket(advancement), (ServerPlayer)player);
    }

    public static void sendLockAdvancement(Player player, ResourceLocation advancement) {
        ModMessages.sendToPlayer(new LockAdvancementS2CPacket(advancement), (ServerPlayer)player);
    }

    public static float kelvinToCelcius(float kelvin) {
        return kelvin + 273.15f;
    }

    public static float celciusToKelvin(float celcius) {
        return celcius - 273.15f;
    }

    public static boolean hasAdvancement(Player player, ResourceLocation advancement) {
        AdvancementProgress progress = DatabankUtils.getAdvancementProgress(player, advancement);
        if (progress == null) {
            return false;
        }
        return progress.isDone();
    }

    public static AdvancementProgress getAdvancementProgress(Player player, ResourceLocation advancement) {
        if (player.level().isClientSide) {
            if (ClientHandler.isClientPlayer(player)) {
                return DatabankUtils.getAdvancementProgressClient(advancement);
            }
        } else {
            AdvancementHolder holder;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer server = player.level().getServer();
            if (server != null && (holder = server.getAdvancements().get(advancement)) != null) {
                return serverPlayer.getAdvancements().getOrStartProgress(holder);
            }
        }
        return null;
    }

    public static boolean hasAdvancementClient(ResourceLocation advancement) {
        return ClientHandler.hasAdvancementClient(advancement);
    }

    public static AdvancementProgress getAdvancementProgressClient(ResourceLocation advancement) {
        return ClientHandler.getProgress(advancement);
    }

    public static void recheckAdvancements(ServerPlayer player) {
        Map<AdvancementHolder, AdvancementProgress> progress = ((PlayerAdvancementsAccessor)player.getAdvancements()).getProgress();
        for (Map.Entry<AdvancementHolder, AdvancementProgress> i : progress.entrySet()) {
            if (!i.getValue().isDone()) continue;
            CriteriaTriggerRegistry.HAS_ADVANCEMENT.get().trigger(player, i.getKey().id());
            CriteriaTriggerRegistry.HAS_ADVANCEMENTS.get().trigger(player);
        }
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static boolean isClientPlayer(Player player) {
            return Minecraft.getInstance().player == player;
        }

        public static boolean hasAdvancementClient(ResourceLocation advancement) {
            AdvancementProgress progress = ClientHandler.getProgress(advancement);
            if (progress == null) {
                return false;
            }
            return progress.isDone();
        }

        public static AdvancementProgress getProgress(ResourceLocation advancement) {
            Map<AdvancementHolder, AdvancementProgress> progress;
            ClientAdvancements advancements;
            AdvancementNode node;
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection != null && (node = (advancements = connection.getAdvancements()).getTree().get(advancement)) != null && (progress = ((ClientAdvancementsMixin)advancements).getProgress()).containsKey(node.holder())) {
                return progress.get(node.holder());
            }
            return null;
        }
    }
}

