/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.holy;

import com.gametechbc.traveloptics.api.particle.AdvancedCylinderParticleManager;
import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.init.TOEffects;
import com.gametechbc.traveloptics.init.TOSounds;
import com.gametechbc.traveloptics.spells.TOSpellAnimations;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class NullflareSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "nullflare");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(5).setCooldownSeconds(40.0).build();

    public NullflareSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 16;
        this.baseManaCost = 40;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastStartAnimation() {
        return TOSpellAnimations.NULLFLARE_START;
    }

    public AnimationHolder getCastFinishAnimation() {
        return TOSpellAnimations.NULLFLARE_FINISH;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)TOSounds.NULLFLARE_TWO.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public int getRecastCount(int spellLevel, LivingEntity caster) {
        return 5;
    }

    public boolean stopSoundOnCancel() {
        return true;
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        boolean isCrouching;
        float radius = this.getRange(spellLevel);
        int duration = (int)this.getEffectDuration();
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(15, caster.position(), radius));
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, caster), 300, castSource, null), playerMagicData);
        }
        if (isCrouching = caster.isCrouching()) {
            MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.FIRE.get()).getTargetingColor(), radius), (double)caster.getX(), (double)(caster.getY() + (double)0.165f), (double)caster.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        } else {
            MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), radius), (double)caster.getX(), (double)(caster.getY() + (double)0.165f), (double)caster.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
        level.getEntities((Entity)caster, caster.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)caster)).forEach(target -> {
            LivingEntity livingEntity;
            if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).distanceToSqr((Entity)caster) < (double)(radius * radius)) {
                float baseDamage = this.getDamage(spellLevel, caster);
                if (isCrouching) {
                    MobEffectInstance fireEffect;
                    MobEffectInstance iceEffect = livingEntity.getEffect(TOEffects.NULLFLARE_ICE);
                    if (iceEffect != null) {
                        AdvancedCylinderParticleManager.spawnParticles(level, caster.position(), 15, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, ParticleDirection.OUTWARD, 2.0, 2.0, 0.0, 0.0, 0.0, 1.5, false);
                        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.EMBERS, (double)livingEntity.getX(), (double)(livingEntity.getY() + 1.0), (double)livingEntity.getZ(), (int)30, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
                        livingEntity.removeEffect(TOEffects.NULLFLARE_ICE);
                        int amplifier = iceEffect.getAmplifier();
                        double fireSpellPower = caster.getAttributeValue((Holder)AttributeRegistry.FIRE_SPELL_POWER);
                        double scaledDamage = (double)baseDamage * fireSpellPower * (1.0 + 0.85 * (double)amplifier);
                        DamageSources.applyDamage((Entity)livingEntity, (float)((float)scaledDamage), (DamageSource)this.getDamageSource((Entity)caster));
                    }
                    if ((fireEffect = livingEntity.getEffect(TOEffects.NULLFLARE_FIRE)) != null) {
                        livingEntity.addEffect(new MobEffectInstance(TOEffects.NULLFLARE_FIRE, duration, fireEffect.getAmplifier() + 1));
                    } else {
                        livingEntity.addEffect(new MobEffectInstance(TOEffects.NULLFLARE_FIRE, duration, 0));
                    }
                } else {
                    MobEffectInstance iceEffect;
                    MobEffectInstance fireEffect = livingEntity.getEffect(TOEffects.NULLFLARE_FIRE);
                    if (fireEffect != null) {
                        AdvancedCylinderParticleManager.spawnParticles(level, caster.position(), 15, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, ParticleDirection.OUTWARD, 2.0, 2.0, 0.0, 0.0, 0.0, 1.5, false);
                        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.EMBERS, (double)livingEntity.getX(), (double)(livingEntity.getY() + 1.0), (double)livingEntity.getZ(), (int)30, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
                        livingEntity.removeEffect(TOEffects.NULLFLARE_FIRE);
                        int amplifier = fireEffect.getAmplifier();
                        double iceSpellPower = caster.getAttributeValue((Holder)AttributeRegistry.ICE_SPELL_POWER);
                        double scaledDamage = (double)baseDamage * iceSpellPower * (1.0 + 0.85 * (double)amplifier);
                        DamageSources.applyDamage((Entity)livingEntity, (float)((float)scaledDamage), (DamageSource)this.getDamageSource((Entity)caster));
                    }
                    if ((iceEffect = livingEntity.getEffect(TOEffects.NULLFLARE_ICE)) != null) {
                        livingEntity.addEffect(new MobEffectInstance(TOEffects.NULLFLARE_ICE, duration, iceEffect.getAmplifier() + 1));
                    } else {
                        livingEntity.addEffect(new MobEffectInstance(TOEffects.NULLFLARE_ICE, duration, 0));
                    }
                }
            }
        });
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        float spellPower = this.getSpellPower(spellLevel, (Entity)caster);
        return 10.0f + spellPower * 5.0f;
    }

    private String getFireDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = this.getDamage(spellLevel, caster);
            double fireSpellPower = caster.getAttributes().hasAttribute((Holder)AttributeRegistry.FIRE_SPELL_POWER) ? caster.getAttributeValue((Holder)AttributeRegistry.FIRE_SPELL_POWER) : 1.0;
            float finalDamage = (float)((double)baseDamage * fireSpellPower);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (fireSpellPower > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
    }

    private String getIceDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = this.getDamage(spellLevel, caster);
            double iceSpellPower = caster.getAttributes().hasAttribute((Holder)AttributeRegistry.ICE_SPELL_POWER) ? caster.getAttributeValue((Holder)AttributeRegistry.ICE_SPELL_POWER) : 1.0;
            float finalDamage = (float)((double)baseDamage * iceSpellPower);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (iceSpellPower > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
    }

    private float getRange(int spellLevel) {
        return 2.0f + (float)spellLevel * 2.0f;
    }

    private float getEffectDuration() {
        return 200.0f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        float range = this.getRange(spellLevel);
        return List.of(Component.translatable((String)"ui.traveloptics.nullflare_blast", (Object[])new Object[]{this.getFireDamageText(spellLevel, caster)}), Component.translatable((String)"ui.traveloptics.nullflare_blast_fire_damage", (Object[])new Object[]{this.getFireDamageText(spellLevel, caster)}), Component.translatable((String)"ui.traveloptics.nullflare_blast_ice_damage", (Object[])new Object[]{this.getIceDamageText(spellLevel, caster)}), Component.translatable((String)"ui.traveloptics.radius", (Object[])new Object[]{Utils.stringTruncation((double)range, (int)2)}), Component.translatable((String)"ui.traveloptics.nullflare_blast.stacks"), Component.literal((String)"\u00a79T.O Magic 'n Extras"));
    }
}

