/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.events;

import com.gametechbc.traveloptics.init.TOEffects;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="traveloptics")
public class MobEffectsServerEvent {
    @SubscribeEvent
    public static void onPlayerCastInBlackout(SpellPreCastEvent event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance blackoutEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (blackoutEffect = player.getEffect(TOEffects.BLACKOUT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.literal((String)"Blackout Active: Spells are suppressed!").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickItemInBlackout(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance blackoutEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (blackoutEffect = player.getEffect(TOEffects.BLACKOUT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.literal((String)"Blackout Active: Cannot use item!").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void onManaRegenInBlackout(ChangeManaEvent event) {
        if (event.getEntity().hasEffect(TOEffects.BLACKOUT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerCastInCasting(SpellPreCastEvent event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance blackoutEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (blackoutEffect = player.getEffect(TOEffects.CASTING_EFFECT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"effect.traveloptics.casting.warning").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickItemInCasting(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance blackoutEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (blackoutEffect = player.getEffect(TOEffects.CASTING_EFFECT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"effect.traveloptics.casting.warning").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlockInCasting(PlayerInteractEvent.RightClickBlock event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance blackoutEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (blackoutEffect = player.getEffect(TOEffects.CASTING_EFFECT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"effect.traveloptics.casting.warning").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickItemInFrozenSight(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance frozenSightEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (frozenSightEffect = player.getEffect(TOEffects.FROZEN_SIGHT_EFFECT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.literal((String)"Wait till it ends!").withStyle(ChatFormatting.RED), true);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_STAND_HIT, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCastInFrozenSight(SpellPreCastEvent event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance frozenSightEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (frozenSightEffect = player.getEffect(TOEffects.FROZEN_SIGHT_EFFECT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.literal((String)"Wait till it ends!").withStyle(ChatFormatting.RED), true);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_STAND_HIT, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickInFrozenSight(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        MobEffectInstance effectInstance = player.getEffect(TOEffects.FROZEN_SIGHT_EFFECT);
        if (effectInstance != null) {
            player.setOnGround(true);
            player.setJumping(false);
        }
    }
}

