/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import com.gametechbc.traveloptics.api.TODataComponents;
import com.gametechbc.traveloptics.init.TOSounds;
import com.github.L_Ender.cataclysm.init.ModParticle;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpiritPointsManager {
    private static final String SPIRIT_POINTS_KEY = "SpiritPoints";
    private static final int MAX_SPIRIT_POINTS = 200;

    public static int getSpiritPoints(ItemStack stack) {
        if (stack.has(TODataComponents.SPIRIT_POINTS_COMPONENT)) {
            return ((CompoundTag)stack.get(TODataComponents.SPIRIT_POINTS_COMPONENT)).getInt(SPIRIT_POINTS_KEY);
        }
        return 0;
    }

    public static void setSpiritPoints(ItemStack stack, int points) {
        int cappedPoints = Math.min(points, 200);
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(SPIRIT_POINTS_KEY, cappedPoints);
        stack.set(TODataComponents.SPIRIT_POINTS_COMPONENT, (Object)nbt);
    }

    public static void addSpiritPoints(ItemStack stack, Player player, int amount) {
        int currentPoints = SpiritPointsManager.getSpiritPoints(stack);
        int newPoints = Math.min(currentPoints + amount, 200);
        SpiritPointsManager.setSpiritPoints(stack, newPoints);
        SpiritPointsManager.displayActionBar(player, newPoints);
        SpiritPointsManager.playSoundOnThreshold(player, currentPoints, newPoints);
        SpiritPointsManager.spawnParticlesOnThreshold(player, currentPoints, newPoints);
    }

    private static void displayActionBar(Player player, int points) {
        if (player instanceof ServerPlayer) {
            MutableComponent message = points >= 200 ? Component.literal((String)("\u2620 Soul Fragments: " + points)).withStyle(style -> style.withColor(16770714)).withStyle(ChatFormatting.BOLD) : Component.literal((String)("\u2620 Soul Fragments: " + points)).withStyle(style -> style.withColor(7733218));
            player.displayClientMessage((Component)message, true);
        }
    }

    private static void playSoundOnThreshold(Player player, int oldPoints, int newPoints) {
        if (player.level().isClientSide()) {
            return;
        }
        if (newPoints >= 200 && oldPoints < 200) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)TOSounds.SPIRIT_POINTS_MAX.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (newPoints >= 100 && oldPoints < 100) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)TOSounds.SPIRIT_POINTS_THRESHOLD_TWO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (newPoints >= 50 && oldPoints < 50) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)TOSounds.SPIRIT_POINTS_THRESHOLD_ONE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void spawnParticlesOnThreshold(Player player, int oldPoints, int newPoints) {
        if (newPoints >= 200 && oldPoints < 200) {
            Vec3 playerPosition = player.position();
            MagicManager.spawnParticles((Level)player.level(), (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)playerPosition.x, (double)playerPosition.y, (double)playerPosition.z, (int)20, (double)0.0, (double)1.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }
}

