/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.item;

import com.gametechbc.traveloptics.api.TODataComponents;
import com.gametechbc.traveloptics.api.item.HeavyAttributeCurio;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public abstract class AbstractWildAugment
extends HeavyAttributeCurio {
    private static final int EXPERIENCE_COST = 250;

    public AbstractWildAugment(Item.Properties properties) {
        super(properties, Map.of());
    }

    protected abstract List<AttributeEntry> getPositiveAttributeEntries();

    protected abstract List<AttributeEntry> getNegativeAttributeEntries();

    protected abstract List<AttributeEntry> getChanceAttributeEntries();

    protected abstract double getGlobalChance();

    protected abstract SoundEvent getAssignSound();

    protected abstract Component getInitialHoverText();

    protected abstract Component getAssignedHoverText();

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        if (stack.has(TODataComponents.ECHO_CURIO_COMPONENT)) {
            CompoundTag itemTag = (CompoundTag)stack.get(TODataComponents.ECHO_CURIO_COMPONENT);
            if (itemTag.getBoolean("attributesAssigned")) {
                tooltip.add(this.getAssignedHoverText());
            } else {
                tooltip.add(this.getInitialHoverText());
            }
        }
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        if (stack.has(TODataComponents.ECHO_CURIO_COMPONENT)) {
            CompoundTag itemTag = (CompoundTag)stack.get(TODataComponents.ECHO_CURIO_COMPONENT);
            return this.getAttributesFromNBT(itemTag);
        }
        return ImmutableMultimap.of();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        CompoundTag itemTag;
        ItemStack stack = player.getItemInHand(hand);
        if (stack.has(TODataComponents.ECHO_CURIO_COMPONENT) && !(itemTag = (CompoundTag)stack.get(TODataComponents.ECHO_CURIO_COMPONENT)).getBoolean("attributesAssigned")) {
            if (player.totalExperience >= 250) {
                this.assignRandomAttributes(stack);
                itemTag.putBoolean("attributesAssigned", true);
                stack.set(TODataComponents.ECHO_CURIO_COMPONENT, (Object)itemTag);
                player.giveExperiencePoints(-250);
                this.playSound(level, player, this.getAssignSound());
                if (!level.isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"item.traveloptics.augment_wild.assigned.success"), true);
                }
                return InteractionResultHolder.success((Object)stack);
            }
            if (!level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"item.traveloptics.augment_wild.assigned.failed"), true);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private void assignRandomAttributes(ItemStack stack) {
        Random random;
        List<AttributeEntry> possiblePositiveAttributes = this.getPositiveAttributeEntries();
        List<AttributeEntry> possibleNegativeAttributes = this.getNegativeAttributeEntries();
        List<AttributeEntry> possibleChanceAttributes = this.getChanceAttributeEntries();
        if (!possiblePositiveAttributes.isEmpty()) {
            AttributeEntry selectedPositiveEntry = this.selectRandomAttributeEntry(possiblePositiveAttributes);
            double positiveValue = this.selectRandomValue(selectedPositiveEntry.getMinValue(), selectedPositiveEntry.getMaxValue());
            this.saveAttributeToComponent(stack, selectedPositiveEntry.getAttribute(), selectedPositiveEntry.getOperation(), positiveValue, "positiveAttribute");
        }
        if (!possibleNegativeAttributes.isEmpty()) {
            AttributeEntry selectedNegativeEntry = this.selectRandomAttributeEntry(possibleNegativeAttributes);
            double negativeValue = this.selectRandomValue(selectedNegativeEntry.getMinValue(), selectedNegativeEntry.getMaxValue());
            this.saveAttributeToComponent(stack, selectedNegativeEntry.getAttribute(), selectedNegativeEntry.getOperation(), negativeValue, "negativeAttribute");
        }
        if ((random = new Random()).nextDouble() <= this.getGlobalChance() && !possibleChanceAttributes.isEmpty()) {
            AttributeEntry selectedChanceEntry = this.selectRandomAttributeEntry(possibleChanceAttributes);
            double chanceValue = this.selectRandomValue(selectedChanceEntry.getMinValue(), selectedChanceEntry.getMaxValue());
            this.saveAttributeToComponent(stack, selectedChanceEntry.getAttribute(), selectedChanceEntry.getOperation(), chanceValue, "chanceAttribute");
        }
    }

    private AttributeEntry selectRandomAttributeEntry(List<AttributeEntry> possibleAttributes) {
        double totalWeight = possibleAttributes.stream().mapToDouble(AttributeEntry::getWeight).sum();
        double randomValue = new Random().nextDouble() * totalWeight;
        for (AttributeEntry entry : possibleAttributes) {
            if (!((randomValue -= entry.getWeight()) <= 0.0)) continue;
            return entry;
        }
        return possibleAttributes.get(possibleAttributes.size() - 1);
    }

    private double selectRandomValue(double minValue, double maxValue) {
        Random random = new Random();
        return minValue + (maxValue - minValue) * random.nextDouble();
    }

    private void saveAttributeToComponent(ItemStack stack, Attribute attribute, AttributeModifier.Operation operation, double value, String tagPrefix) {
        if (!stack.has(TODataComponents.WILD_ATTRIBUTE_COMPONENT)) {
            stack.set(TODataComponents.WILD_ATTRIBUTE_COMPONENT, (Object)new CompoundTag());
        }
        CompoundTag componentTag = (CompoundTag)stack.get(TODataComponents.WILD_ATTRIBUTE_COMPONENT);
        CompoundTag attributeTag = new CompoundTag();
        attributeTag.putString("attribute", BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute).toString());
        attributeTag.putString("operation", operation.name());
        attributeTag.putDouble("value", value);
        componentTag.put(tagPrefix, (Tag)attributeTag);
        stack.set(TODataComponents.WILD_ATTRIBUTE_COMPONENT, (Object)componentTag);
    }

    private Multimap<Holder<Attribute>, AttributeModifier> getAttributesFromNBT(CompoundTag tag) {
        ImmutableMultimap.Builder attributeBuilder = new ImmutableMultimap.Builder();
        if (tag.contains("positiveAttribute")) {
            CompoundTag positiveTag = tag.getCompound("positiveAttribute");
            this.addAttributeFromNBT((ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier>)attributeBuilder, positiveTag);
        }
        if (tag.contains("negativeAttribute")) {
            CompoundTag negativeTag = tag.getCompound("negativeAttribute");
            this.addAttributeFromNBT((ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier>)attributeBuilder, negativeTag);
        }
        if (tag.contains("chanceAttribute")) {
            CompoundTag chanceTag = tag.getCompound("chanceAttribute");
            this.addAttributeFromNBT((ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier>)attributeBuilder, chanceTag);
        }
        return attributeBuilder.build();
    }

    private void addAttributeFromNBT(ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier> attributeBuilder, CompoundTag tag) {
        ResourceLocation attributeId = new ResourceLocation("traveloptics", tag.getString("attribute"));
        Attribute attribute = (Attribute)BuiltInRegistries.ATTRIBUTE.get(attributeId);
        try {
            AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)tag.getString("operation"));
            if (attribute != null) {
                AttributeModifier modifier = new AttributeModifier(new ResourceLocation("traveloptics", attribute.getDescriptionId()), tag.getDouble("value"), operation);
                attributeBuilder.put((Object)BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)attribute), (Object)modifier);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid attribute modifier operation: " + tag.getString("operation"));
        }
    }

    private void playSound(Level level, Player player, SoundEvent soundEvent) {
        if (!level.isClientSide && soundEvent != null) {
            level.playSound(null, player.blockPosition(), soundEvent, player.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public Component getName(ItemStack stack) {
        if (stack.has(TODataComponents.ECHO_CURIO_COMPONENT)) {
            CompoundTag tag = (CompoundTag)stack.get(TODataComponents.ECHO_CURIO_COMPONENT);
            if (tag.getBoolean("attributesAssigned")) {
                return Component.translatable((String)(stack.getItem().getDescriptionId(stack) + ".assigned"));
            }
            return Component.translatable((String)(stack.getItem().getDescriptionId(stack) + ".unassigned"));
        }
        return super.getName(stack);
    }

    public static class AttributeEntry {
        private final Attribute attribute;
        private final AttributeModifier.Operation operation;
        private final double minValue;
        private final double maxValue;
        private final double weight;

        public AttributeEntry(Attribute attribute, AttributeModifier.Operation operation, double minValue, double maxValue, double weight) {
            this.attribute = attribute;
            this.operation = operation;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.weight = weight;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public AttributeModifier.Operation getOperation() {
            return this.operation;
        }

        public double getMinValue() {
            return this.minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

