/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube.wrappers;

import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.core.filters.ItemFilterImpl;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemFilterWrapper {
    private static ItemFilter ofItemFilterSingle(RegistryAccessContainer cx, @Nullable Object o) {
        Ingredient ingredient;
        String str;
        if (o instanceof ItemFilter) {
            ItemFilter i = (ItemFilter)o;
            return i;
        }
        if (o instanceof String && !(str = (String)o).isEmpty()) {
            String first = str.substring(0, 1);
            String remaining = str.substring(1);
            switch (first) {
                case "*": {
                    return ItemFilter.ANY;
                }
                case "#": {
                    ResourceLocation location = ResourceLocation.parse((String)remaining);
                    TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
                    return new ItemFilterImpl.ByTag((TagKey<Item>)tag);
                }
                case "@": {
                    return itemStack -> {
                        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
                        return key.getNamespace().equals(remaining);
                    };
                }
                case "!": {
                    return ItemFilterWrapper.ofItemFilterSingle(cx, remaining.trim()).negate();
                }
            }
        }
        if ((ingredient = IngredientJS.wrap((RegistryAccessContainer)cx, (Object)o)).isEmpty()) {
            return ItemFilter.EMPTY;
        }
        return new ItemFilterImpl.ByIngredient(ingredient);
    }

    public static ItemFilter ofItemFilter(RegistryAccessContainer cx, Object o) {
        if (o instanceof List) {
            List list = (List)o;
            ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>(list.size());
            for (Object entry : list) {
                ItemFilter filter = ItemFilterWrapper.ofItemFilter(cx, entry);
                filters.add(filter);
            }
            return itemStack -> {
                for (ItemFilter filter : filters) {
                    if (!filter.test(itemStack)) continue;
                    return true;
                }
                return false;
            };
        }
        return ItemFilterWrapper.ofItemFilterSingle(cx, o);
    }
}

