/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.network;

import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.IOption;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.items.stick.ItemStick;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketStickOption(String key, String value, boolean notifyMessage) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, PacketStickOption> CODEC = CustomPacketPayload.codec(PacketStickOption::encode, PacketStickOption::new);
    public static final CustomPacketPayload.Type<PacketStickOption> ID = new CustomPacketPayload.Type(ConstructionStick.modLoc("stick_option"));

    private PacketStickOption(FriendlyByteBuf buffer) {
        this(buffer.readUtf(100), buffer.readUtf(100), buffer.readBoolean());
    }

    public PacketStickOption(IOption<?> option, boolean notify) {
        this(option.getKey(), option.getValueString(), notify);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.key);
        buffer.writeUtf(this.value);
        buffer.writeBoolean(this.notifyMessage);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(PacketStickOption msg, IPayloadContext ctx) {
            ctx.enqueueWork(() -> {
                Player patt0$temp;
                if (ctx.flow().isServerbound() && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack stick = StickUtil.holdingStick((Player)player);
                    if (stick == null) {
                        return;
                    }
                    StickOptions options = new StickOptions(stick);
                    IOption<?> option = options.get(msg.key);
                    if (option == null) {
                        return;
                    }
                    option.setValueString(msg.value);
                    if (msg.notifyMessage) {
                        ItemStick.optionMessage((Player)player, option);
                    }
                    player.getInventory().setChanged();
                }
            }).exceptionally(e -> {
                ctx.disconnect((Component)Component.translatable((String)"constructionstick.networking.stick_option.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

