/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.items.stick;

import java.text.NumberFormat;
import java.util.List;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.api.IStickTemplate;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.IOption;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.basics.option.StickUpgradesSelectable;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.registry.ModDataComponents;
import mrbysco.constructionstick.stick.StickJob;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemStick
extends Item {
    public ItemStick(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level level = context.getLevel();
        if (level.isClientSide || player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (ConstructionStick.undoHistory.isUndoActive(player)) {
            return ConstructionStick.undoHistory.undo(player, level, context.getClickedPos()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        StickJob job = ItemStick.getStickJob(player, level, new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), false), stack);
        return job.doIt() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isCrouching()) {
            if (level.isClientSide) {
                return InteractionResultHolder.fail((Object)stack);
            }
            StickJob job = ItemStick.getStickJob(player, level, BlockHitResult.miss((Vec3)player.getLookAngle(), (Direction)StickUtil.fromVector(player.getLookAngle()), (BlockPos)player.blockPosition()), stack);
            return job.doIt() ? InteractionResultHolder.success((Object)stack) : InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public static StickJob getStickJob(Player player, Level level, @Nullable BlockHitResult rayTraceResult, ItemStack stick) {
        StickJob stickJob = new StickJob(player, level, rayTraceResult, stick);
        stickJob.getSnapshots();
        return stickJob;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return false;
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return false;
    }

    public int remainingDurability(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void hurtItem(ItemStack stack, int amount, LivingEntity entity, EquipmentSlot slot) {
        if (stack.has(ModDataComponents.BATTERY_ENABLED)) {
            if (entity.hasInfiniteMaterials()) {
                return;
            }
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (storage != null) {
                int usage = ConstructionConfig.getStickProperties(this).getBatteryUsage();
                storage.extractEnergy(usage, false);
            }
        } else {
            stack.hurtAndBreak(amount, entity, slot);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (stack.has(ModDataComponents.UNBREAKABLE) && !stack.has(DataComponents.UNBREAKABLE)) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
        }
    }

    public void appendHoverText(@NotNull ItemStack itemstack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag extraInfo) {
        StickOptions options = new StickOptions(itemstack);
        int limit = ((IStickTemplate)options.upgrades.get()).getStickAction().getLimit(itemstack);
        String langTooltip = "constructionstick.tooltip.";
        if (Screen.hasShiftDown()) {
            for (int i = 1; i < options.allOptions.length; ++i) {
                IOption<?> opt = options.allOptions[i];
                lines.add((Component)Component.translatable((String)opt.getKeyTranslation()).withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)opt.getValueTranslation()).withStyle(ChatFormatting.GRAY)));
            }
            if (!options.upgrades.getUpgrades().isEmpty()) {
                lines.add((Component)Component.literal((String)""));
                lines.add((Component)Component.translatable((String)(langTooltip + "upgrades")).withStyle(ChatFormatting.GRAY));
                for (IStickTemplate upgrades : options.upgrades.getUpgrades()) {
                    lines.add((Component)Component.translatable((String)(options.upgrades.getKeyTranslation() + "." + upgrades.getRegistryName().toString())));
                }
                for (IStickTemplate specialUpgrades : options.upgrades.getSpecialUpgrades()) {
                    lines.add((Component)Component.translatable((String)(options.upgrades.getKeyTranslation() + "." + specialUpgrades.getRegistryName().toString())));
                }
            }
        } else {
            IEnergyStorage storage;
            StickUpgradesSelectable<IStickTemplate> upgrades = options.upgrades;
            lines.add((Component)Component.translatable((String)(langTooltip + "blocks"), (Object[])new Object[]{limit}).withStyle(ChatFormatting.GRAY));
            if (itemstack.has(ModDataComponents.BATTERY_ENABLED) && (storage = (IEnergyStorage)itemstack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
                int energy = storage.getEnergyStored();
                NumberFormat format = NumberFormat.getInstance();
                lines.add((Component)Component.translatable((String)"constructionstick.tooltip.storage", (Object[])new Object[]{format.format(energy), format.format(storage.getMaxEnergyStored())}).withStyle(ChatFormatting.RED));
            }
            lines.add((Component)Component.translatable((String)upgrades.getKeyTranslation()).withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)upgrades.getValueTranslation()).withStyle(ChatFormatting.WHITE)));
            lines.add((Component)Component.translatable((String)(langTooltip + "shift")).withStyle(ChatFormatting.AQUA));
        }
    }

    public static void optionMessage(Player player, IOption<?> option) {
        player.displayClientMessage((Component)Component.translatable((String)option.getKeyTranslation()).withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)option.getValueTranslation()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.translatable((String)option.getDescTranslation()).withStyle(ChatFormatting.WHITE)), true);
    }
}

