/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.init.data;

import dev.xkmc.arsdelight.init.ArsDelight;
import dev.xkmc.l2core.util.ConfigInit;
import dev.xkmc.l2core.util.ServerProxy;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.data.loading.DatagenModLoader;

public class ADModConfig {
    public static final Client CLIENT = (Client)ArsDelight.REGISTRATE.registerClient(Client::new);
    public static final Common COMMON = (Common)ArsDelight.REGISTRATE.registerUnsynced(Common::new);
    public static final Server SERVER = (Server)ArsDelight.REGISTRATE.registerSynced(Server::new);

    public static void init() {
    }

    public static class Client
    extends ConfigInit {
        Client(ConfigInit.Builder builder) {
            this.markPlain();
        }
    }

    public static class Common
    extends ConfigInit {
        public final ModConfigSpec.BooleanValue enableThirstCompat;

        Common(ConfigInit.Builder builder) {
            this.markPlain();
            this.enableThirstCompat = builder.text("Enable Thirst Was Taken compatibility").define("enableThirstCompat", true);
        }
    }

    public static class Server
    extends ConfigInit {
        public final ModConfigSpec.DoubleValue maxShieldingAbsorption;
        public final ModConfigSpec.DoubleValue wildenSpellDamageBonus;
        public final ModConfigSpec.DoubleValue wildenMaxManaBonus;
        public final ModConfigSpec.DoubleValue wildenManaRegenBonus;
        public final ModConfigSpec.BooleanValue drygmyFarmingToolPlainCopy;
        public final ModConfigSpec.IntValue drygmyFarmingDamageTool;

        Server(ConfigInit.Builder builder) {
            this.markPlain();
            this.maxShieldingAbsorption = builder.text("Max absorption allowed for Shielding I effect. Every level doubles the cap").defineInRange("maxShieldingAbsorption", 8.0, 2.0, 100.0);
            this.wildenSpellDamageBonus = builder.text("Wilden effect: spell damage bonus per level").defineInRange("wildenSpellDamageBonus", 0.2, 0.0, 1.0);
            this.wildenMaxManaBonus = builder.text("Wilden effect: max mana bonus per level").defineInRange("wildenMaxManaBonus", 0.2, 0.0, 1.0);
            this.wildenManaRegenBonus = builder.text("Wilden effect: mana regen bonus per level").defineInRange("wildenManaRegenBonus", 0.2, 0.0, 1.0);
            this.drygmyFarmingToolPlainCopy = builder.text("Drygmy farming: make a plain copy of the tool to prevent enchantments, affixes, and gems from taking effect").define("drygmyFarmingToolPlainCopy", false);
            this.drygmyFarmingDamageTool = builder.text("Drygmy farming: cost durability on the tool used for farming").defineInRange("drygmyFarmingDamageTool", 2, 0, 10000);
        }

        public <T> T getOrDefault(Function<Server, ModConfigSpec.ConfigValue<T>> func) {
            ModConfigSpec.ConfigValue<T> config = func.apply(this);
            Object def = config.getDefault();
            if (DatagenModLoader.isRunningDataGen()) {
                return (T)def;
            }
            if (ServerProxy.getRegistryAccess() == null) {
                return (T)def;
            }
            return (T)config.get();
        }
    }
}

