/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemStackFromIngredient {
    private final List<String> modPriorities;
    private final String tag;
    private final Ingredient ingredient;
    private final int count;
    @Nullable
    private ItemStack firstItemStack;

    public ItemStackFromIngredient(List<String> modPriorities, String tag, Ingredient ingredient, int count) {
        this.modPriorities = modPriorities;
        this.tag = tag;
        this.ingredient = ingredient;
        this.count = count;
    }

    public String getTag() {
        return this.tag;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack getFirstItemStack() {
        if (this.firstItemStack != null) {
            return this.firstItemStack;
        }
        ItemStack[] matchingStacks = this.ingredient.getItems();
        HashMap modPriorityIndex = Maps.newHashMap();
        for (int i = 0; i < this.modPriorities.size(); ++i) {
            modPriorityIndex.put(this.modPriorities.get(i), i);
        }
        ItemStack outputStack = Arrays.stream(matchingStacks).min(Comparator.comparingInt(e -> modPriorityIndex.getOrDefault(BuiltInRegistries.ITEM.getKey((Object)e.getItem()).getNamespace(), Integer.MAX_VALUE))).orElseThrow(() -> new IllegalStateException("No tag value found for " + this.tag)).copy();
        this.firstItemStack = outputStack.copy();
        this.firstItemStack.setCount(this.count);
        return this.firstItemStack;
    }

    public void writeToPacket(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.modPriorities.size());
        for (String modPriority : this.modPriorities) {
            buf.writeUtf(modPriority);
        }
        buf.writeUtf(this.tag);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)this.ingredient);
        buf.writeVarInt(this.count);
    }

    public static ItemStackFromIngredient readFromPacket(RegistryFriendlyByteBuf buf) {
        ArrayList modPriorities = Lists.newArrayList();
        int modPrioritiesSize = buf.readVarInt();
        for (int i = 0; i < modPrioritiesSize; ++i) {
            modPriorities.add(buf.readUtf());
        }
        String key = buf.readUtf();
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
        int count = buf.readVarInt();
        return new ItemStackFromIngredient(modPriorities, key, ingredient, count);
    }
}

